/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.ImageIcon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorAttributeIcon
extends ImageIcon {
    private DrawingEditor editor;
    AttributeKey<Color> key;
    private Rectangle colorRect = new Rectangle(1, 17, 20, 4);

    public ColorAttributeIcon(DrawingEditor editor, AttributeKey<Color> key, URL imageLocation) {
        super(imageLocation);
        this.editor = editor;
        this.key = key;
    }

    public ColorAttributeIcon(DrawingEditor editor, AttributeKey<Color> key, Image image) {
        super(image);
        this.editor = editor;
        this.key = key;
    }

    @Override
    public void paintIcon(Component c, Graphics gr, int x, int y) {
        Graphics2D g = (Graphics2D)gr;
        super.paintIcon(c, g, x, y);
        Color color = (Color)this.editor.getDefaultAttribute(this.key);
        if (color != null) {
            g.setColor(color);
            g.translate(x, y);
            g.fill(this.colorRect);
            g.translate(-x, -y);
        }
    }
}

