/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;

public class ColorChooserAction
extends AbstractSelectedAction {
    private AttributeKey key;
    private static JColorChooser colorChooser;

    public ColorChooserAction(DrawingEditor editor, AttributeKey key) {
        this(editor, key, null, null);
    }

    public ColorChooserAction(DrawingEditor editor, AttributeKey key, Icon icon) {
        this(editor, key, null, icon);
    }

    public ColorChooserAction(DrawingEditor editor, AttributeKey key, String name) {
        this(editor, key, name, null);
    }

    public ColorChooserAction(DrawingEditor editor, AttributeKey key, String name, Icon icon) {
        super(editor);
        this.key = key;
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        Color chosenColor;
        Color initialColor;
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        if ((initialColor = (Color)this.getEditor().getDefaultAttribute(this.key)) == null) {
            initialColor = Color.red;
        }
        if ((chosenColor = JColorChooser.showDialog((Component)e.getSource(), this.labels.getString("drawColor"), initialColor)) != null) {
            this.changeAttribute(chosenColor);
        }
    }

    public void changeAttribute(Color value) {
        Drawing drawing = this.getDrawing();
        for (Figure figure : this.getView().getSelectedFigures()) {
            figure.setAttribute(this.key, value);
        }
        this.getEditor().setDefaultAttribute(this.key, value);
    }

    public void selectionChanged(FigureSelectionEvent evt) {
    }
}

