/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupAction
extends AbstractSelectedAction {
    public static final String ID = "selectionGroup";
    private CompositeFigure prototype;

    public GroupAction(DrawingEditor editor) {
        this(editor, new GroupFigure());
    }

    public GroupAction(DrawingEditor editor, CompositeFigure prototype) {
        super(editor);
        this.prototype = prototype;
        this.labels.configureAction(this, ID);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.canGroup());
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean canGroup() {
        return this.getView().getSelectionCount() > 1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.canGroup()) {
            final DrawingView view = this.getView();
            final LinkedList<Figure> ungroupedFigures = new LinkedList<Figure>(view.getSelectedFigures());
            final CompositeFigure group = (CompositeFigure)this.prototype.clone();
            CompositeEdit edit = new CompositeEdit(this.labels.getString(ID)){

                public void redo() throws CannotRedoException {
                    super.redo();
                    GroupAction.this.groupFigures(view, group, ungroupedFigures);
                }

                public void undo() throws CannotUndoException {
                    GroupAction.this.ungroupFigures(view, group);
                    super.undo();
                }

                public boolean addEdit(UndoableEdit anEdit) {
                    return super.addEdit(anEdit);
                }
            };
            this.fireUndoableEditHappened(edit);
            this.groupFigures(view, group, ungroupedFigures);
            this.fireUndoableEditHappened(edit);
        }
    }

    public Collection<Figure> ungroupFigures(DrawingView view, CompositeFigure group) {
        LinkedList<Figure> figures = new LinkedList<Figure>(group.getChildren());
        view.clearSelection();
        group.basicRemoveAllChildren();
        view.getDrawing().basicAddAll(figures);
        view.getDrawing().remove(group);
        view.addToSelection(figures);
        return figures;
    }

    public void groupFigures(DrawingView view, CompositeFigure group, Collection<Figure> figures) {
        Collection<Figure> sorted = view.getDrawing().sort(figures);
        view.getDrawing().basicRemoveAll(figures);
        view.clearSelection();
        view.getDrawing().add(group);
        group.willChange();
        for (Figure f : sorted) {
            group.basicAdd(f);
        }
        group.changed();
        view.addToSelection(group);
    }
}

