/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestFileUtil {
    private static final Log LOG = LogFactory.getLog(TestFileUtil.class);
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", "/tmp"), "fu");
    private static String FILE = "x";
    private static String LINK = "y";
    private static String DIR = "dir";
    private File del = new File(TEST_DIR, "del");
    private File tmp = new File(TEST_DIR, "tmp");
    private File xSubDir = new File(this.del, "xsubdir");
    private File ySubDir = new File(this.del, "ysubdir");
    static String file1Name = "file1";
    private File file2 = new File(this.xSubDir, "file2");
    private File file3 = new File(this.ySubDir, "file3");
    private File zlink = new File(this.del, "zlink");

    private void setupDirs() throws IOException {
        Assert.assertFalse((boolean)this.del.exists());
        Assert.assertFalse((boolean)this.tmp.exists());
        this.del.mkdirs();
        this.tmp.mkdirs();
        new File(this.del, FILE).createNewFile();
        File tmpFile = new File(this.tmp, FILE);
        tmpFile.createNewFile();
        File one = new File(this.del, DIR + "1");
        one.mkdirs();
        File two = new File(this.del, DIR + "2");
        two.mkdirs();
        new File(one, FILE).createNewFile();
        new File(two, FILE).createNewFile();
        File link = new File(this.del, LINK);
        FileUtil.symLink((String)tmpFile.toString(), (String)link.toString());
        File linkDir = new File(this.del, "tmpDir");
        FileUtil.symLink((String)this.tmp.toString(), (String)linkDir.toString());
        Assert.assertEquals((long)5L, (long)this.del.listFiles().length);
        FileUtil.symLink((String)this.del.toString(), (String)(this.del.toString() + "/" + DIR + "1/cycle"));
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)this.del);
        FileUtil.fullyDelete((File)this.tmp);
    }

    @Test
    public void testFullyDelete() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDelete((File)this.del);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)this.del.exists());
        this.validateTmpDir();
    }

    @Test
    public void testFullyDeleteContents() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDeleteContents((File)this.del);
        Assert.assertTrue((boolean)ret);
        Assert.assertTrue((boolean)this.del.exists());
        Assert.assertEquals((long)0L, (long)this.del.listFiles().length);
        this.validateTmpDir();
    }

    private void validateTmpDir() {
        Assert.assertTrue((boolean)this.tmp.exists());
        Assert.assertEquals((long)1L, (long)this.tmp.listFiles().length);
        Assert.assertTrue((boolean)new File(this.tmp, FILE).exists());
    }

    private void setupDirsAndNonWritablePermissions() throws IOException {
        Assert.assertFalse((String)"The directory del should not have existed!", (boolean)this.del.exists());
        this.del.mkdirs();
        new MyFile(this.del, file1Name).createNewFile();
        this.xSubDir.mkdirs();
        this.file2.createNewFile();
        this.xSubDir.setWritable(false);
        this.ySubDir.mkdirs();
        this.file3.createNewFile();
        Assert.assertFalse((String)"The directory tmp should not have existed!", (boolean)this.tmp.exists());
        this.tmp.mkdirs();
        File tmpFile = new File(this.tmp, FILE);
        tmpFile.createNewFile();
        FileUtil.symLink((String)tmpFile.toString(), (String)this.zlink.toString());
    }

    private void validateAndSetWritablePermissions(boolean ret) {
        this.xSubDir.setWritable(true);
        Assert.assertFalse((String)"The return value should have been false!", (boolean)ret);
        Assert.assertTrue((String)"The file file1 should not have been deleted!", (boolean)new File(this.del, file1Name).exists());
        Assert.assertTrue((String)"The directory xsubdir should not have been deleted!", (boolean)this.xSubDir.exists());
        Assert.assertTrue((String)"The file file2 should not have been deleted!", (boolean)this.file2.exists());
        Assert.assertFalse((String)"The directory ysubdir should have been deleted!", (boolean)this.ySubDir.exists());
        Assert.assertFalse((String)"The link zlink should have been deleted!", (boolean)this.zlink.exists());
    }

    @Test
    public void testFailFullyDelete() throws IOException {
        LOG.info((Object)"Running test to verify failure of fullyDelete()");
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDelete((File)new MyFile(this.del));
        this.validateAndSetWritablePermissions(ret);
    }

    @Test
    public void testFailFullyDeleteContents() throws IOException {
        LOG.info((Object)"Running test to verify failure of fullyDeleteContents()");
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDeleteContents((File)new MyFile(this.del));
        this.validateAndSetWritablePermissions(ret);
    }

    @Test
    public void testListFiles() throws IOException {
        this.setupDirs();
        File[] files = FileUtil.listFiles((File)this.tmp);
        Assert.assertEquals((long)1L, (long)files.length);
        File newDir = new File(this.tmp.getPath(), "test");
        newDir.mkdir();
        Assert.assertTrue((String)"Failed to create test dir", (boolean)newDir.exists());
        files = FileUtil.listFiles((File)newDir);
        Assert.assertEquals((long)0L, (long)files.length);
        newDir.delete();
        Assert.assertFalse((String)"Failed to delete test dir", (boolean)newDir.exists());
        try {
            files = FileUtil.listFiles((File)newDir);
            Assert.fail((String)("IOException expected on listFiles() for non-existent dir " + newDir.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testListAPI() throws IOException {
        this.setupDirs();
        String[] files = FileUtil.list((File)this.tmp);
        Assert.assertEquals((long)1L, (long)files.length);
        File newDir = new File(this.tmp.getPath(), "test");
        newDir.mkdir();
        Assert.assertTrue((String)"Failed to create test dir", (boolean)newDir.exists());
        files = FileUtil.list((File)newDir);
        Assert.assertEquals((long)0L, (long)files.length);
        newDir.delete();
        Assert.assertFalse((String)"Failed to delete test dir", (boolean)newDir.exists());
        try {
            files = FileUtil.list((File)newDir);
            Assert.fail((String)("IOException expected on list() for non-existent dir " + newDir.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDU() throws IOException {
        this.setupDirs();
        long du = FileUtil.getDU((File)TEST_DIR);
        Assert.assertEquals((long)du, (long)0L);
    }

    public static class MyFile
    extends File {
        private static final long serialVersionUID = 1L;

        public MyFile(File f) {
            super(f.getAbsolutePath());
        }

        public MyFile(File parent, String child) {
            super(parent, child);
        }

        @Override
        public boolean delete() {
            LOG.info((Object)("Trying to delete myFile " + this.getAbsolutePath()));
            boolean bool = false;
            bool = this.getName().equals(file1Name) ? false : super.delete();
            if (bool) {
                LOG.info((Object)("Deleted " + this.getAbsolutePath() + " successfully"));
            } else {
                LOG.info((Object)("Cannot delete " + this.getAbsolutePath()));
            }
            return bool;
        }

        @Override
        public File[] listFiles() {
            File[] files = super.listFiles();
            List<File> filesList = Arrays.asList(files);
            Collections.sort(filesList);
            File[] myFiles = new MyFile[files.length];
            int i = 0;
            for (File f : filesList) {
                myFiles[i++] = new MyFile(f);
            }
            return myFiles;
        }
    }
}

