/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.FsShellPermissions;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class TestFsShellReturnCode {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.TestFsShellReturnCode");
    private static final Configuration conf = new Configuration();
    private FileSystem fs;
    private static String TEST_ROOT_DIR = System.getProperty("test.build.data", "build/test/data/testCHReturnCode");

    static void writeFile(FileSystem fs, Path name) throws Exception {
        FSDataOutputStream stm = fs.create(name);
        stm.writeBytes("42\n");
        stm.close();
    }

    public void verify(FileSystem fs, String cmd, String[] argv, int cmdIndex, FsShell fsShell, int exitCode) throws Exception {
        int ec = FsShellPermissions.changePermissions((FileSystem)fs, (String)cmd, (String[])argv, (int)cmdIndex, (FsShell)fsShell);
        Assert.assertEquals((long)ec, (long)exitCode);
    }

    @Test
    public void testChmod() throws Exception {
        FsShell fsShell = new FsShell(conf);
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)fsShell.getConf());
        }
        String f1 = TEST_ROOT_DIR + "/" + "testChmod/fileExists";
        String f2 = TEST_ROOT_DIR + "/" + "testChmod/fileDoesNotExist";
        String f3 = TEST_ROOT_DIR + "/" + "testChmod/nonExistingfiles*";
        Path p1 = new Path(f1);
        Path p4 = new Path(TEST_ROOT_DIR + "/" + "testChmod/file1");
        Path p5 = new Path(TEST_ROOT_DIR + "/" + "testChmod/file2");
        Path p6 = new Path(TEST_ROOT_DIR + "/" + "testChmod/file3");
        String f7 = TEST_ROOT_DIR + "/" + "testChmod/file*";
        LocalFileSystem fileSys = FileSystem.getLocal((Configuration)conf);
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p1);
        Assert.assertTrue((boolean)fileSys.exists(p1));
        String[] argv = new String[]{"-chmod", "777", f1};
        this.verify(this.fs, "-chmod", argv, 1, fsShell, 0);
        String[] argv2 = new String[]{"-chmod", "777", f2};
        this.verify(this.fs, "-chmod", argv2, 1, fsShell, 1);
        String[] argv3 = new String[]{"-chmod", "777", f3};
        this.verify(this.fs, "-chmod", argv3, 1, fsShell, 1);
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p4);
        Assert.assertTrue((boolean)fileSys.exists(p4));
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p5);
        Assert.assertTrue((boolean)fileSys.exists(p5));
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p6);
        Assert.assertTrue((boolean)fileSys.exists(p6));
        String[] argv4 = new String[]{"-chmod", "777", f7};
        this.verify(this.fs, "-chmod", argv4, 1, fsShell, 0);
    }

    @Test
    public void testChown() throws Exception {
        FsShell fsShell = new FsShell(conf);
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)fsShell.getConf());
        }
        String f1 = TEST_ROOT_DIR + "/" + "testChown/fileExists";
        String f2 = TEST_ROOT_DIR + "/" + "testChown/fileDoesNotExist";
        String f3 = TEST_ROOT_DIR + "/" + "testChown/nonExistingfiles*";
        Path p1 = new Path(f1);
        Path p4 = new Path(TEST_ROOT_DIR + "/" + "testChown/file1");
        Path p5 = new Path(TEST_ROOT_DIR + "/" + "testChown/file2");
        Path p6 = new Path(TEST_ROOT_DIR + "/" + "testChown/file3");
        String f7 = TEST_ROOT_DIR + "/" + "testChown/file*";
        LocalFileSystem fileSys = FileSystem.getLocal((Configuration)conf);
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p1);
        Assert.assertTrue((boolean)fileSys.exists(p1));
        String[] argv = new String[]{"-chown", "admin", f1};
        this.verify(this.fs, "-chown", argv, 1, fsShell, 0);
        String[] argv2 = new String[]{"-chown", "admin", f2};
        this.verify(this.fs, "-chown", argv2, 1, fsShell, 1);
        String[] argv3 = new String[]{"-chown", "admin", f3};
        this.verify(this.fs, "-chown", argv3, 1, fsShell, 1);
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p4);
        Assert.assertTrue((boolean)fileSys.exists(p4));
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p5);
        Assert.assertTrue((boolean)fileSys.exists(p5));
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p6);
        Assert.assertTrue((boolean)fileSys.exists(p6));
        String[] argv4 = new String[]{"-chown", "admin", f7};
        this.verify(this.fs, "-chown", argv4, 1, fsShell, 0);
    }

    @Test
    public void testChgrp() throws Exception {
        FsShell fsShell = new FsShell(conf);
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)fsShell.getConf());
        }
        String f1 = TEST_ROOT_DIR + "/" + "testChgrp/fileExists";
        String f2 = TEST_ROOT_DIR + "/" + "testChgrp/fileDoesNotExist";
        String f3 = TEST_ROOT_DIR + "/" + "testChgrp/nonExistingfiles*";
        Path p1 = new Path(f1);
        Path p4 = new Path(TEST_ROOT_DIR + "/" + "testChgrp/file1");
        Path p5 = new Path(TEST_ROOT_DIR + "/" + "testChgrp/file2");
        Path p6 = new Path(TEST_ROOT_DIR + "/" + "testChgrp/file3");
        String f7 = TEST_ROOT_DIR + "/" + "testChgrp/file*";
        LocalFileSystem fileSys = FileSystem.getLocal((Configuration)conf);
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p1);
        Assert.assertTrue((boolean)fileSys.exists(p1));
        String[] argv = new String[]{"-chgrp", "admin", f1};
        this.verify(this.fs, "-chgrp", argv, 1, fsShell, 0);
        String[] argv2 = new String[]{"-chgrp", "admin", f2};
        this.verify(this.fs, "-chgrp", argv2, 1, fsShell, 1);
        String[] argv3 = new String[]{"-chgrp", "admin", f3};
        this.verify(this.fs, "-chgrp", argv3, 1, fsShell, 1);
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p4);
        Assert.assertTrue((boolean)fileSys.exists(p4));
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p5);
        Assert.assertTrue((boolean)fileSys.exists(p5));
        TestFsShellReturnCode.writeFile((FileSystem)fileSys, p6);
        Assert.assertTrue((boolean)fileSys.exists(p6));
        String[] argv4 = new String[]{"-chgrp", "admin", f7};
        this.verify(this.fs, "-chgrp", argv4, 1, fsShell, 0);
    }
}

