/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestTrash;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestHDFSTrash
extends TestTrash {
    private static MiniDFSCluster cluster = null;

    public static Test suite() {
        TestSetup setup = new TestSetup((Test)new TestSuite(TestHDFSTrash.class)){

            protected void setUp() throws Exception {
                Configuration conf = new Configuration();
                cluster = new MiniDFSCluster(conf, 2, true, null);
            }

            protected void tearDown() throws Exception {
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
        };
        return setup;
    }

    @Override
    public void testTrash() throws IOException {
        TestHDFSTrash.trashShell(cluster.getFileSystem(), new Path("/"));
    }

    @Override
    public void testNonDefaultFS() throws IOException {
        FileSystem fs = cluster.getFileSystem();
        Configuration conf = fs.getConf();
        conf.set("fs.default.name", fs.getUri().toString());
        TestHDFSTrash.trashNonDefaultFS(conf);
    }
}

