/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class TestSafeMode
extends TestCase {
    static Log LOG = LogFactory.getLog(TestSafeMode.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManualSafeMode() throws IOException {
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            Configuration conf = new Configuration();
            conf.set("dfs.safemode.extension", "1");
            cluster = new MiniDFSCluster(conf, 1, true, null);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path file1 = new Path("/tmp/testManualSafeMode/file1");
            Path file2 = new Path("/tmp/testManualSafeMode/file2");
            LOG.info((Object)"Created file1 and file2.");
            DFSTestUtil.createFile(fs, file1, 1000L, (short)1, 0L);
            DFSTestUtil.createFile(fs, file2, 2000L, (short)1, 0L);
            cluster.shutdown();
            cluster = new MiniDFSCluster(conf, 0, false, null);
            cluster.waitActive();
            LOG.info((Object)"Restarted cluster with just the NameNode");
            NameNode namenode = cluster.getNameNode();
            TestSafeMode.assertTrue((String)"No datanode is started. Should be in SafeMode", (boolean)namenode.isInSafeMode());
            namenode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.startDataNodes(conf, 1, true, null, null);
            cluster.waitActive();
            LOG.info((Object)"Datanode is started.");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            TestSafeMode.assertTrue((String)"should still be in SafeMode", (boolean)namenode.isInSafeMode());
            namenode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
            TestSafeMode.assertFalse((String)"should not be in SafeMode", (boolean)namenode.isInSafeMode());
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

