/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.Test;

public class TestDataNodeMXBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeMXBean() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        try {
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((int)datanodes.size(), (int)1);
            DataNode datanode = (DataNode)datanodes.get(0);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=DataNode,name=DataNodeInfo");
            String hostname = (String)mbs.getAttribute(mxbeanName, "HostName");
            Assert.assertEquals((String)datanode.getHostName(), (String)hostname);
            String version = (String)mbs.getAttribute(mxbeanName, "Version");
            Assert.assertEquals((String)datanode.getVersion(), (String)version);
            String rpcPort = (String)mbs.getAttribute(mxbeanName, "RpcPort");
            Assert.assertEquals((String)datanode.getRpcPort(), (String)rpcPort);
            String httpPort = (String)mbs.getAttribute(mxbeanName, "HttpPort");
            Assert.assertEquals((String)datanode.getHttpPort(), (String)httpPort);
            String namenodeAddress = (String)mbs.getAttribute(mxbeanName, "NamenodeAddress");
            Assert.assertEquals((String)datanode.getNamenodeAddress(), (String)namenodeAddress);
            String volumeInfo = (String)mbs.getAttribute(mxbeanName, "VolumeInfo");
            Assert.assertEquals((String)datanode.getVolumeInfo(), (String)volumeInfo);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

