/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Test;

public class TestCheckPointForSecurityTokens {
    static final long seed = 3735928559L;
    static final int blockSize = 4096;
    static final int fileSize = 8192;
    static final int numDatanodes = 3;
    short replication = (short)3;
    MiniDFSCluster cluster = null;

    NameNode startNameNode(Configuration conf, String imageDirs, String editsDirs, HdfsConstants.StartupOption start) throws IOException {
        conf.set("fs.default.name", "hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        conf.set("dfs.namenode.name.dir", imageDirs);
        conf.set("dfs.namenode.edits.dir", editsDirs);
        String[] args = new String[]{start.getName()};
        NameNode nn = NameNode.createNameNode((String[])args, (Configuration)conf);
        Assert.assertTrue((boolean)nn.isInSafeMode());
        return nn;
    }

    private void cancelToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.cluster.getNameNode().getNamesystem().cancelDelegationToken(token);
    }

    private void renewToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.cluster.getNameNode().getNamesystem().renewDelegationToken(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveNamespace() throws IOException {
        DistributedFileSystem fs = null;
        try {
            Configuration conf = new Configuration();
            this.cluster = new MiniDFSCluster(conf, 3, true, null);
            this.cluster.waitActive();
            fs = (DistributedFileSystem)this.cluster.getFileSystem();
            FSNamesystem namesystem = this.cluster.getNameNode().getNamesystem();
            namesystem.getDelegationTokenSecretManager().startThreads();
            String renewer = UserGroupInformation.getLoginUser().getUserName();
            Token token1 = namesystem.getDelegationToken(new Text(renewer));
            Token token2 = namesystem.getDelegationToken(new Text(renewer));
            DFSAdmin admin = new DFSAdmin(conf);
            String[] args = new String[]{"-saveNamespace"};
            Collection<File> editsDirs = this.cluster.getNameEditsDirs();
            for (File ed : editsDirs) {
                Assert.assertTrue((new File(ed, "current/edits").length() > 4L ? 1 : 0) != 0);
            }
            fs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            try {
                admin.run(args);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            for (File ed : editsDirs) {
                Assert.assertTrue((new File(ed, "current/edits").length() == 4L ? 1 : 0) != 0);
            }
            this.cluster.shutdown();
            this.cluster = null;
            this.cluster = new MiniDFSCluster(conf, 3, false, null);
            this.cluster.waitActive();
            try {
                this.renewToken((Token<DelegationTokenIdentifier>)token1);
                this.renewToken((Token<DelegationTokenIdentifier>)token2);
            }
            catch (IOException e) {
                Assert.fail((String)"Could not renew or cancel the token");
            }
            namesystem = this.cluster.getNameNode().getNamesystem();
            namesystem.getDelegationTokenSecretManager().startThreads();
            Token token3 = namesystem.getDelegationToken(new Text(renewer));
            Token token4 = namesystem.getDelegationToken(new Text(renewer));
            this.cluster.shutdown();
            this.cluster = null;
            this.cluster = new MiniDFSCluster(conf, 3, false, null);
            this.cluster.waitActive();
            namesystem = this.cluster.getNameNode().getNamesystem();
            namesystem.getDelegationTokenSecretManager().startThreads();
            Token token5 = namesystem.getDelegationToken(new Text(renewer));
            try {
                this.renewToken((Token<DelegationTokenIdentifier>)token1);
                this.renewToken((Token<DelegationTokenIdentifier>)token2);
                this.renewToken((Token<DelegationTokenIdentifier>)token3);
                this.renewToken((Token<DelegationTokenIdentifier>)token4);
                this.renewToken((Token<DelegationTokenIdentifier>)token5);
            }
            catch (IOException e) {
                Assert.fail((String)"Could not renew or cancel the token");
            }
            this.cluster.shutdown();
            this.cluster = null;
            this.cluster = new MiniDFSCluster(conf, 3, false, null);
            this.cluster.waitActive();
            namesystem = this.cluster.getNameNode().getNamesystem();
            namesystem.getDelegationTokenSecretManager().startThreads();
            try {
                this.renewToken((Token<DelegationTokenIdentifier>)token1);
                this.cancelToken((Token<DelegationTokenIdentifier>)token1);
                this.renewToken((Token<DelegationTokenIdentifier>)token2);
                this.cancelToken((Token<DelegationTokenIdentifier>)token2);
                this.renewToken((Token<DelegationTokenIdentifier>)token3);
                this.cancelToken((Token<DelegationTokenIdentifier>)token3);
                this.renewToken((Token<DelegationTokenIdentifier>)token4);
                this.cancelToken((Token<DelegationTokenIdentifier>)token4);
                this.renewToken((Token<DelegationTokenIdentifier>)token5);
                this.cancelToken((Token<DelegationTokenIdentifier>)token5);
            }
            catch (IOException e) {
                Assert.fail((String)"Could not renew or cancel the token");
            }
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }
}

