/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.junit.After;
import org.junit.Test;

public class TestDeadDatanode {
    private static final Log LOG = LogFactory.getLog(TestDeadDatanode.class);
    private MiniDFSCluster cluster;

    @After
    public void cleanup() {
        this.cluster.shutdown();
    }

    private void waitForDatanodeState(DatanodeID nodeID, boolean alive, int waitTime) throws TimeoutException, InterruptedException, IOException {
        String state;
        long stopTime = System.currentTimeMillis() + (long)waitTime;
        FSNamesystem namesystem = this.cluster.getNameNode().getNamesystem();
        String string = state = alive ? "alive" : "dead";
        while (System.currentTimeMillis() < stopTime) {
            if (namesystem.getDatanode((DatanodeID)nodeID).isAlive == alive) {
                LOG.info((Object)("datanode " + nodeID + " is " + state));
                return;
            }
            LOG.info((Object)("Waiting for datanode " + nodeID + " to become " + state));
            Thread.sleep(1000L);
        }
        throw new TimeoutException("Timedout waiting for datanode reach state " + state);
    }

    @Test
    public void testDeadDatanode() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("heartbeat.recheck.interval", 500);
        conf.setLong("dfs.heartbeat.interval", 1L);
        this.cluster = new MiniDFSCluster(conf, 1, true, null);
        this.cluster.waitActive();
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeRegistration reg = this.cluster.getDataNodes().get((int)0).dnRegistration;
        this.waitForDatanodeState((DatanodeID)reg, true, 20000);
        dn.shutdown();
        this.waitForDatanodeState((DatanodeID)reg, false, 20000);
        NameNode dnp = this.cluster.getNameNode();
        Block block = new Block(0L);
        Block[] blocks = new Block[]{block};
        String[] delHints = new String[]{""};
        try {
            dnp.blockReceived(reg, blocks, delHints);
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        long[] blockReport = new long[]{0L, 0L, 0L};
        try {
            dnp.blockReport(reg, blockReport);
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        DatanodeCommand[] cmd = dnp.sendHeartbeat(reg, 0L, 0L, 0L, 0, 0);
        Assert.assertEquals((int)1, (int)cmd.length);
        Assert.assertEquals((int)cmd[0].getAction(), (int)DatanodeCommand.REGISTER.getAction());
    }
}

