/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

public class TestNamenodeCapacityReport
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestNamenodeCapacityReport.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVolumeSize() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        long reserved = 10000L;
        conf.setLong("dfs.datanode.du.reserved", reserved);
        try {
            float percentRemaining;
            float percentUsed;
            long configCapacity;
            long nonDFSUsed;
            long remaining;
            long used;
            cluster = new MiniDFSCluster(conf, 1, true, null);
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNameNode().namesystem;
            ArrayList live = new ArrayList();
            ArrayList dead = new ArrayList();
            namesystem.DFSNodesStatus(live, dead);
            TestNamenodeCapacityReport.assertTrue((live.size() == 1 ? 1 : 0) != 0);
            for (DatanodeDescriptor datanode : live) {
                used = datanode.getDfsUsed();
                remaining = datanode.getRemaining();
                nonDFSUsed = datanode.getNonDfsUsed();
                configCapacity = datanode.getCapacity();
                percentUsed = datanode.getDfsUsedPercent();
                percentRemaining = datanode.getRemainingPercent();
                LOG.info((Object)("Datanode configCapacity " + configCapacity + " used " + used + " non DFS used " + nonDFSUsed + " remaining " + remaining + " perentUsed " + percentUsed + " percentRemaining " + percentRemaining));
                TestNamenodeCapacityReport.assertTrue((configCapacity == used + remaining + nonDFSUsed ? 1 : 0) != 0);
                TestNamenodeCapacityReport.assertTrue((percentUsed == 100.0f * (float)used / (float)configCapacity ? 1 : 0) != 0);
                TestNamenodeCapacityReport.assertTrue((percentRemaining == 100.0f * (float)remaining / (float)configCapacity ? 1 : 0) != 0);
            }
            DF df = new DF(new File(cluster.getDataDirectory()), conf);
            int numOfDataDirs = 2;
            long diskCapacity = (long)numOfDataDirs * df.getCapacity();
            reserved *= (long)numOfDataDirs;
            configCapacity = namesystem.getCapacityTotal();
            used = namesystem.getCapacityUsed();
            nonDFSUsed = namesystem.getCapacityUsedNonDFS();
            remaining = namesystem.getCapacityRemaining();
            percentUsed = namesystem.getCapacityUsedPercent();
            percentRemaining = namesystem.getCapacityRemainingPercent();
            LOG.info((Object)("Data node directory " + cluster.getDataDirectory()));
            LOG.info((Object)("Name node diskCapacity " + diskCapacity + " configCapacity " + configCapacity + " reserved " + reserved + " used " + used + " remaining " + remaining + " nonDFSUsed " + nonDFSUsed + " remaining " + remaining + " percentUsed " + percentUsed + " percentRemaining " + percentRemaining));
            TestNamenodeCapacityReport.assertTrue((configCapacity == diskCapacity - reserved ? 1 : 0) != 0);
            TestNamenodeCapacityReport.assertTrue((configCapacity == used + remaining + nonDFSUsed ? 1 : 0) != 0);
            TestNamenodeCapacityReport.assertTrue((percentUsed == (float)used * 100.0f / (float)configCapacity ? 1 : 0) != 0);
            TestNamenodeCapacityReport.assertTrue((percentRemaining == (float)remaining * 100.0f / (float)configCapacity ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

