/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestSaveNamespace
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestSaveNamespace.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNamespaceWithInjectedFault(Fault fault) throws IOException {
        FSImage spyImage;
        Configuration conf = this.getConf();
        NameNode.format((Configuration)conf);
        NameNode nn = new NameNode(conf);
        FSNamesystem fsn = nn.getNamesystem();
        FSImage originalImage = fsn.dir.fsImage;
        fsn.dir.fsImage = spyImage = (FSImage)Mockito.spy((Object)originalImage);
        switch (fault) {
            case SAVE_FSIMAGE: {
                ((FSImage)Mockito.doAnswer((Answer)new FaultySaveImage(originalImage)).when((Object)spyImage)).saveFSImage((File)Matchers.anyObject());
                break;
            }
            case MOVE_CURRENT: {
                ((FSImage)Mockito.doThrow((Throwable)new RuntimeException("Injected fault: moveCurrent")).when((Object)spyImage)).moveCurrent((Storage.StorageDirectory)Matchers.anyObject());
                break;
            }
            case MOVE_LAST_CHECKPOINT: {
                ((FSImage)Mockito.doThrow((Throwable)new RuntimeException("Injected fault: moveLastCheckpoint")).when((Object)spyImage)).moveLastCheckpoint((Storage.StorageDirectory)Matchers.anyObject());
            }
        }
        try {
            this.doAnEdit(fsn, 1);
            fsn.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            try {
                fsn.saveNamespace();
            }
            catch (Exception e) {
                LOG.info((Object)"Test caught expected exception", (Throwable)e);
            }
            nn.stop();
            nn = null;
            nn = new NameNode(conf);
            fsn = nn.getNamesystem();
            this.checkEditExists(fsn, 1);
        }
        finally {
            if (nn != null) {
                nn.stop();
            }
        }
    }

    public void testCrashWhileSavingSecondImage() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.SAVE_FSIMAGE);
    }

    public void testCrashWhileMoveCurrent() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.MOVE_CURRENT);
    }

    public void testCrashWhileMoveLastCheckpoint() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.MOVE_LAST_CHECKPOINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveWhileEditsRolled() throws Exception {
        FSImage spyImage;
        Configuration conf = this.getConf();
        NameNode.format((Configuration)conf);
        NameNode nn = new NameNode(conf);
        FSNamesystem fsn = nn.getNamesystem();
        FSImage originalImage = fsn.dir.fsImage;
        fsn.dir.fsImage = spyImage = (FSImage)Mockito.spy((Object)originalImage);
        try {
            this.doAnEdit(fsn, 1);
            CheckpointSignature sig = fsn.rollEditLog();
            LOG.warn((Object)("Checkpoint signature: " + sig));
            this.doAnEdit(fsn, 2);
            fsn.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            fsn.saveNamespace();
            nn.stop();
            nn = null;
            nn = new NameNode(conf);
            fsn = nn.getNamesystem();
            this.checkEditExists(fsn, 1);
            this.checkEditExists(fsn, 2);
        }
        finally {
            if (nn != null) {
                nn.stop();
            }
        }
    }

    private void doAnEdit(FSNamesystem fsn, int id) throws IOException {
        fsn.mkdirs("/test" + id, new PermissionStatus("test", "Test", new FsPermission(511)));
    }

    private void checkEditExists(FSNamesystem fsn, int id) throws IOException {
        TestSaveNamespace.assertNotNull((Object)fsn.getFileInfo("/test" + id));
    }

    private Configuration getConf() throws IOException {
        String baseDir = System.getProperty("test.build.data", "build/test/data/dfs/");
        String nameDirs = baseDir + "name1" + "," + baseDir + "name2";
        Configuration conf = new Configuration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.http.address", "0.0.0.0:0");
        conf.set("dfs.name.dir", nameDirs);
        conf.set("dfs.name.edits.dir", nameDirs);
        conf.set("dfs.secondary.http.address", "0.0.0.0:0");
        conf.setBoolean("dfs.permissions", false);
        return conf;
    }

    private static enum Fault {
        SAVE_FSIMAGE,
        MOVE_CURRENT,
        MOVE_LAST_CHECKPOINT;

    }

    private static class FaultySaveImage
    implements Answer<Void> {
        int count = 0;
        FSImage origImage;

        public FaultySaveImage(FSImage origImage) {
            this.origImage = origImage;
        }

        public Void answer(InvocationOnMock invocation) throws Exception {
            Object[] args = invocation.getArguments();
            File f = (File)args[0];
            if (this.count++ == 1) {
                LOG.info((Object)("Injecting fault for file: " + f));
                throw new RuntimeException("Injected fault: saveFSImage second time");
            }
            LOG.info((Object)("Not injecting fault for file: " + f));
            this.origImage.saveFSImage(f);
            return null;
        }
    }
}

