/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SortedMapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class TestSortedMapWritable
extends TestCase {
    public void testSortedMapWritable() {
        Text[] keys = new Text[]{new Text("key1"), new Text("key2"), new Text("key3")};
        BytesWritable[] values = new BytesWritable[]{new BytesWritable("value1".getBytes()), new BytesWritable("value2".getBytes()), new BytesWritable("value3".getBytes())};
        SortedMapWritable inMap = new SortedMapWritable();
        for (int i = 0; i < keys.length; ++i) {
            inMap.put((WritableComparable)keys[i], (Writable)values[i]);
        }
        TestSortedMapWritable.assertEquals((int)0, (int)inMap.firstKey().compareTo((Object)keys[0]));
        TestSortedMapWritable.assertEquals((int)0, (int)inMap.lastKey().compareTo((Object)keys[2]));
        SortedMapWritable outMap = new SortedMapWritable(inMap);
        TestSortedMapWritable.assertEquals((int)inMap.size(), (int)outMap.size());
        for (Map.Entry e : inMap.entrySet()) {
            TestSortedMapWritable.assertTrue((boolean)outMap.containsKey(e.getKey()));
            TestSortedMapWritable.assertEquals((int)0, (int)((WritableComparable)outMap.get(e.getKey())).compareTo(e.getValue()));
        }
        Text[] maps = new Text[]{new Text("map1"), new Text("map2")};
        SortedMapWritable mapOfMaps = new SortedMapWritable();
        mapOfMaps.put((WritableComparable)maps[0], (Writable)inMap);
        mapOfMaps.put((WritableComparable)maps[1], (Writable)outMap);
        SortedMapWritable copyOfMapOfMaps = new SortedMapWritable(mapOfMaps);
        for (int i = 0; i < maps.length; ++i) {
            TestSortedMapWritable.assertTrue((boolean)copyOfMapOfMaps.containsKey((Object)maps[i]));
            SortedMapWritable a = (SortedMapWritable)mapOfMaps.get((Object)maps[i]);
            SortedMapWritable b = (SortedMapWritable)copyOfMapOfMaps.get((Object)maps[i]);
            TestSortedMapWritable.assertEquals((int)a.size(), (int)b.size());
            for (WritableComparable key : a.keySet()) {
                TestSortedMapWritable.assertTrue((boolean)b.containsKey((Object)key));
                WritableComparable aValue = (WritableComparable)a.get((Object)key);
                WritableComparable bValue = (WritableComparable)b.get((Object)key);
                TestSortedMapWritable.assertEquals((int)0, (int)aValue.compareTo((Object)bValue));
            }
        }
    }

    public void testForeignClass() {
        SortedMapWritable inMap = new SortedMapWritable();
        inMap.put((WritableComparable)new Text("key"), (Writable)new UTF8("value"));
        inMap.put((WritableComparable)new Text("key2"), (Writable)new UTF8("value2"));
        SortedMapWritable outMap = new SortedMapWritable(inMap);
        SortedMapWritable copyOfCopy = new SortedMapWritable(outMap);
        TestSortedMapWritable.assertEquals((int)1, (int)copyOfCopy.getNewClasses());
    }
}

