/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.serializer.JavaSerializationComparator;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.Utils;

public class TestJavaSerialization
extends ClusterMapReduceTestCase {
    public void testMapReduceJob() throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("b a\n");
        ((Writer)wr).close();
        JobConf conf = this.createJobConf();
        conf.setJobName("JavaSerialization");
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(String.class);
        conf.setOutputValueClass(Long.class);
        conf.setOutputKeyComparatorClass(JavaSerializationComparator.class);
        conf.setMapperClass(WordCountMapper.class);
        conf.setReducerClass(SumReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputDir()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.getOutputDir());
        JobClient.runJob((JobConf)conf);
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])this.getFileSystem().listStatus(this.getOutputDir(), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        TestJavaSerialization.assertEquals((int)1, (int)outputFiles.length);
        FSDataInputStream is = this.getFileSystem().open(outputFiles[0]);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
        TestJavaSerialization.assertEquals((String)"a\t1", (String)reader.readLine());
        TestJavaSerialization.assertEquals((String)"b\t1", (String)reader.readLine());
        TestJavaSerialization.assertNull((Object)reader.readLine());
        reader.close();
    }

    public void testWriteToSequencefile() throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("b a\n");
        ((Writer)wr).close();
        JobConf conf = this.createJobConf();
        conf.setJobName("JavaSerialization");
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setOutputKeyClass(String.class);
        conf.setOutputValueClass(Long.class);
        conf.setOutputKeyComparatorClass(JavaSerializationComparator.class);
        conf.setMapperClass(WordCountMapper.class);
        conf.setReducerClass(SumReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputDir()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.getOutputDir());
        JobClient.runJob((JobConf)conf);
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])this.getFileSystem().listStatus(this.getOutputDir(), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        TestJavaSerialization.assertEquals((int)1, (int)outputFiles.length);
    }

    static class SumReducer<K>
    extends MapReduceBase
    implements Reducer<K, Long, K, Long> {
        SumReducer() {
        }

        public void reduce(K key, Iterator<Long> values, OutputCollector<K, Long> output, Reporter reporter) throws IOException {
            long sum = 0L;
            while (values.hasNext()) {
                sum += values.next().longValue();
            }
            output.collect(key, (Object)sum);
        }
    }

    static class WordCountMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, String, Long> {
        WordCountMapper() {
        }

        public void map(LongWritable key, Text value, OutputCollector<String, Long> output, Reporter reporter) throws IOException {
            StringTokenizer st = new StringTokenizer(value.toString());
            while (st.hasMoreTokens()) {
                output.collect((Object)st.nextToken(), (Object)1L);
            }
        }
    }
}

