/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.mapred.JettyBugMonitor;
import org.junit.Assert;
import org.junit.Test;

public class TestJettyBugMonitor {
    private final Configuration conf = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testGetJettyThreads() throws Exception {
        JettyBugMonitor monitor = new JettyBugMonitor(this.conf);
        new File(System.getProperty("build.webapps", "build/webapps") + "/test").mkdirs();
        HttpServer server = new HttpServer("test", "0.0.0.0", 0, true);
        server.start();
        try {
            List threads = monitor.waitForJettyThreads();
            Assert.assertEquals((long)1L, (long)threads.size());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testMonitoring() throws Exception {
        BusyThread busyThread = new BusyThread();
        busyThread.start();
        final long tid = busyThread.getId();
        final CountDownLatch abortLatch = new CountDownLatch(1);
        this.conf.setLong("mapred.tasktracker.jetty.cpu.check.interval", 1000L);
        JettyBugMonitor monitor = null;
        try {
            monitor = new JettyBugMonitor(this.conf){

                protected List<Long> waitForJettyThreads() {
                    return Collections.singletonList(tid);
                }

                protected void doAbort() {
                    abortLatch.countDown();
                }
            };
            monitor.start();
            abortLatch.await();
        }
        finally {
            busyThread.done = true;
            busyThread.join();
            if (monitor != null) {
                monitor.shutdown();
            }
        }
    }

    private static class BusyThread
    extends Thread {
        private volatile boolean done = false;

        private BusyThread() {
        }

        @Override
        public void run() {
            while (!this.done) {
            }
        }
    }
}

