/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.DefaultJobHistoryParser;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;

public class TestJobHistory
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestJobHistory.class);
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private static final Pattern digitsPattern = Pattern.compile("[0-9]+");
    private static final Pattern hostNamePattern = Pattern.compile("(/(([\\w\\-\\.]+)/)+)?([\\w\\-\\.]+)");
    private static final String IP_ADDR = "\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?";
    private static final Pattern trackerNamePattern = Pattern.compile("tracker_" + hostNamePattern + ":([\\w\\-\\.]+)/" + "\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?" + ":" + "[0-9]+");
    private static final Pattern splitsPattern = Pattern.compile(hostNamePattern + "(," + hostNamePattern + ")*");
    private static Map<String, List<String>> taskIDsToAttemptIDs = new HashMap<String, List<String>>();
    private static List<String> taskEnds = new ArrayList<String>();
    private static List<String> ignoreStartTimeOfTasks = new ArrayList<String>();
    private static List<String> tempIgnoreStartTimeOfTasks = new ArrayList<String>();

    private static boolean isTimeValid(String time) {
        Matcher m = digitsPattern.matcher(time);
        return m.matches() && Long.parseLong(time) > 0L;
    }

    private static boolean areTimesInOrder(String time1, String time2) {
        return Long.parseLong(time1) <= Long.parseLong(time2);
    }

    private static void validateJobLevelKeyValuesFormat(Map<JobHistory.Keys, String> values, String status) {
        String time = values.get(JobHistory.Keys.SUBMIT_TIME);
        TestJobHistory.assertTrue((String)("Job SUBMIT_TIME is in unexpected format:" + time + " in history file"), (boolean)TestJobHistory.isTimeValid(time));
        time = values.get(JobHistory.Keys.LAUNCH_TIME);
        TestJobHistory.assertTrue((String)("Job LAUNCH_TIME is in unexpected format:" + time + " in history file"), (boolean)TestJobHistory.isTimeValid(time));
        String time1 = values.get(JobHistory.Keys.FINISH_TIME);
        TestJobHistory.assertTrue((String)("Job FINISH_TIME is in unexpected format:" + time1 + " in history file"), (boolean)TestJobHistory.isTimeValid(time1));
        TestJobHistory.assertTrue((String)"Job FINISH_TIME is < LAUNCH_TIME in history file", (boolean)TestJobHistory.areTimesInOrder(time, time1));
        String stat = values.get(JobHistory.Keys.JOB_STATUS);
        TestJobHistory.assertTrue((String)("Unexpected JOB_STATUS \"" + stat + "\" is seen in" + " history file"), (boolean)status.equals(stat));
        String priority = values.get(JobHistory.Keys.JOB_PRIORITY);
        TestJobHistory.assertTrue((String)"Unknown priority for the job in history file", (priority.equals("HIGH") || priority.equals("LOW") || priority.equals("NORMAL") || priority.equals("VERY_HIGH") || priority.equals("VERY_LOW") ? 1 : 0) != 0);
    }

    private static void validateTaskLevelKeyValuesFormat(JobHistory.JobInfo job, boolean splitsCanBeEmpty) {
        Map tasks = job.getAllTasks();
        for (JobHistory.Task task : tasks.values()) {
            String tid = task.get(JobHistory.Keys.TASKID);
            String time = task.get(JobHistory.Keys.START_TIME);
            if (!ignoreStartTimeOfTasks.contains(tid) || Long.parseLong(time) != 0L) {
                TestJobHistory.assertTrue((String)("Task START_TIME of " + tid + " is in unexpected format:" + time + " in history file"), (boolean)TestJobHistory.isTimeValid(time));
            }
            String time1 = task.get(JobHistory.Keys.FINISH_TIME);
            TestJobHistory.assertTrue((String)("Task FINISH_TIME of " + tid + " is in unexpected format:" + time1 + " in history file"), (boolean)TestJobHistory.isTimeValid(time1));
            TestJobHistory.assertTrue((String)"Task FINISH_TIME is < START_TIME in history file", (boolean)TestJobHistory.areTimesInOrder(time, time1));
            String type = task.get(JobHistory.Keys.TASK_TYPE);
            TestJobHistory.assertTrue((String)("Unknown Task type \"" + type + "\" is seen in " + "history file for task " + tid), (type.equals("MAP") || type.equals("REDUCE") || type.equals("SETUP") || type.equals("CLEANUP") ? 1 : 0) != 0);
            if (type.equals("MAP")) {
                String splits = task.get(JobHistory.Keys.SPLITS);
                if (!splitsCanBeEmpty || splits.length() != 0) {
                    Matcher m = splitsPattern.matcher(splits);
                    TestJobHistory.assertTrue((String)("Unexpected format of SPLITS \"" + splits + "\" is seen" + " in history file for task " + tid), (boolean)m.matches());
                }
            }
            String status = task.get(JobHistory.Keys.TASK_STATUS);
            TestJobHistory.assertTrue((String)("Unexpected TASK_STATUS \"" + status + "\" is seen in" + " history file for task " + tid), (status.equals("SUCCESS") || status.equals("FAILED") || status.equals("KILLED") ? 1 : 0) != 0);
        }
    }

    private static void validateTaskAttemptLevelKeyValuesFormat(JobHistory.JobInfo job) {
        Map tasks = job.getAllTasks();
        for (JobHistory.Task task : tasks.values()) {
            for (JobHistory.TaskAttempt attempt : task.getTaskAttempts().values()) {
                String id = attempt.get(JobHistory.Keys.TASK_ATTEMPT_ID);
                String time = attempt.get(JobHistory.Keys.START_TIME);
                TestJobHistory.assertTrue((String)("START_TIME of task attempt " + id + " is in unexpected format:" + time + " in history file"), (boolean)TestJobHistory.isTimeValid(time));
                String time1 = attempt.get(JobHistory.Keys.FINISH_TIME);
                TestJobHistory.assertTrue((String)("FINISH_TIME of task attempt " + id + " is in unexpected format:" + time1 + " in history file"), (boolean)TestJobHistory.isTimeValid(time1));
                TestJobHistory.assertTrue((String)"Task FINISH_TIME is < START_TIME in history file", (boolean)TestJobHistory.areTimesInOrder(time, time1));
                String type = attempt.get(JobHistory.Keys.TASK_TYPE);
                TestJobHistory.assertTrue((String)("Unknown Task type \"" + type + "\" is seen in " + "history file for task attempt " + id), (type.equals("MAP") || type.equals("REDUCE") || type.equals("SETUP") || type.equals("CLEANUP") ? 1 : 0) != 0);
                String status = attempt.get(JobHistory.Keys.TASK_STATUS);
                TestJobHistory.assertTrue((String)("Unexpected TASK_STATUS \"" + status + "\" is seen in" + " history file for task attempt " + id), (status.equals("SUCCESS") || status.equals("FAILED") || status.equals("KILLED") ? 1 : 0) != 0);
                if (type.equals("REDUCE") && status.equals("SUCCESS")) {
                    time1 = attempt.get(JobHistory.Keys.SHUFFLE_FINISHED);
                    TestJobHistory.assertTrue((String)("SHUFFLE_FINISHED time of task attempt " + id + " is in unexpected format:" + time1 + " in history file"), (boolean)TestJobHistory.isTimeValid(time1));
                    TestJobHistory.assertTrue((String)"Reduce Task SHUFFLE_FINISHED time is < START_TIME in history file", (boolean)TestJobHistory.areTimesInOrder(time, time1));
                    time = attempt.get(JobHistory.Keys.SORT_FINISHED);
                    TestJobHistory.assertTrue((String)("SORT_FINISHED of task attempt " + id + " is in unexpected format:" + time + " in history file"), (boolean)TestJobHistory.isTimeValid(time));
                    TestJobHistory.assertTrue((String)"Reduce Task SORT_FINISHED time is < SORT_FINISHED time in history file", (boolean)TestJobHistory.areTimesInOrder(time1, time));
                }
                String hostname = attempt.get(JobHistory.Keys.HOSTNAME);
                Matcher m = hostNamePattern.matcher(hostname);
                TestJobHistory.assertTrue((String)("Unexpected Host name of task attempt " + id), (boolean)m.matches());
                String trackerName = attempt.get(JobHistory.Keys.TRACKER_NAME);
                m = trackerNamePattern.matcher(trackerName);
                TestJobHistory.assertTrue((String)("Unexpected tracker name of task attempt " + id), (boolean)m.matches());
                if (!status.equals("KILLED")) {
                    String httpPort = attempt.get(JobHistory.Keys.HTTP_PORT);
                    m = digitsPattern.matcher(httpPort);
                    TestJobHistory.assertTrue((String)("Unexpected http port of task attempt " + id), (boolean)m.matches());
                }
                String counters = attempt.get(JobHistory.Keys.COUNTERS);
                try {
                    Counters readCounters = Counters.fromEscapedCompactString((String)counters);
                    TestJobHistory.assertTrue((String)("Counters of task attempt " + id + " are not parsable"), (readCounters != null ? 1 : 0) != 0);
                }
                catch (ParseException pe) {
                    LOG.warn((Object)("While trying to parse counters of task attempt " + id + ", " + pe));
                }
            }
        }
    }

    private static Path getPathForConf(Path path) {
        return JobHistory.confPathFromLogFilePath((Path)path);
    }

    static void validateJobHistoryFileFormat(JobID id, JobConf conf, String status, boolean splitsCanBeEmpty) throws IOException {
        Path dir = JobHistory.getCompletedJobHistoryLocation();
        String logFileName = TestJobHistory.getDoneFile(conf, id, dir);
        Path logFile = new Path(dir, logFileName);
        FileSystem fileSys = logFile.getFileSystem((Configuration)conf);
        TestJobHistory.assertTrue((String)"History file does not exist", (boolean)fileSys.exists(logFile));
        TestJobHistory.assertTrue((String)"History filename does not include a directory level for the version number.", (boolean)logFile.toString().contains("/version-1/"));
        String[] jobDetails = JobHistory.JobInfo.decodeJobHistoryFileName((String)logFileName).split("_");
        String jobId = jobDetails[2] + "_" + jobDetails[3] + "_" + jobDetails[4];
        JobHistory.JobInfo jobInfo = new JobHistory.JobInfo(jobId);
        TestListener l = new TestListener(jobInfo);
        JobHistory.parseHistoryFromFS((String)logFile.toString().substring(5), (JobHistory.Listener)l, (FileSystem)fileSys);
        TestJobHistory.validateJobLevelKeyValuesFormat(jobInfo.getValues(), status);
        TestJobHistory.validateTaskLevelKeyValuesFormat(jobInfo, splitsCanBeEmpty);
        TestJobHistory.validateTaskAttemptLevelKeyValuesFormat(jobInfo);
        if (status.equals("SUCCESS")) {
            for (String taskid : taskIDsToAttemptIDs.keySet()) {
                TestJobHistory.assertTrue((String)"There are some Tasks which are not finished in history file.", (boolean)taskEnds.contains(taskid));
                List<String> attemptIDs = taskIDsToAttemptIDs.get(taskid);
                if (attemptIDs == null) continue;
                TestJobHistory.assertTrue((String)("Unexpected. TaskID " + taskid + " has task attempt(s)" + " that are not finished."), (attemptIDs.size() == 1 ? 1 : 0) != 0);
            }
        }
    }

    private static void validateJobLevelKeyValues(MiniMRCluster mr, RunningJob job, JobHistory.JobInfo jobInfo, JobConf conf) throws IOException {
        JobTracker jt = mr.getJobTrackerRunner().getJobTracker();
        JobInProgress jip = jt.getJob(job.getID());
        Map values = jobInfo.getValues();
        TestJobHistory.assertTrue((String)"SUBMIT_TIME of job obtained from history file did not match the expected value", (jip.getStartTime() == Long.parseLong((String)values.get(JobHistory.Keys.SUBMIT_TIME)) ? 1 : 0) != 0);
        TestJobHistory.assertTrue((String)"LAUNCH_TIME of job obtained from history file did not match the expected value", (jip.getLaunchTime() == Long.parseLong((String)values.get(JobHistory.Keys.LAUNCH_TIME)) ? 1 : 0) != 0);
        TestJobHistory.assertTrue((String)"FINISH_TIME of job obtained from history file did not match the expected value", (jip.getFinishTime() == Long.parseLong((String)values.get(JobHistory.Keys.FINISH_TIME)) ? 1 : 0) != 0);
        TestJobHistory.assertTrue((String)"Job Status of job obtained from history file did not match the expected value", (boolean)((String)values.get(JobHistory.Keys.JOB_STATUS)).equals("SUCCESS"));
        TestJobHistory.assertTrue((String)"Job Priority of job obtained from history file did not match the expected value", (boolean)jip.getPriority().toString().equals(values.get(JobHistory.Keys.JOB_PRIORITY)));
        TestJobHistory.assertTrue((String)"Job Name of job obtained from history file did not match the expected value", (boolean)JobHistory.JobInfo.getJobName((JobConf)conf).equals(values.get(JobHistory.Keys.JOBNAME)));
        TestJobHistory.assertTrue((String)"User Name of job obtained from history file did not match the expected value", (boolean)JobHistory.JobInfo.getUserName((JobConf)conf).equals(values.get(JobHistory.Keys.USER)));
        Counters c = new Counters();
        jip.getCounters(c);
        TestJobHistory.assertTrue((String)"Counters of job obtained from history file did not match the expected value", (boolean)c.makeEscapedCompactString().equals(values.get(JobHistory.Keys.COUNTERS)));
        Counters m = new Counters();
        jip.getMapCounters(m);
        TestJobHistory.assertTrue((String)"Map Counters of job obtained from history file did not match the expected value", (boolean)m.makeEscapedCompactString().equals(values.get(JobHistory.Keys.MAP_COUNTERS)));
        Counters r = new Counters();
        jip.getReduceCounters(r);
        TestJobHistory.assertTrue((String)"Reduce Counters of job obtained from history file did not match the expected value", (boolean)r.makeEscapedCompactString().equals(values.get(JobHistory.Keys.REDUCE_COUNTERS)));
        String totalMaps = (String)values.get(JobHistory.Keys.TOTAL_MAPS);
        TestJobHistory.assertTrue((String)"Unexpected number of total maps in history file", (Integer.parseInt(totalMaps) == jip.desiredMaps() ? 1 : 0) != 0);
        String totalReduces = (String)values.get(JobHistory.Keys.TOTAL_REDUCES);
        TestJobHistory.assertTrue((String)"Unexpected number of total reduces in history file", (Integer.parseInt(totalReduces) == jip.desiredReduces() ? 1 : 0) != 0);
        String finMaps = (String)values.get(JobHistory.Keys.FINISHED_MAPS);
        TestJobHistory.assertTrue((String)"Unexpected number of finished maps in history file", (Integer.parseInt(finMaps) == jip.finishedMaps() ? 1 : 0) != 0);
        String finReduces = (String)values.get(JobHistory.Keys.FINISHED_REDUCES);
        TestJobHistory.assertTrue((String)"Unexpected number of finished reduces in history file", (Integer.parseInt(finReduces) == jip.finishedReduces() ? 1 : 0) != 0);
        String failedMaps = (String)values.get(JobHistory.Keys.FAILED_MAPS);
        TestJobHistory.assertTrue((String)"Unexpected number of failed maps in history file", (Integer.parseInt(failedMaps) == jip.failedMapTasks ? 1 : 0) != 0);
        String failedReduces = (String)values.get(JobHistory.Keys.FAILED_REDUCES);
        TestJobHistory.assertTrue((String)"Unexpected number of failed reduces in history file", (Integer.parseInt(failedReduces) == jip.failedReduceTasks ? 1 : 0) != 0);
    }

    private static void validateTaskLevelKeyValues(MiniMRCluster mr, RunningJob job, JobHistory.JobInfo jobInfo) throws IOException {
        JobTracker jt = mr.getJobTrackerRunner().getJobTracker();
        JobInProgress jip = jt.getJob(job.getID());
        TaskID mapTaskId = new TaskID((org.apache.hadoop.mapreduce.JobID)job.getID(), true, 0);
        TaskID reduceTaskId = new TaskID((org.apache.hadoop.mapreduce.JobID)job.getID(), false, 0);
        TaskInProgress[] cleanups = jip.getTasks(TaskType.JOB_CLEANUP);
        TaskID cleanupTaskId = cleanups[0].isComplete() ? cleanups[0].getTIPId() : cleanups[1].getTIPId();
        TaskInProgress[] setups = jip.getTasks(TaskType.JOB_SETUP);
        TaskID setupTaskId = setups[0].isComplete() ? setups[0].getTIPId() : setups[1].getTIPId();
        Map tasks = jobInfo.getAllTasks();
        for (JobHistory.Task task : tasks.values()) {
            String tid = task.get(JobHistory.Keys.TASKID);
            if (!tid.equals(mapTaskId.toString()) && !tid.equals(reduceTaskId.toString()) && !tid.equals(cleanupTaskId.toString()) && !tid.equals(setupTaskId.toString())) continue;
            TaskID taskId = null;
            if (tid.equals(mapTaskId.toString())) {
                taskId = mapTaskId;
            } else if (tid.equals(reduceTaskId.toString())) {
                taskId = reduceTaskId;
            } else if (tid.equals(cleanupTaskId.toString())) {
                taskId = cleanupTaskId;
            } else if (tid.equals(setupTaskId.toString())) {
                taskId = setupTaskId;
            }
            TaskInProgress tip = jip.getTaskInProgress(taskId);
            TestJobHistory.assertTrue((String)("START_TIME of Task " + tid + " obtained from history " + "file did not match the expected value"), (tip.getExecStartTime() == Long.parseLong(task.get(JobHistory.Keys.START_TIME)) ? 1 : 0) != 0);
            TestJobHistory.assertTrue((String)("FINISH_TIME of Task " + tid + " obtained from history " + "file did not match the expected value"), (tip.getExecFinishTime() == Long.parseLong(task.get(JobHistory.Keys.FINISH_TIME)) ? 1 : 0) != 0);
            if (taskId == mapTaskId) {
                TestJobHistory.assertTrue((String)("Splits of Task " + tid + " obtained from history file " + " did not match the expected value"), (boolean)tip.getSplitNodes().equals(task.get(JobHistory.Keys.SPLITS)));
            }
            TaskAttemptID attemptId = tip.getSuccessfulTaskid();
            TaskStatus ts = tip.getTaskStatus(attemptId);
            Counters c = ts.getCounters();
            TestJobHistory.assertTrue((String)("Counters of Task " + tid + " obtained from history file " + " did not match the expected value"), (boolean)c.makeEscapedCompactString().equals(task.get(JobHistory.Keys.COUNTERS)));
        }
    }

    private static void validateTaskAttemptLevelKeyValues(MiniMRCluster mr, RunningJob job, JobHistory.JobInfo jobInfo) throws IOException {
        JobTracker jt = mr.getJobTrackerRunner().getJobTracker();
        JobInProgress jip = jt.getJob(job.getID());
        Map tasks = jobInfo.getAllTasks();
        for (JobHistory.Task task : tasks.values()) {
            for (JobHistory.TaskAttempt attempt : task.getTaskAttempts().values()) {
                String idStr = attempt.get(JobHistory.Keys.TASK_ATTEMPT_ID);
                TaskAttemptID attemptId = TaskAttemptID.forName((String)idStr);
                TaskID tid = attemptId.getTaskID();
                TestJobHistory.assertTrue((String)("Task id of Task Attempt " + idStr + " obtained from " + "history file did not match the expected value"), (boolean)tid.toString().equals(attempt.get(JobHistory.Keys.TASKID)));
                TaskInProgress tip = jip.getTaskInProgress(tid);
                TaskStatus ts = tip.getTaskStatus(attemptId);
                TestJobHistory.assertTrue((String)("START_TIME of Task attempt " + idStr + " obtained from " + "history file did not match the expected value"), (ts.getStartTime() == Long.parseLong(attempt.get(JobHistory.Keys.START_TIME)) ? 1 : 0) != 0);
                TestJobHistory.assertTrue((String)("FINISH_TIME of Task attempt " + idStr + " obtained from " + "history file did not match the expected value"), (ts.getFinishTime() == Long.parseLong(attempt.get(JobHistory.Keys.FINISH_TIME)) ? 1 : 0) != 0);
                TaskTrackerStatus ttStatus = jt.getTaskTrackerStatus(ts.getTaskTracker());
                if (ttStatus != null) {
                    TestJobHistory.assertTrue((String)("http port of task attempt " + idStr + " obtained from " + "history file did not match the expected value"), (ttStatus.getHttpPort() == Integer.parseInt(attempt.get(JobHistory.Keys.HTTP_PORT)) ? 1 : 0) != 0);
                    if (attempt.get(JobHistory.Keys.TASK_STATUS).equals("SUCCESS")) {
                        String ttHostname = jt.getNode(ttStatus.getHost()).toString();
                        TestJobHistory.assertTrue((String)("Host name of task attempt " + idStr + " obtained from" + " history file did not match the expected value"), (boolean)ttHostname.equals(attempt.get(JobHistory.Keys.HOSTNAME)));
                    }
                }
                if (attempt.get(JobHistory.Keys.TASK_STATUS).equals("SUCCESS")) {
                    if (attempt.get(JobHistory.Keys.TASK_TYPE).equals("REDUCE")) {
                        TestJobHistory.assertTrue((String)("SHUFFLE_FINISHED time of task attempt " + idStr + " obtained from history file did not match the expected" + " value"), (ts.getShuffleFinishTime() == Long.parseLong(attempt.get(JobHistory.Keys.SHUFFLE_FINISHED)) ? 1 : 0) != 0);
                        TestJobHistory.assertTrue((String)("SORT_FINISHED time of task attempt " + idStr + " obtained from history file did not match the expected" + " value"), (ts.getSortFinishTime() == Long.parseLong(attempt.get(JobHistory.Keys.SORT_FINISHED)) ? 1 : 0) != 0);
                    }
                    Counters c = ts.getCounters();
                    TestJobHistory.assertTrue((String)("Counters of Task Attempt " + idStr + " obtained from " + "history file did not match the expected value"), (boolean)c.makeEscapedCompactString().equals(attempt.get(JobHistory.Keys.COUNTERS)));
                }
                TestJobHistory.assertTrue((String)("Tracker name of task attempt " + idStr + " obtained from " + "history file did not match the expected value"), (boolean)ts.getTaskTracker().equals(attempt.get(JobHistory.Keys.TRACKER_NAME)));
            }
        }
    }

    static void validateJobHistoryFileContent(MiniMRCluster mr, RunningJob job, JobConf conf) throws IOException {
        JobID id = job.getID();
        Path doneDir = JobHistory.getCompletedJobHistoryLocation();
        String logFileName = TestJobHistory.getDoneFile(conf, id, doneDir);
        Path logFile = new Path(doneDir, logFileName);
        FileSystem fileSys = logFile.getFileSystem((Configuration)conf);
        TestJobHistory.assertTrue((String)"History file does not exist", (boolean)fileSys.exists(logFile));
        String[] jobDetails = JobHistory.JobInfo.decodeJobHistoryFileName((String)logFileName).split("_");
        String jobId = jobDetails[2] + "_" + jobDetails[3] + "_" + jobDetails[4];
        JobHistory.JobInfo jobInfo = new JobHistory.JobInfo(jobId);
        DefaultJobHistoryParser.JobTasksParseListener l = new DefaultJobHistoryParser.JobTasksParseListener(jobInfo);
        JobHistory.parseHistoryFromFS((String)logFile.toString().substring(5), (JobHistory.Listener)l, (FileSystem)fileSys);
        TestJobHistory.validateJobLevelKeyValues(mr, job, jobInfo, conf);
        TestJobHistory.validateTaskLevelKeyValues(mr, job, jobInfo);
        TestJobHistory.validateTaskAttemptLevelKeyValues(mr, job, jobInfo);
        if (mr.getJobTrackerRunner().getJobTracker().areACLsEnabled()) {
            AccessControlList acl = new AccessControlList(conf.get(JobACL.VIEW_JOB.getAclName(), " "));
            TestJobHistory.assertTrue((boolean)acl.toString().equals(((AccessControlList)jobInfo.getJobACLs().get(JobACL.VIEW_JOB)).toString()));
            acl = new AccessControlList(conf.get(JobACL.MODIFY_JOB.getAclName(), " "));
            TestJobHistory.assertTrue((boolean)acl.toString().equals(((AccessControlList)jobInfo.getJobACLs().get(JobACL.MODIFY_JOB)).toString()));
        }
        TestJobHistory.assertTrue((boolean)jobInfo.getJobQueue().equals(conf.getQueueName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testDoneFolderOnHDFS() throws IOException {
        MiniMRCluster mr = null;
        try {
            JobConf conf = new JobConf();
            conf.setLong("mapred.jobtracker.retirejob.check", 1000L);
            conf.setLong("mapred.jobtracker.retirejob.interval", 100000L);
            String doneFolder = "history_done";
            conf.set("mapred.job.tracker.history.completed.location", doneFolder);
            MiniDFSCluster dfsCluster = new MiniDFSCluster((Configuration)conf, 2, true, null);
            mr = new MiniMRCluster(2, dfsCluster.getFileSystem().getUri().toString(), 3, null, null, conf);
            conf = mr.createJobConf();
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.delete(new Path("succeed"), true);
            Path inDir = new Path("succeed/input");
            Path outDir = new Path("succeed/output");
            conf.setSpeculativeExecution(false);
            conf.setInt("mapred.jobtracker.completeuserjobs.maximum", 10);
            conf.set("user.name", UserGroupInformation.getCurrentUser().getUserName());
            RunningJob job = UtilsForTests.runJobSucceed(conf, inDir, outDir);
            Path doneDir = JobHistory.getCompletedJobHistoryLocation();
            TestJobHistory.assertEquals((String)"History DONE folder not correct", (String)doneFolder, (String)doneDir.getName());
            JobID id = job.getID();
            String logFileName = TestJobHistory.getDoneFile(conf, id, doneDir);
            TestJobHistory.assertNotNull((Object)logFileName);
            System.err.println("testDoneFolderOnHDFS -- seeking " + logFileName);
            Path logFile = new Path(doneDir, logFileName);
            FileSystem fileSys = logFile.getFileSystem((Configuration)conf);
            TestJobHistory.assertTrue((String)"History file does not exist", (boolean)fileSys.exists(logFile));
            Path confFile = TestJobHistory.getPathForConf(logFile);
            TestJobHistory.assertTrue((String)("Config for completed jobs doesnt exist: " + confFile), (boolean)fileSys.exists(confFile));
            TestJobHistory.assertTrue((String)"Completed job config doesnt exist under the done folder", (boolean)confFile.toString().startsWith(doneDir.toString()));
            TestJobHistory.assertTrue((String)"Completed jobs doesnt exist under the done folder", (boolean)logFile.toString().startsWith(doneDir.toString()));
            TestJobHistory.assertTrue((String)"Completed job and config file aren't in the same directory", (boolean)confFile.getParent().toString().equals(logFile.getParent().toString()));
            Path cursor = logFile.getParent();
            Path doneParent = doneDir.getParent();
            FsPermission donePermission = TestJobHistory.getStatus(fileSys, doneDir).getPermission();
            System.err.println("testDoneFolderOnHDFS: done dir permission = " + donePermission);
            while (!cursor.equals((Object)doneParent)) {
                FileStatus cursorStatus = TestJobHistory.getStatus(fileSys, cursor);
                FsPermission cursorPermission = cursorStatus.getPermission();
                TestJobHistory.assertEquals((String)("testDoneFolderOnHDFS: A done directory descendant, " + cursor + " does not have the same permisison as the done directory, " + doneDir), (Object)donePermission, (Object)cursorPermission);
                cursor = cursor.getParent();
            }
            Path runningJobsHistoryFolder = logFile.getParent().getParent();
            Path runningJobHistoryFilename = new Path(runningJobsHistoryFolder, logFile.getName());
            Path runningJobConfFilename = new Path(runningJobsHistoryFolder, confFile.getName());
            TestJobHistory.assertFalse((String)"History file not deleted from the running folder", (boolean)fileSys.exists(runningJobHistoryFilename));
            TestJobHistory.assertFalse((String)"Config for completed jobs not deleted from running folder", (boolean)fileSys.exists(runningJobConfFilename));
            TestJobHistory.validateJobHistoryFileFormat(job.getID(), conf, "SUCCESS", false);
            TestJobHistory.validateJobHistoryFileContent(mr, job, conf);
            if (mr == null) return;
        }
        catch (Throwable throwable) {
            if (mr == null) throw throwable;
            this.cleanupLocalFiles(mr);
            mr.shutdown();
            throw throwable;
        }
        this.cleanupLocalFiles(mr);
        mr.shutdown();
    }

    private static FileStatus getStatus(FileSystem fs, final Path path) {
        Path pathParent = path.getParent();
        try {
            FileStatus[] statuses = fs.listStatus(pathParent, new PathFilter(){

                public boolean accept(Path filterPath) {
                    return filterPath.getName().equals(path.getName());
                }
            });
            return statuses[0];
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testJobHistoryFile() throws IOException {
        MiniMRCluster mr = null;
        try {
            JobConf conf = new JobConf();
            conf.setLong("mapred.jobtracker.retirejob.check", 1000L);
            conf.setLong("mapred.jobtracker.retirejob.interval", 100000L);
            String doneFolder = TEST_ROOT_DIR + "history_done";
            conf.set("mapred.job.tracker.history.completed.location", doneFolder);
            conf.setBoolean("mapred.acls.enabled", true);
            conf.set(QueueManager.toFullPropertyName((String)"default", (String)QueueManager.QueueACL.ADMINISTER_JOBS.getAclName()), " ");
            mr = new MiniMRCluster(2, "file:///", 3, null, null, conf);
            conf = mr.createJobConf();
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.delete(new Path(TEST_ROOT_DIR + "/succeed"), true);
            Path inDir = new Path(TEST_ROOT_DIR + "/succeed/input");
            Path outDir = new Path(TEST_ROOT_DIR + "/succeed/output");
            conf.setSpeculativeExecution(false);
            conf.set(JobACL.VIEW_JOB.getAclName(), "user1,user2 group1,group2");
            conf.set(JobACL.MODIFY_JOB.getAclName(), "user3,user4 group3,group4");
            conf.setInt("mapred.jobtracker.completeuserjobs.maximum", 10);
            conf.set("user.name", UserGroupInformation.getCurrentUser().getUserName());
            RunningJob job = UtilsForTests.runJobSucceed(conf, inDir, outDir);
            Path doneDir = JobHistory.getCompletedJobHistoryLocation();
            TestJobHistory.assertEquals((String)"History DONE folder not correct", (String)doneFolder, (String)doneDir.toString());
            JobID id = job.getID();
            String logFileName = TestJobHistory.getDoneFile(conf, id, doneDir);
            Path logFile = new Path(doneDir, logFileName);
            FileSystem fileSys = logFile.getFileSystem((Configuration)conf);
            System.err.println("testJobHistoryFile -- seeking " + logFile);
            TestJobHistory.assertTrue((String)"History file does not exist", (boolean)fileSys.exists(logFile));
            Path confFile = TestJobHistory.getPathForConf(logFile);
            TestJobHistory.assertTrue((String)("Config for completed jobs doesnt exist: " + confFile), (boolean)fileSys.exists(confFile));
            TestJobHistory.assertTrue((String)"Completed job config doesnt exist under the done folder", (boolean)confFile.toString().startsWith(doneDir.toString()));
            TestJobHistory.assertTrue((String)"Completed jobs doesnt exist in the done folder", (boolean)logFile.toString().startsWith(doneDir.toString()));
            TestJobHistory.assertTrue((String)"Completed job and config file aren't in the same directory", (boolean)confFile.getParent().toString().equals(logFile.getParent().toString()));
            Path runningJobsHistoryFolder = logFile.getParent().getParent();
            Path runningJobHistoryFilename = new Path(runningJobsHistoryFolder, logFile.getName());
            Path runningJobConfFilename = new Path(runningJobsHistoryFolder, confFile.getName());
            TestJobHistory.assertFalse((String)"History file not deleted from the running folder", (boolean)fileSys.exists(runningJobHistoryFilename));
            TestJobHistory.assertFalse((String)"Config for completed jobs not deleted from running folder", (boolean)fileSys.exists(runningJobConfFilename));
            TestJobHistory.validateJobHistoryFileFormat(job.getID(), conf, "SUCCESS", false);
            TestJobHistory.validateJobHistoryFileContent(mr, job, conf);
            String name = JobHistory.JobInfo.getLocalJobFilePath((JobID)job.getID());
            File file = new File(name);
            while (file.exists()) {
                LOG.info((Object)("Waiting for " + file + " to be deleted"));
                UtilsForTests.waitFor(100L);
            }
            if (mr == null) return;
        }
        catch (Throwable throwable) {
            if (mr == null) throw throwable;
            this.cleanupLocalFiles(mr);
            mr.shutdown();
            throw throwable;
        }
        this.cleanupLocalFiles(mr);
        mr.shutdown();
    }

    static String getDoneFile(JobConf conf, JobID id, Path doneDir) throws IOException {
        String name = null;
        for (int i = 0; name == null && i < 20; ++i) {
            name = JobHistory.JobInfo.getDoneJobHistoryFileName((JobConf)conf, (JobID)id);
            UtilsForTests.waitFor(1000L);
        }
        return name;
    }

    private static Path getLogLocationInOutputPath(String logFileName, JobConf conf) {
        JobConf jobConf = new JobConf(true);
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)FileOutputFormat.getOutputPath((JobConf)conf));
        Path result = JobHistory.JobInfo.getJobHistoryLogLocationForUser((String)logFileName, (JobConf)jobConf);
        return result;
    }

    private static String coreLogLocation(String subdirLogLocation) {
        return subdirLogLocation.substring(subdirLogLocation.lastIndexOf(47) + 1);
    }

    private static void validateJobHistoryUserLogLocation(JobID id, JobConf conf) throws IOException {
        Path doneDir = JobHistory.getCompletedJobHistoryLocation();
        String logFileName = TestJobHistory.getDoneFile(conf, id, doneDir);
        Path logFile = JobHistory.JobInfo.getJobHistoryLogLocationForUser((String)TestJobHistory.coreLogLocation(logFileName), (JobConf)conf);
        if (logFile == null) {
            logFile = TestJobHistory.getLogLocationInOutputPath(TestJobHistory.coreLogLocation(logFileName), conf);
        }
        FileSystem fileSys = null;
        fileSys = logFile.getFileSystem((Configuration)conf);
        if (conf.get("hadoop.job.history.user.location") == null) {
            TestJobHistory.assertTrue((String)("User log file " + logFile + " does not exist"), (boolean)fileSys.exists(logFile));
        } else if ("none".equals(conf.get("hadoop.job.history.user.location"))) {
            TestJobHistory.assertFalse((String)"Unexpected. User log file exists in output dir when hadoop.job.history.user.location is set to \"none\"", (boolean)fileSys.exists(logFile));
        } else {
            TestJobHistory.assertTrue((String)("User log file " + logFile + " does not exist"), (boolean)fileSys.exists(logFile));
            Path logFile1 = TestJobHistory.getLogLocationInOutputPath(logFileName, conf);
            if (logFile != logFile1) {
                fileSys = logFile1.getFileSystem((Configuration)conf);
                TestJobHistory.assertFalse((String)"Unexpected. User log file exists in output dir when hadoop.job.history.user.location is set to a different location", (boolean)fileSys.exists(logFile1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobHistoryUserLogLocation() throws IOException {
        MiniMRCluster mr = null;
        try {
            mr = new MiniMRCluster(2, "file:///", 3);
            JobConf conf = mr.createJobConf();
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.delete(new Path(TEST_ROOT_DIR + "/succeed"), true);
            Path inDir = new Path(TEST_ROOT_DIR + "/succeed/input1");
            Path outDir = new Path(TEST_ROOT_DIR + "/succeed/output1");
            conf.set("user.name", UserGroupInformation.getCurrentUser().getUserName());
            RunningJob job = UtilsForTests.runJobSucceed(conf, inDir, outDir);
            TestJobHistory.validateJobHistoryUserLogLocation(job.getID(), conf);
            inDir = new Path(TEST_ROOT_DIR + "/succeed/input2");
            outDir = new Path(TEST_ROOT_DIR + "/succeed/output2");
            conf.set("hadoop.job.history.user.location", "none");
            job = UtilsForTests.runJobSucceed(conf, inDir, outDir);
            TestJobHistory.validateJobHistoryUserLogLocation(job.getID(), conf);
            inDir = new Path(TEST_ROOT_DIR + "/succeed/input3");
            outDir = new Path(TEST_ROOT_DIR + "/succeed/output3");
            conf.set("hadoop.job.history.user.location", TEST_ROOT_DIR + "/succeed");
            job = UtilsForTests.runJobSucceed(conf, inDir, outDir);
            TestJobHistory.validateJobHistoryUserLogLocation(job.getID(), conf);
        }
        finally {
            if (mr != null) {
                this.cleanupLocalFiles(mr);
                mr.shutdown();
            }
        }
    }

    private void cleanupLocalFiles(MiniMRCluster mr) throws IOException {
        JobConf conf = mr.createJobConf();
        JobTracker jt = mr.getJobTrackerRunner().getJobTracker();
        Path sysDir = new Path(jt.getSystemDir());
        FileSystem fs = sysDir.getFileSystem((Configuration)conf);
        fs.delete(sysDir, true);
        Path jobHistoryDir = JobHistory.getJobHistoryLocation();
        fs = jobHistoryDir.getFileSystem((Configuration)conf);
        fs.delete(jobHistoryDir, true);
    }

    private static void validateJobHistoryJobStatus(JobID id, JobConf conf, String status) throws IOException {
        Path doneDir = JobHistory.getCompletedJobHistoryLocation();
        String logFileName = TestJobHistory.getDoneFile(conf, id, doneDir);
        Path logFile = new Path(doneDir, logFileName);
        FileSystem fileSys = logFile.getFileSystem((Configuration)conf);
        System.err.println("validateJobHistoryJobStatus -- seeking " + logFile);
        TestJobHistory.assertTrue((String)"History file does not exist", (boolean)fileSys.exists(logFile));
        TestJobHistory.assertTrue((String)"History file permissions does not match", (boolean)fileSys.getFileStatus(logFile).getPermission().equals((Object)new FsPermission(JobHistory.HISTORY_FILE_PERMISSION)));
        String[] jobDetails = JobHistory.JobInfo.decodeJobHistoryFileName((String)logFileName).split("_");
        String jobId = jobDetails[2] + "_" + jobDetails[3] + "_" + jobDetails[4];
        JobHistory.JobInfo jobInfo = new JobHistory.JobInfo(jobId);
        DefaultJobHistoryParser.JobTasksParseListener l = new DefaultJobHistoryParser.JobTasksParseListener(jobInfo);
        JobHistory.parseHistoryFromFS((String)logFile.toString().substring(5), (JobHistory.Listener)l, (FileSystem)fileSys);
        TestJobHistory.assertTrue((String)"Job Status read from job history file is not the expected status", (boolean)status.equals(jobInfo.getValues().get(JobHistory.Keys.JOB_STATUS)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobHistoryJobStatus() throws IOException {
        MiniMRCluster mr = null;
        try {
            mr = new MiniMRCluster(2, "file:///", 3);
            JobConf conf = mr.createJobConf();
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.delete(new Path(TEST_ROOT_DIR + "/succeedfailkilljob"), true);
            Path inDir = new Path(TEST_ROOT_DIR + "/succeedfailkilljob/input");
            Path outDir = new Path(TEST_ROOT_DIR + "/succeedfailkilljob/output");
            conf.set("user.name", UserGroupInformation.getCurrentUser().getUserName());
            RunningJob job = UtilsForTests.runJobSucceed(conf, inDir, outDir);
            TestJobHistory.validateJobHistoryJobStatus(job.getID(), conf, "SUCCESS");
            long historyCleanerRanAt = JobHistory.HistoryCleaner.getLastRan();
            TestJobHistory.assertTrue((historyCleanerRanAt != 0L ? 1 : 0) != 0);
            job = UtilsForTests.runJobFail(conf, inDir, outDir);
            TestJobHistory.validateJobHistoryJobStatus(job.getID(), conf, "FAILED");
            TestJobHistory.assertTrue((historyCleanerRanAt == JobHistory.HistoryCleaner.getLastRan() ? 1 : 0) != 0);
            job = UtilsForTests.runJobKill(conf, inDir, outDir);
            TestJobHistory.validateJobHistoryJobStatus(job.getID(), conf, "KILLED");
            TestJobHistory.assertTrue((historyCleanerRanAt == JobHistory.HistoryCleaner.getLastRan() ? 1 : 0) != 0);
        }
        finally {
            if (mr != null) {
                this.cleanupLocalFiles(mr);
                mr.shutdown();
            }
        }
    }

    static class TestListener
    extends DefaultJobHistoryParser.JobTasksParseListener {
        int lineNum = 0;
        boolean isJobLaunched = false;
        boolean isJTRestarted = false;

        TestListener(JobHistory.JobInfo job) {
            super(job);
        }

        public void handle(JobHistory.RecordTypes recType, Map<JobHistory.Keys, String> values) throws IOException {
            ++this.lineNum;
            if (recType == JobHistory.RecordTypes.Meta) {
                long version = Long.parseLong(values.get(JobHistory.Keys.VERSION));
                Assert.assertTrue((String)"Unexpected job history version ", (version >= 0L && version <= 1L ? 1 : 0) != 0);
            } else if (recType.equals((Object)JobHistory.RecordTypes.Job)) {
                String jobid = values.get(JobHistory.Keys.JOBID);
                Assert.assertTrue((String)("record type 'Job' is seen without JOBID key in history file at line " + this.lineNum), (jobid != null ? 1 : 0) != 0);
                JobID id = JobID.forName((String)jobid);
                Assert.assertTrue((String)("JobID in history file is in unexpected format at line " + this.lineNum), (id != null ? 1 : 0) != 0);
                String time = values.get(JobHistory.Keys.LAUNCH_TIME);
                if (time != null) {
                    if (this.isJobLaunched) {
                        this.isJTRestarted = true;
                    } else {
                        this.isJobLaunched = true;
                    }
                }
                if ((time = values.get(JobHistory.Keys.FINISH_TIME)) != null) {
                    Assert.assertTrue((String)("Job FINISH_TIME is seen in history file at line " + this.lineNum + " before LAUNCH_TIME is seen"), (boolean)this.isJobLaunched);
                }
            } else if (recType.equals((Object)JobHistory.RecordTypes.Task)) {
                String s;
                String taskid = values.get(JobHistory.Keys.TASKID);
                Assert.assertTrue((String)("record type 'Task' is seen without TASKID key in history file at line " + this.lineNum), (taskid != null ? 1 : 0) != 0);
                TaskID id = TaskID.forName((String)taskid);
                Assert.assertTrue((String)("TaskID in history file is in unexpected format at line " + this.lineNum), (id != null ? 1 : 0) != 0);
                String time = values.get(JobHistory.Keys.START_TIME);
                if (time != null) {
                    ArrayList attemptIDs = (ArrayList)taskIDsToAttemptIDs.get(taskid);
                    Assert.assertTrue((String)("Duplicate START_TIME seen for task " + taskid + " in history file at line " + this.lineNum), (attemptIDs == null ? 1 : 0) != 0);
                    attemptIDs = new ArrayList();
                    taskIDsToAttemptIDs.put(taskid, attemptIDs);
                    if (this.isJTRestarted) {
                        tempIgnoreStartTimeOfTasks.add(taskid);
                    }
                }
                if ((time = values.get(JobHistory.Keys.FINISH_TIME)) != null && (s = values.get(JobHistory.Keys.TASK_STATUS)) != null) {
                    ArrayList attemptIDs = (ArrayList)taskIDsToAttemptIDs.get(taskid);
                    Assert.assertTrue((String)("Task FINISH_TIME is seen in history file at line " + this.lineNum + " before START_TIME is seen"), (attemptIDs != null ? 1 : 0) != 0);
                    Assert.assertTrue((String)("TaskId " + taskid + " is finished at line " + this.lineNum + " but its attemptID is not finished."), (attemptIDs.size() <= 1 ? 1 : 0) != 0);
                    Assert.assertTrue((String)("TaskId " + taskid + " is finished at line " + this.lineNum + " but no attemptID is seen before this."), (attemptIDs.size() == 1 ? 1 : 0) != 0);
                    if (s.equals("KILLED") || s.equals("FAILED")) {
                        attemptIDs = new ArrayList();
                        taskIDsToAttemptIDs.put(taskid, attemptIDs);
                    } else {
                        taskEnds.add(taskid);
                    }
                }
            } else if (recType.equals((Object)JobHistory.RecordTypes.MapAttempt) || recType.equals((Object)JobHistory.RecordTypes.ReduceAttempt)) {
                List attemptIDs;
                String taskid = values.get(JobHistory.Keys.TASKID);
                Assert.assertTrue((String)("record type " + recType + " is seen without TASKID key" + " in history file at line " + this.lineNum), (taskid != null ? 1 : 0) != 0);
                String attemptId = values.get(JobHistory.Keys.TASK_ATTEMPT_ID);
                TaskAttemptID id = TaskAttemptID.forName((String)attemptId);
                Assert.assertTrue((String)("AttemptID in history file is in unexpected format at line " + this.lineNum), (id != null ? 1 : 0) != 0);
                String time = values.get(JobHistory.Keys.START_TIME);
                if (time != null) {
                    attemptIDs = (List)taskIDsToAttemptIDs.get(taskid);
                    Assert.assertTrue((String)("TaskAttempt is seen in history file at line " + this.lineNum + " before Task is seen"), (attemptIDs != null ? 1 : 0) != 0);
                    Assert.assertFalse((String)("Duplicate TaskAttempt START_TIME is seen in history file at line " + this.lineNum), (boolean)attemptIDs.remove(attemptId));
                    if (attemptIDs.isEmpty()) {
                        attemptIDs.add("firstAttemptIsSeen");
                    }
                    attemptIDs.add(attemptId);
                    if (tempIgnoreStartTimeOfTasks.contains(taskid) && id.getId() < 1000) {
                        ignoreStartTimeOfTasks.add(taskid);
                    }
                }
                if ((time = values.get(JobHistory.Keys.FINISH_TIME)) != null) {
                    attemptIDs = (List)taskIDsToAttemptIDs.get(taskid);
                    Assert.assertTrue((String)("TaskAttempt FINISH_TIME is seen in history file at line " + this.lineNum + " before Task is seen"), (attemptIDs != null ? 1 : 0) != 0);
                    Assert.assertTrue((String)("TaskAttempt FINISH_TIME is seen in history file at line " + this.lineNum + " before TaskAttempt START_TIME is seen"), (boolean)attemptIDs.remove(attemptId));
                }
            }
            super.handle(recType, values);
        }
    }
}

