/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SecondarySort;
import org.apache.hadoop.examples.WordCount;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MRCaching;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TestMiniMRWithDFS;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TestMapReduceLocal;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;

public class TestMiniMRLocalFS
extends TestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithLocal() throws IOException, InterruptedException, ClassNotFoundException {
        MiniMRCluster mr = null;
        try {
            mr = new MiniMRCluster(2, "file:///", 3);
            mr.setInlineCleanupThreads();
            TestMiniMRWithDFS.runPI(mr, mr.createJobConf());
            JobConf job = mr.createJobConf();
            MRCaching.TestResult ret = MRCaching.launchMRCache(TEST_ROOT_DIR + "/wc/input", TEST_ROOT_DIR + "/wc/output", TEST_ROOT_DIR + "/cachedir", job, "The quick brown fox\nhas many silly\nred fox sox\n");
            TestMiniMRLocalFS.assertTrue((String)"Failed test archives not matching", (boolean)ret.isOutputOk);
            JobClient client = new JobClient(job);
            JobID jobid = ret.job.getID();
            TaskReport[] reports = client.getSetupTaskReports(jobid);
            TestMiniMRLocalFS.assertEquals((String)"number of setups", (int)2, (int)reports.length);
            reports = client.getMapTaskReports(jobid);
            TestMiniMRLocalFS.assertEquals((String)"number of maps", (int)1, (int)reports.length);
            reports = client.getReduceTaskReports(jobid);
            TestMiniMRLocalFS.assertEquals((String)"number of reduces", (int)1, (int)reports.length);
            reports = client.getCleanupTaskReports(jobid);
            TestMiniMRLocalFS.assertEquals((String)"number of cleanups", (int)2, (int)reports.length);
            Counters counters = ret.job.getCounters();
            TestMiniMRLocalFS.assertEquals((String)"number of map inputs", (long)3L, (long)counters.getCounter((Enum)Task.Counter.MAP_INPUT_RECORDS));
            TestMiniMRLocalFS.assertEquals((String)"number of reduce outputs", (long)9L, (long)counters.getCounter((Enum)Task.Counter.REDUCE_OUTPUT_RECORDS));
            this.runCustomFormats(mr);
            this.runSecondarySort((Configuration)mr.createJobConf());
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCustomFormats(MiniMRCluster mr) throws IOException {
        JobConf job = mr.createJobConf();
        FileSystem fileSys = FileSystem.get((Configuration)job);
        Path testDir = new Path(TEST_ROOT_DIR + "/test_mini_mr_local");
        Path outDir = new Path(testDir, "out");
        System.out.println("testDir= " + testDir);
        fileSys.delete(testDir, true);
        job.setInputFormat(MyInputFormat.class);
        job.setOutputFormat(MyOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        job.setNumMapTasks(100);
        job.setNumReduceTasks(1);
        job.set("non.std.out", outDir.toString());
        try {
            JobClient.runJob((JobConf)job);
            String result = TestMiniMRWithDFS.readOutput(outDir, job);
            TestMiniMRLocalFS.assertEquals((String)"output", (String)"aunt annie\t1\nbumble boat\t4\ncrocodile pants\t0\nduck-dog\t5\neggs\t2\nfinagle the agent\t3\n", (String)result);
        }
        finally {
            fileSys.delete(testDir, true);
        }
    }

    private void runSecondarySort(Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        localFs.delete(new Path(TEST_ROOT_DIR + "/in"), true);
        localFs.delete(new Path(TEST_ROOT_DIR + "/out"), true);
        TestMapReduceLocal.writeFile("in/part1", "-1 -4\n-3 23\n5 10\n-1 -2\n-1 300\n-1 10\n4 1\n4 2\n4 10\n4 -1\n4 -10\n10 20\n10 30\n10 25\n");
        Job job = new Job(conf, "word count");
        job.setJarByClass(WordCount.class);
        job.setNumReduceTasks(2);
        job.setMapperClass(SecondarySort.MapClass.class);
        job.setReducerClass(SecondarySort.Reduce.class);
        job.setPartitionerClass(SecondarySort.FirstPartitioner.class);
        job.setGroupingComparatorClass(SecondarySort.FirstGroupingComparator.class);
        job.setMapOutputKeyClass(SecondarySort.IntPair.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(TEST_ROOT_DIR + "/in"));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(TEST_ROOT_DIR + "/out"));
        TestMiniMRLocalFS.assertTrue((boolean)job.waitForCompletion(true));
        String out = TestMapReduceLocal.readFile("out/part-r-00000");
        TestMiniMRLocalFS.assertEquals((String)"------------------------------------------------\n4\t-10\n4\t-1\n4\t1\n4\t2\n4\t10\n------------------------------------------------\n10\t20\n10\t25\n10\t30\n", (String)out);
        out = TestMapReduceLocal.readFile("out/part-r-00001");
        TestMiniMRLocalFS.assertEquals((String)"------------------------------------------------\n-3\t23\n------------------------------------------------\n-1\t-4\n-1\t-2\n-1\t10\n-1\t300\n------------------------------------------------\n5\t10\n", (String)out);
    }

    static class MyOutputFormat
    implements OutputFormat {
        MyOutputFormat() {
        }

        public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
            return new MyRecordWriter(new Path(job.get("non.std.out")), job);
        }

        public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        }

        static class MyRecordWriter
        implements RecordWriter<Object, Object> {
            private DataOutputStream out;

            public MyRecordWriter(Path outputFile, JobConf job) throws IOException {
                this.out = outputFile.getFileSystem((Configuration)job).create(outputFile);
            }

            public void write(Object key, Object value) throws IOException {
                this.out.writeBytes(key.toString() + "\t" + value.toString() + "\n");
            }

            public void close(Reporter reporter) throws IOException {
                this.out.close();
            }
        }
    }

    static class MyReducer
    extends MapReduceBase
    implements Reducer<WritableComparable, Writable, WritableComparable, Writable> {
        MyReducer() {
        }

        public void reduce(WritableComparable key, Iterator<Writable> values, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
            try {
                InputSplit split = reporter.getInputSplit();
                throw new IOException("Got an input split of " + split);
            }
            catch (UnsupportedOperationException e) {
                while (values.hasNext()) {
                    Writable value = values.next();
                    System.out.println("reduce: " + key + ", " + value);
                    output.collect((Object)key, (Object)value);
                }
                return;
            }
        }
    }

    static class MyMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        MyMapper() {
        }

        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, Writable> out, Reporter reporter) throws IOException {
            System.out.println("map: " + key + ", " + value);
            out.collect((Object)((WritableComparable)value), (Object)key);
            InputSplit split = reporter.getInputSplit();
            if (split.getClass() != MyInputFormat.MySplit.class) {
                throw new IOException("Got wrong split in MyMapper! " + split.getClass().getName());
            }
        }
    }

    private static class MyInputFormat
    implements InputFormat<IntWritable, Text> {
        static final String[] data = new String[]{"crocodile pants", "aunt annie", "eggs", "finagle the agent", "bumble boat", "duck-dog"};

        private MyInputFormat() {
        }

        public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            return new MySplit[]{new MySplit(0, 1), new MySplit(1, 3), new MySplit(4, 2)};
        }

        public RecordReader<IntWritable, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            MySplit sp = (MySplit)split;
            return new MyRecordReader(sp.first, sp.length);
        }

        static class MyRecordReader
        implements RecordReader<IntWritable, Text> {
            int index;
            int past;
            int length;

            MyRecordReader(int index, int length) {
                this.index = index;
                this.past = index + length;
                this.length = length;
            }

            public boolean next(IntWritable key, Text value) throws IOException {
                if (this.index < this.past) {
                    key.set(this.index);
                    value.set(data[this.index]);
                    ++this.index;
                    return true;
                }
                return false;
            }

            public IntWritable createKey() {
                return new IntWritable();
            }

            public Text createValue() {
                return new Text();
            }

            public long getPos() throws IOException {
                return this.index;
            }

            public void close() throws IOException {
            }

            public float getProgress() throws IOException {
                return 1.0f - (float)((this.past - this.index) / this.length);
            }
        }

        private static class MySplit
        implements InputSplit {
            int first;
            int length;

            public MySplit() {
            }

            public MySplit(int first, int length) {
                this.first = first;
                this.length = length;
            }

            public String[] getLocations() {
                return new String[0];
            }

            public long getLength() {
                return this.length;
            }

            public void write(DataOutput out) throws IOException {
                WritableUtils.writeVInt((DataOutput)out, (int)this.first);
                WritableUtils.writeVInt((DataOutput)out, (int)this.length);
            }

            public void readFields(DataInput in) throws IOException {
                this.first = WritableUtils.readVInt((DataInput)in);
                this.length = WritableUtils.readVInt((DataInput)in);
            }
        }
    }
}

