/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.DefaultJobHistoryParser;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.junit.Assert;

public class TestRawHistoryFile
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestRawHistoryFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRetrieveHistoryFile() {
        MiniMRCluster mrCluster = null;
        JobConf conf = new JobConf();
        try {
            conf.setLong("mapred.job.tracker.retiredjobs.cache.size", 1L);
            conf.setLong("mapred.jobtracker.retirejob.interval", 0L);
            conf.setLong("mapred.jobtracker.retirejob.check", 0L);
            conf.setLong("mapred.jobtracker.completeuserjobs.maximum", 1L);
            conf.set("mapreduce.history.server.http.address", "localhost:0");
            mrCluster = new MiniMRCluster(1, conf.get("fs.default.name"), 1, null, null, conf);
            conf = mrCluster.createJobConf();
            this.createInputFile((Configuration)conf, "/tmp/input");
            RunningJob job = this.runJob(conf);
            LOG.info((Object)("Job details: " + job));
            String historyFile = this.saveHistoryFile(job.getTrackingURL().replaceAll("jobdetails.jsp", "gethistory.jsp"));
            JobHistory.JobInfo jobInfo = new JobHistory.JobInfo(job.getJobID());
            DefaultJobHistoryParser.parseJobTasks((String)historyFile, (JobHistory.JobInfo)jobInfo, (FileSystem)FileSystem.getLocal((Configuration)conf));
            LOG.info((Object)("STATUS: " + (String)jobInfo.getValues().get(JobHistory.Keys.JOB_STATUS)));
            LOG.info((Object)("JOBID: " + (String)jobInfo.getValues().get(JobHistory.Keys.JOBID)));
            Assert.assertEquals(jobInfo.getValues().get(JobHistory.Keys.JOB_STATUS), (Object)"SUCCESS");
            Assert.assertEquals(jobInfo.getValues().get(JobHistory.Keys.JOBID), (Object)job.getJobID());
        }
        catch (IOException e) {
            LOG.error((Object)"Failure running test", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (mrCluster != null) {
                mrCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunningJob() {
        MiniMRCluster mrCluster = null;
        JobConf conf = new JobConf();
        try {
            conf.setLong("mapred.job.tracker.retiredjobs.cache.size", 1L);
            conf.setLong("mapred.jobtracker.retirejob.interval", 0L);
            conf.setLong("mapred.jobtracker.retirejob.check", 0L);
            conf.setLong("mapred.jobtracker.completeuserjobs.maximum", 0L);
            conf.set("mapreduce.history.server.http.address", "localhost:0");
            mrCluster = new MiniMRCluster(1, conf.get("fs.default.name"), 1, null, null, conf);
            conf = mrCluster.createJobConf();
            this.createInputFile((Configuration)conf, "/tmp/input");
            RunningJob job = this.submitJob(conf);
            LOG.info((Object)("Job details: " + job));
            String url = job.getTrackingURL().replaceAll("jobdetails.jsp", "gethistory.jsp");
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(url);
            try {
                int status = client.executeMethod((HttpMethod)method);
                Assert.assertEquals((long)status, (long)400L);
            }
            finally {
                method.releaseConnection();
                job.killJob();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failure running test", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (mrCluster != null) {
                mrCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRetrieveInvalidJob() {
        MiniMRCluster mrCluster = null;
        JobConf conf = new JobConf();
        try {
            conf.set("mapreduce.history.server.http.address", "localhost:0");
            mrCluster = new MiniMRCluster(1, conf.get("fs.default.name"), 1, null, null, conf);
            JobConf jobConf = mrCluster.createJobConf();
            String url = "http://" + jobConf.get("mapred.job.tracker.http.address") + "/gethistory.jsp?jobid=job_20100714163314505_9991";
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(url);
            try {
                int status = client.executeMethod((HttpMethod)method);
                Assert.assertEquals((long)status, (long)400L);
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failure running test", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (mrCluster != null) {
                mrCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInputFile(Configuration conf, String path) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream out = fs.create(new Path(path));
        try {
            out.write("hello world".getBytes());
        }
        finally {
            out.close();
        }
    }

    private synchronized RunningJob runJob(JobConf conf) throws IOException {
        this.configureJob(conf);
        return JobClient.runJob((JobConf)conf);
    }

    private synchronized RunningJob submitJob(JobConf conf) throws IOException {
        this.configureJob(conf);
        JobClient client = new JobClient(conf);
        return client.submitJob(conf);
    }

    private void configureJob(JobConf conf) {
        conf.setJobName("History");
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(NullOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (String)"/tmp/input");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveHistoryFile(String url) throws IOException {
        LOG.info((Object)("History url: " + url));
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        try {
            int status = client.executeMethod((HttpMethod)method);
            Assert.assertEquals((long)status, (long)200L);
            File out = File.createTempFile("HIST_", "hist");
            IOUtils.copyBytes((InputStream)method.getResponseBodyAsStream(), (OutputStream)new FileOutputStream(out), (int)4096, (boolean)true);
            String string = out.getAbsolutePath();
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }
}

