/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.TaskType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTaskLauncherThreaded {
    private static int jobLocalizedCount = 0;
    private static int jobLaunchCount = 0;
    private static boolean quitWaiting = false;
    private static boolean firstJobStarted = false;
    private static boolean firstJobFinished = false;

    @Test
    public void testLocalizationNotBlockingOtherTasks() throws IOException {
        int i;
        JobConf ttConf = new JobConf();
        ttConf.setInt("mapred.tasktracker.map.tasks.maximum", 4);
        MyTaskTracker tt = new MyTaskTracker();
        tt.runningJobs = new TreeMap();
        tt.runningTasks = new LinkedHashMap();
        tt.setIndexCache(new IndexCache(ttConf));
        tt.setTaskMemoryManagerEnabledFlag();
        MyTaskTracker myTaskTracker = tt;
        ((Object)((Object)myTaskTracker)).getClass();
        TaskTracker.TaskLauncher mapLauncher = new TaskTracker.TaskLauncher((TaskTracker)myTaskTracker, TaskType.MAP, 4);
        mapLauncher.start();
        String jtId = "test";
        TaskAttemptID attemptID = new TaskAttemptID(jtId, 1, true, 0, 0);
        MapTask task = new MapTask(null, attemptID, 0, null, 2);
        mapLauncher.addToTaskQueue(new LaunchTaskAction((Task)task));
        TaskTracker.TaskInProgress runningTip = (TaskTracker.TaskInProgress)tt.runningTasks.get(attemptID);
        Assert.assertNotNull((Object)runningTip);
        for (int i2 = 0; i2 < 300 && !firstJobStarted; ++i2) {
            UtilsForTests.waitFor(100L);
        }
        String secondjtId = "test2";
        TaskAttemptID secondAttemptID = new TaskAttemptID(secondjtId, 1, true, 0, 0);
        MapTask secondTask = new MapTask(null, secondAttemptID, 0, null, 2);
        mapLauncher.addToTaskQueue(new LaunchTaskAction((Task)secondTask));
        TaskTracker.TaskInProgress secondRunningTip = (TaskTracker.TaskInProgress)tt.runningTasks.get(secondAttemptID);
        Assert.assertNotNull((Object)secondRunningTip);
        for (i = 0; i < 300 && jobLaunchCount <= 0; ++i) {
            UtilsForTests.waitFor(100L);
        }
        Assert.assertEquals((String)"Second task didn't run or both ran", (long)1L, (long)jobLocalizedCount);
        Assert.assertEquals((String)"second task didn't try to launch", (long)1L, (long)jobLaunchCount);
        Assert.assertFalse((String)"Second task didn't finish first task initializing", (boolean)firstJobFinished);
        quitWaiting = true;
        for (i = 0; i < 300 && !firstJobFinished; ++i) {
            UtilsForTests.waitFor(100L);
        }
        Assert.assertTrue((String)"First task didn't finish initializing", (boolean)firstJobFinished);
        for (i = 0; i < 300 && jobLaunchCount <= 1; ++i) {
            UtilsForTests.waitFor(100L);
        }
        Assert.assertEquals((String)"Both tasks didn't run", (long)2L, (long)jobLocalizedCount);
        Assert.assertEquals((String)"First task didn't try to launch", (long)2L, (long)jobLaunchCount);
    }

    private static class MyTaskTracker
    extends TaskTracker {
        private MyTaskTracker() {
        }

        TaskTracker.RunningJob localizeJob(TaskTracker.TaskInProgress tip) throws IOException, InterruptedException {
            if (!firstJobStarted) {
                firstJobStarted = true;
                while (!quitWaiting) {
                    Thread.sleep(100L);
                }
                firstJobFinished = true;
            }
            TaskTracker.RunningJob rjob = (TaskTracker.RunningJob)Mockito.mock(TaskTracker.RunningJob.class);
            Mockito.when((Object)rjob.getLocalizedJobConf()).thenReturn((Object)new Path("testing"));
            Mockito.when((Object)rjob.getJobConf()).thenReturn((Object)new JobConf());
            jobLocalizedCount++;
            return rjob;
        }

        protected void launchTaskForJob(TaskTracker.TaskInProgress tip, JobConf jobConf, TaskTracker.RunningJob rjob) throws IOException {
            jobLaunchCount++;
        }
    }
}

