/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.KeyValueLineRecordReader;
import org.apache.hadoop.mapreduce.lib.input.KeyValueTextInputFormat;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;

public class TestKeyValueTextInputFormat
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestKeyValueTextInputFormat.class.getName());
    private static int MAX_LENGTH = 10000;
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() throws Exception {
        Job job = new Job(defaultConf);
        Path file = new Path(workDir, "test.txt");
        int seed = new Random().nextInt();
        LOG.info((Object)("seed = " + seed));
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            LOG.debug((Object)("creating; entries = " + length));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));
            try {
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i * 2));
                    writer.write("\t");
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            finally {
                ((Writer)writer).close();
            }
            KeyValueTextInputFormat format = new KeyValueTextInputFormat();
            JobContext jobContext = new JobContext(job.getConfiguration(), new JobID());
            List splits = format.getSplits(jobContext);
            LOG.debug((Object)("splitting: got =        " + splits.size()));
            TaskAttemptContext context = new TaskAttemptContext(job.getConfiguration(), new TaskAttemptID());
            BitSet bits = new BitSet(length);
            for (InputSplit split : splits) {
                LOG.debug((Object)("split= " + split));
                RecordReader reader = format.createRecordReader(split, context);
                Class<?> readerClass = reader.getClass();
                TestKeyValueTextInputFormat.assertEquals((String)"reader class is KeyValueLineRecordReader.", KeyValueLineRecordReader.class, readerClass);
                reader.initialize(split, context);
                try {
                    int count = 0;
                    while (reader.nextKeyValue()) {
                        int v = Integer.parseInt(((Text)reader.getCurrentValue()).toString());
                        LOG.debug((Object)("read " + v));
                        if (bits.get(v)) {
                            LOG.warn((Object)("conflict with " + v + " in split " + split + " at " + reader.getProgress()));
                        }
                        TestKeyValueTextInputFormat.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                        bits.set(v);
                        ++count;
                    }
                    LOG.debug((Object)("split=" + split + " count=" + count));
                }
                finally {
                    reader.close();
                }
            }
            TestKeyValueTextInputFormat.assertEquals((String)"Some keys in no partition.", (int)length, (int)bits.cardinality());
        }
    }

    private LineReader makeStream(String str) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), defaultConf);
    }

    public void testUTF8() throws Exception {
        LineReader in = this.makeStream("abcd\u20acbdcd\u20ac");
        Text line = new Text();
        in.readLine(line);
        TestKeyValueTextInputFormat.assertEquals((String)"readLine changed utf8 characters", (String)"abcd\u20acbdcd\u20ac", (String)line.toString());
        in = this.makeStream("abc\u200axyz");
        in.readLine(line);
        TestKeyValueTextInputFormat.assertEquals((String)"split on fake newline", (String)"abc\u200axyz", (String)line.toString());
    }

    public void testNewLines() throws Exception {
        LineReader in = this.makeStream("a\nbb\n\nccc\rdddd\r\neeeee");
        Text out = new Text();
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line1 length", (int)1, (int)out.getLength());
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line2 length", (int)2, (int)out.getLength());
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line3 length", (int)0, (int)out.getLength());
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line4 length", (int)3, (int)out.getLength());
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line5 length", (int)4, (int)out.getLength());
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line5 length", (int)5, (int)out.getLength());
        TestKeyValueTextInputFormat.assertEquals((String)"end of file", (int)0, (int)in.readLine(out));
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(KeyValueTextInputFormat format, InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        ArrayList<Text> result = new ArrayList<Text>();
        RecordReader reader = format.createRecordReader(split, context);
        reader.initialize(split, context);
        while (reader.nextKeyValue()) {
            result.add(new Text((Text)reader.getCurrentValue()));
        }
        return result;
    }

    public static void testGzip() throws Exception {
        Job job = new Job();
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)job.getConfiguration());
        localFs.delete(workDir, true);
        TestKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, "line-1\tthe quick\nline-2\tbrown\nline-3\tfox jumped\nline-4\tover\nline-5\t the lazy\nline-6\t dog\n");
        TestKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, "line-1\tthis is a test\nline-1\tof gzip\n");
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        KeyValueTextInputFormat format = new KeyValueTextInputFormat();
        JobContext jobContext = new JobContext(job.getConfiguration(), new JobID());
        TaskAttemptContext context = new TaskAttemptContext(job.getConfiguration(), new TaskAttemptID());
        List splits = format.getSplits(jobContext);
        TestKeyValueTextInputFormat.assertEquals((String)"compressed splits == 2", (int)2, (int)splits.size());
        FileSplit tmp = (FileSplit)splits.get(0);
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits.set(0, splits.get(1));
            splits.set(1, tmp);
        }
        List<Text> results = TestKeyValueTextInputFormat.readSplit(format, (InputSplit)splits.get(0), context);
        TestKeyValueTextInputFormat.assertEquals((String)"splits[0] length", (int)6, (int)results.size());
        TestKeyValueTextInputFormat.assertEquals((String)"splits[0][5]", (String)" dog", (String)results.get(5).toString());
        results = TestKeyValueTextInputFormat.readSplit(format, (InputSplit)splits.get(1), context);
        TestKeyValueTextInputFormat.assertEquals((String)"splits[1] length", (int)2, (int)results.size());
        TestKeyValueTextInputFormat.assertEquals((String)"splits[1][0]", (String)"this is a test", (String)results.get(0).toString());
        TestKeyValueTextInputFormat.assertEquals((String)"splits[1][1]", (String)"of gzip", (String)results.get(1).toString());
    }

    public static void main(String[] args) throws Exception {
        new TestKeyValueTextInputFormat().testFormat();
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestKeyValueTextInputFormat");
    }
}

