/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.junit.Assert;

class ConfigUtil {
    ConfigUtil() {
    }

    static void dump(Configuration c) {
        ConfigUtil.dump(null, c, System.out);
    }

    static void dump(String header, Configuration c) {
        ConfigUtil.dump(header, c, System.out);
    }

    static void dump(String header, Configuration c, PrintStream out) {
        PropertiesConfiguration p = new PropertiesConfiguration();
        p.copy(c);
        if (header != null) {
            out.println(header);
        }
        try {
            p.save((OutputStream)out);
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving config", e);
        }
    }

    static void assertEq(Configuration expected, Configuration actual) {
        String key;
        Iterator it = expected.getKeys();
        while (it.hasNext()) {
            key = (String)it.next();
            Assert.assertTrue((String)("actual should contain " + key), (boolean)actual.containsKey(key));
            Assert.assertEquals((String)("value of " + key), (Object)expected.getProperty(key), (Object)actual.getProperty(key));
        }
        it = actual.getKeys();
        while (it.hasNext()) {
            key = (String)it.next();
            Assert.assertTrue((String)("expected should contain " + key), (boolean)expected.containsKey(key));
        }
    }
}

