/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.util.MetricsCache;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMetricsCache {
    private static final Log LOG = LogFactory.getLog(TestMetricsCache.class);

    @Test
    public void testUpdate() {
        MetricsCache cache = new MetricsCache();
        MetricsRecord mr = this.makeRecord("r", Arrays.asList(this.makeTag("t", "tv")), Arrays.asList(this.makeMetric("m", 0), this.makeMetric("m1", 1)));
        MetricsCache.Record cr = cache.update(mr);
        ((MetricsRecord)Mockito.verify((Object)mr)).name();
        ((MetricsRecord)Mockito.verify((Object)mr)).tags();
        ((MetricsRecord)Mockito.verify((Object)mr)).metrics();
        Assert.assertEquals((String)"same record size", (long)cr.metrics.size(), (long)((Collection)mr.metrics()).size());
        Assert.assertEquals((String)"same metric value", (Object)0, (Object)cr.getMetric("m"));
        Assert.assertNotNull((String)"metric not null", (Object)cr.getMetricInstance("m"));
        Assert.assertEquals((String)"new metric value", (Object)0, (Object)cr.getMetricInstance("m").value());
        MetricsRecord mr2 = this.makeRecord("r", Arrays.asList(this.makeTag("t", "tv")), Arrays.asList(this.makeMetric("m", 2), this.makeMetric("m2", 42)));
        cr = cache.update(mr2);
        Assert.assertEquals((String)"contains 3 metric", (long)3L, (long)cr.metrics.size());
        Assert.assertEquals((String)"updated metric value", (Object)2, (Object)cr.getMetric("m"));
        Assert.assertNotNull((String)"metric not null", (Object)cr.getMetricInstance("m"));
        Assert.assertEquals((String)"new metric value", (Object)2, (Object)cr.getMetricInstance("m").value());
        Assert.assertEquals((String)"old metric value", (Object)1, (Object)cr.getMetric("m1"));
        Assert.assertNotNull((String)"metric not null", (Object)cr.getMetricInstance("m1"));
        Assert.assertEquals((String)"new metric value", (Object)1, (Object)cr.getMetricInstance("m1").value());
        Assert.assertEquals((String)"new metric value", (Object)42, (Object)cr.getMetric("m2"));
        Assert.assertNotNull((String)"metric not null", (Object)cr.getMetricInstance("m2"));
        Assert.assertEquals((String)"new metric value", (Object)42, (Object)cr.getMetricInstance("m2").value());
        MetricsRecord mr3 = this.makeRecord("r", Arrays.asList(this.makeTag("t", "tv3")), Arrays.asList(this.makeMetric("m3", 3)));
        cr = cache.update(mr3);
        Assert.assertEquals((String)"contains 1 metric", (long)1L, (long)cr.metrics.size());
        Assert.assertEquals((String)"updated metric value", (Object)3, (Object)cr.getMetric("m3"));
        Assert.assertNotNull((String)"metric not null", (Object)cr.getMetricInstance("m3"));
        Assert.assertEquals((String)"new metric value", (Object)3, (Object)cr.getMetricInstance("m3").value());
        Assert.assertEquals((String)"no tags", (long)0L, (long)cr.tags.size());
        cr = cache.update(mr3, true);
        Assert.assertEquals((String)"Got 1 tag", (long)1L, (long)cr.tags.size());
        Assert.assertEquals((String)"Tag value", (Object)"tv3", (Object)cr.getTag("t"));
        Assert.assertEquals((String)"Metric value", (Object)3, (Object)cr.getMetric("m3"));
        Assert.assertNotNull((String)"metric not null", (Object)cr.getMetricInstance("m3"));
        Assert.assertEquals((String)"new metric value", (Object)3, (Object)cr.getMetricInstance("m3").value());
    }

    @Test
    public void testGet() {
        MetricsCache cache = new MetricsCache();
        Assert.assertNull((String)"empty", (Object)cache.get("r", Arrays.asList(this.makeTag("t", "t"))));
        MetricsRecord mr = this.makeRecord("r", Arrays.asList(this.makeTag("t", "t")), Arrays.asList(this.makeMetric("m", 1)));
        cache.update(mr);
        MetricsCache.Record cr = cache.get("r", (Collection)mr.tags());
        LOG.debug((Object)("tags=" + (Collection)mr.tags() + " cr=" + cr));
        Assert.assertNotNull((String)"Got record", (Object)cr);
        Assert.assertEquals((String)"contains 1 metric", (long)1L, (long)cr.metrics.size());
        Assert.assertEquals((String)"new metric value", (Object)1, (Object)cr.getMetric("m"));
        Assert.assertNotNull((String)"metric not null", (Object)cr.getMetricInstance("m"));
        Assert.assertEquals((String)"new metric value", (Object)1, (Object)cr.getMetricInstance("m").value());
    }

    private MetricsRecord makeRecord(String name, Collection<MetricsTag> tags, Collection<Metric> metrics) {
        MetricsRecord mr = (MetricsRecord)Mockito.mock(MetricsRecord.class);
        Mockito.when((Object)mr.name()).thenReturn((Object)name);
        Mockito.when((Object)mr.tags()).thenReturn(tags);
        Mockito.when((Object)mr.metrics()).thenReturn(metrics);
        return mr;
    }

    private MetricsTag makeTag(String name, String value) {
        return new MetricsTag(name, "", value);
    }

    private Metric makeMetric(String name, Number value) {
        Metric metric = (Metric)Mockito.mock(Metric.class);
        Mockito.when((Object)metric.name()).thenReturn((Object)name);
        Mockito.when((Object)metric.value()).thenReturn((Object)value);
        return metric;
    }
}

