/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.hadoop.record.BinaryRecordInput;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.CsvRecordInput;
import org.apache.hadoop.record.RecRecord1;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.XmlRecordInput;

public class FromCpp
extends TestCase {
    public FromCpp(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testBinary() {
        try {
            File tmpfile = new File("/temp/hadooptmp.dat");
            RecRecord1 r1 = new RecRecord1();
            r1.setBoolVal(true);
            r1.setByteVal((byte)102);
            r1.setFloatVal(3.145f);
            r1.setDoubleVal(1.5234);
            r1.setIntVal(4567);
            r1.setLongVal(0x5A5A5A5A5A5AL);
            r1.setStringVal("random text");
            r1.setBufferVal(new Buffer());
            r1.setVectorVal(new ArrayList<String>());
            r1.setMapVal(new TreeMap<String, String>());
            FileInputStream istream = new FileInputStream(tmpfile);
            BinaryRecordInput in = new BinaryRecordInput((InputStream)istream);
            RecRecord1 r2 = new RecRecord1();
            r2.deserialize((RecordInput)in, "");
            istream.close();
            FromCpp.assertTrue((boolean)r1.equals((Object)r2));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void testCsv() {
        try {
            File tmpfile = new File("/temp/hadooptmp.txt");
            RecRecord1 r1 = new RecRecord1();
            r1.setBoolVal(true);
            r1.setByteVal((byte)102);
            r1.setFloatVal(3.145f);
            r1.setDoubleVal(1.5234);
            r1.setIntVal(4567);
            r1.setLongVal(0x5A5A5A5A5A5AL);
            r1.setStringVal("random text");
            r1.setBufferVal(new Buffer());
            r1.setVectorVal(new ArrayList<String>());
            r1.setMapVal(new TreeMap<String, String>());
            FileInputStream istream = new FileInputStream(tmpfile);
            CsvRecordInput in = new CsvRecordInput((InputStream)istream);
            RecRecord1 r2 = new RecRecord1();
            r2.deserialize((RecordInput)in, "");
            istream.close();
            FromCpp.assertTrue((boolean)r1.equals((Object)r2));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void testXml() {
        try {
            File tmpfile = new File("/temp/hadooptmp.xml");
            RecRecord1 r1 = new RecRecord1();
            r1.setBoolVal(true);
            r1.setByteVal((byte)102);
            r1.setFloatVal(3.145f);
            r1.setDoubleVal(1.5234);
            r1.setIntVal(4567);
            r1.setLongVal(0x5A5A5A5A5A5AL);
            r1.setStringVal("random text");
            r1.setBufferVal(new Buffer());
            r1.setVectorVal(new ArrayList<String>());
            r1.setMapVal(new TreeMap<String, String>());
            FileInputStream istream = new FileInputStream(tmpfile);
            XmlRecordInput in = new XmlRecordInput((InputStream)istream);
            RecRecord1 r2 = new RecRecord1();
            r2.deserialize((RecordInput)in, "");
            istream.close();
            FromCpp.assertTrue((boolean)r1.equals((Object)r2));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

