/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestHadoopArchives
extends TestCase {
    private static final String inputDir = "input";
    private Path inputPath;
    private MiniDFSCluster dfscluster;
    private MiniMRCluster mapred;
    private FileSystem fs;
    private Path archivePath;

    private static Path createFile(Path dir, String filename, FileSystem fs) throws IOException {
        Path f = new Path(dir, filename);
        FSDataOutputStream out = fs.create(f);
        out.write(filename.getBytes());
        out.close();
        return f;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.dfscluster = new MiniDFSCluster(new Configuration(), 2, true, null);
        this.fs = this.dfscluster.getFileSystem();
        this.mapred = new MiniMRCluster(2, this.fs.getUri().toString(), 1);
        this.inputPath = new Path(this.fs.getHomeDirectory(), inputDir);
        this.archivePath = new Path(this.fs.getHomeDirectory(), "archive");
        this.fs.mkdirs(this.inputPath);
        TestHadoopArchives.createFile(this.inputPath, "a", this.fs);
        TestHadoopArchives.createFile(this.inputPath, "b", this.fs);
        TestHadoopArchives.createFile(this.inputPath, "c", this.fs);
    }

    protected void tearDown() throws Exception {
        try {
            if (this.mapred != null) {
                this.mapred.shutdown();
            }
            if (this.dfscluster != null) {
                this.dfscluster.shutdown();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        super.tearDown();
    }

    public void testPathWithSpaces() throws Exception {
        this.fs.delete(this.archivePath, true);
        TestHadoopArchives.createFile(this.inputPath, "c c", this.fs);
        Path sub1 = new Path(this.inputPath, "sub 1");
        this.fs.mkdirs(sub1);
        TestHadoopArchives.createFile(sub1, "file x y z", this.fs);
        TestHadoopArchives.createFile(sub1, "file", this.fs);
        TestHadoopArchives.createFile(sub1, "x", this.fs);
        TestHadoopArchives.createFile(sub1, "y", this.fs);
        TestHadoopArchives.createFile(sub1, "z", this.fs);
        Path sub2 = new Path(this.inputPath, "sub 1 with suffix");
        this.fs.mkdirs(sub2);
        TestHadoopArchives.createFile(sub2, "z", this.fs);
        JobConf conf = this.mapred.createJobConf();
        FsShell shell = new FsShell((Configuration)conf);
        String inputPathStr = this.inputPath.toUri().getPath();
        List<String> originalPaths = TestHadoopArchives.lsr(shell, inputPathStr);
        URI uri = this.fs.getUri();
        String prefix = "har://hdfs-" + uri.getHost() + ":" + uri.getPort() + this.archivePath.toUri().getPath() + "/";
        String harName = "foo.har";
        String[] args = new String[]{"-archiveName", "foo.har", "-p", inputPathStr, "*", this.archivePath.toString()};
        HadoopArchives har = new HadoopArchives((Configuration)this.mapred.createJobConf());
        TestHadoopArchives.assertEquals((int)0, (int)ToolRunner.run((Tool)har, (String[])args));
        List<String> harPaths = TestHadoopArchives.lsr(shell, prefix + "foo.har");
        TestHadoopArchives.assertEquals(originalPaths, harPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> lsr(FsShell shell, String dir) throws Exception {
        String results;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            TestHadoopArchives.assertEquals((int)0, (int)shell.run(new String[]{"-lsr", dir}));
            results = bytes.toString();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        String dirname = dir.substring(dir.lastIndexOf("/"));
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(results, "\n");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            int i = s.indexOf(dirname);
            if (i < 0) continue;
            paths.add(s.substring(i + dirname.length()));
        }
        Collections.sort(paths);
        return paths;
    }
}

