/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.ConcatenatedInputFilesDemuxer;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.DefaultInputDemuxer;
import org.apache.hadoop.tools.rumen.HadoopLogsAnalyzer;
import org.apache.hadoop.tools.rumen.HistoryEvent;
import org.apache.hadoop.tools.rumen.JobConfigurationParser;
import org.apache.hadoop.tools.rumen.JobHistoryParser;
import org.apache.hadoop.tools.rumen.JobHistoryParserFactory;
import org.apache.hadoop.tools.rumen.JsonObjectMapperParser;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedNetworkTopology;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.PossiblyDecompressedInputStream;
import org.apache.hadoop.tools.rumen.RewindableInputStream;
import org.apache.hadoop.tools.rumen.TaskAttemptFinishedEvent;
import org.apache.hadoop.tools.rumen.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.tools.rumen.TaskStartedEvent;
import org.apache.hadoop.tools.rumen.TopologyBuilder;
import org.apache.hadoop.tools.rumen.TraceBuilder;
import org.apache.hadoop.tools.rumen.TreePath;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestRumenJobTraces {
    @Test
    public void testSmallTrace() throws Exception {
        this.performSingleTest("sample-job-tracker-logs.gz", "job-tracker-logs-topology-output", "job-tracker-logs-trace-output.gz");
    }

    @Test
    public void testTruncatedTask() throws Exception {
        this.performSingleTest("truncated-job-tracker-log", "truncated-topology-output", "truncated-trace-output");
    }

    private void performSingleTest(String jtLogName, String goldTopology, String goldTrace) throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)lfs);
        Path rootInputFile = new Path(rootInputDir, "rumen/small-trace-test");
        Path tempDir = new Path(rootTempDir, "TestRumenJobTraces");
        lfs.delete(tempDir, true);
        Path topologyFile = new Path(tempDir, jtLogName + "-topology.json");
        Path traceFile = new Path(tempDir, jtLogName + "-trace.json");
        Path inputFile = new Path(rootInputFile, jtLogName);
        System.out.println("topology result file = " + topologyFile);
        System.out.println("trace result file = " + traceFile);
        String[] args = new String[]{"-v1", "-write-topology", topologyFile.toString(), "-write-job-trace", traceFile.toString(), inputFile.toString()};
        Path topologyGoldFile = new Path(rootInputFile, goldTopology);
        Path traceGoldFile = new Path(rootInputFile, goldTrace);
        HadoopLogsAnalyzer analyzer = new HadoopLogsAnalyzer();
        int result = ToolRunner.run((Tool)analyzer, (String[])args);
        Assert.assertEquals((String)"Non-zero exit", (long)0L, (long)result);
        TestRumenJobTraces.jsonFileMatchesGold(conf, topologyFile, topologyGoldFile, LoggedNetworkTopology.class, "topology");
        TestRumenJobTraces.jsonFileMatchesGold(conf, traceFile, traceGoldFile, LoggedJob.class, "trace");
    }

    @Test
    public void testRumenViaDispatch() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)lfs);
        Path rootInputPath = new Path(rootInputDir, "rumen/small-trace-test");
        Path tempDir = new Path(rootTempDir, "TestRumenViaDispatch");
        lfs.delete(tempDir, true);
        Path topologyPath = new Path(tempDir, "dispatch-topology.json");
        Path tracePath = new Path(tempDir, "dispatch-trace.json");
        Path inputPath = new Path(rootInputPath, "dispatch-sample-v20-jt-log.gz");
        System.out.println("topology result file = " + topologyPath);
        System.out.println("testRumenViaDispatch() trace result file = " + tracePath);
        String demuxerClassName = ConcatenatedInputFilesDemuxer.class.getName();
        String[] args = new String[]{"-demuxer", demuxerClassName, tracePath.toString(), topologyPath.toString(), inputPath.toString()};
        Path topologyGoldFile = new Path(rootInputPath, "dispatch-topology-output.json.gz");
        Path traceGoldFile = new Path(rootInputPath, "dispatch-trace-output.json.gz");
        TraceBuilder analyzer = new TraceBuilder();
        int result = ToolRunner.run((Tool)analyzer, (String[])args);
        Assert.assertEquals((String)"Non-zero exit", (long)0L, (long)result);
        TestRumenJobTraces.jsonFileMatchesGold(conf, topologyPath, topologyGoldFile, LoggedNetworkTopology.class, "topology");
        TestRumenJobTraces.jsonFileMatchesGold(conf, tracePath, traceGoldFile, LoggedJob.class, "trace");
    }

    @Test
    public void testBracketedCounters() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)lfs);
        Path rootInputPath = new Path(rootInputDir, "rumen/small-trace-test");
        Path tempDir = new Path(rootTempDir, "TestBracketedCounters");
        lfs.delete(tempDir, true);
        Path topologyPath = new Path(tempDir, "dispatch-topology.json");
        Path tracePath = new Path(tempDir, "dispatch-trace.json");
        Path inputPath = new Path(rootInputPath, "counters-format-test-logs");
        System.out.println("topology result file = " + topologyPath);
        System.out.println("testBracketedCounters() trace result file = " + tracePath);
        Path goldPath = new Path(rootInputPath, "counters-test-trace.json.gz");
        String[] args = new String[]{tracePath.toString(), topologyPath.toString(), inputPath.toString()};
        TraceBuilder analyzer = new TraceBuilder();
        int result = ToolRunner.run((Tool)analyzer, (String[])args);
        Assert.assertEquals((String)"Non-zero exit", (long)0L, (long)result);
        TestRumenJobTraces.jsonFileMatchesGold(conf, tracePath, goldPath, LoggedJob.class, "trace");
    }

    @Test
    public void testHadoop20JHParser() throws Exception {
    }

    @Test
    public void testJobHistoryFilenameParsing() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        String user = "test";
        JobID jid = new JobID("12345", 1);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path jhFilename = new Path(jid + "_1234_user_jobname");
        org.apache.hadoop.mapreduce.JobID extractedJID = org.apache.hadoop.mapreduce.JobID.forName((String)TraceBuilder.extractJobID((String)jhFilename.getName()));
        Assert.assertEquals((String)"TraceBuilder failed to parse the current JH filename", (Object)jid, (Object)extractedJID);
        Path jhConfFilename = new Path(jid + "_conf.xml");
        Assert.assertTrue((String)"TraceBuilder failed to parse the current JH conf filename", (boolean)TraceBuilder.isJobConfXml((String)jhConfFilename.getName(), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentJHParser() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)lfs);
        Path tempDir = new Path(rootTempDir, "TestCurrentJHParser");
        lfs.delete(tempDir, true);
        conf.setInt("mapred.tasktracker.map.tasks.maximum", 1);
        conf.setInt("mapred.tasktracker.reduce.tasks.maximum", 1);
        MiniMRCluster mrCluster = new MiniMRCluster(1, "file:///", 1, null, null, new JobConf(conf));
        Path inDir = new Path(tempDir, "input");
        Path outDir = new Path(tempDir, "output");
        JobHistoryParser parser = null;
        RewindableInputStream ris = null;
        ArrayList<String> seenEvents = new ArrayList<String>(10);
        RunningJob rJob = null;
        try {
            HistoryEvent e;
            rJob = UtilsForTests.runJob(mrCluster.createJobConf(), inDir, outDir, 1, 1);
            rJob.waitForCompletion();
            Assert.assertTrue((String)"Job failed", (boolean)rJob.isSuccessful());
            JobID id = rJob.getID();
            Path inputPath = new Path(JobHistory.getHistoryFilePath((JobID)JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id)));
            for (int i = 0; i < 100 && !lfs.exists(inputPath); ++i) {
                ((Object)((Object)TimeUnit.MILLISECONDS)).wait(100L);
            }
            Assert.assertTrue((String)"Missing job history file", (boolean)lfs.exists(inputPath));
            DefaultInputDemuxer inputDemuxer = new DefaultInputDemuxer();
            inputDemuxer.bindTo(inputPath, conf);
            Pair filePair = inputDemuxer.getNext();
            Assert.assertNotNull((Object)filePair);
            ris = new RewindableInputStream((InputStream)filePair.second());
            parser = JobHistoryParserFactory.getParser((RewindableInputStream)ris);
            while ((e = parser.nextEvent()) != null) {
                String eventString = e.getEventType().toString();
                System.out.println(eventString);
                seenEvents.add(eventString);
            }
        }
        finally {
            mrCluster.shutdown();
            if (ris != null) {
                ris.close();
            }
            if (parser != null) {
                parser.close();
            }
            lfs.delete(tempDir, true);
        }
        System.out.println("testCurrentJHParser validating using gold std ");
        String[] goldLines = new String[]{"JOB_SUBMITTED", "JOB_PRIORITY_CHANGED", "JOB_STATUS_CHANGED", "JOB_INITED", "JOB_INFO_CHANGED", "TASK_STARTED", "MAP_ATTEMPT_STARTED", "MAP_ATTEMPT_FINISHED", "MAP_ATTEMPT_FINISHED", "TASK_UPDATED", "TASK_FINISHED", "JOB_STATUS_CHANGED", "TASK_STARTED", "MAP_ATTEMPT_STARTED", "MAP_ATTEMPT_FINISHED", "MAP_ATTEMPT_FINISHED", "TASK_UPDATED", "TASK_FINISHED", "TASK_STARTED", "MAP_ATTEMPT_STARTED", "MAP_ATTEMPT_FINISHED", "REDUCE_ATTEMPT_FINISHED", "TASK_UPDATED", "TASK_FINISHED", "TASK_STARTED", "MAP_ATTEMPT_STARTED", "MAP_ATTEMPT_FINISHED", "MAP_ATTEMPT_FINISHED", "TASK_UPDATED", "TASK_FINISHED", "JOB_STATUS_CHANGED", "JOB_FINISHED"};
        Assert.assertEquals((String)"Size mismatch", (long)goldLines.length, (long)seenEvents.size());
        int index = 0;
        for (String goldLine : goldLines) {
            Assert.assertEquals((String)"Content mismatch", (Object)goldLine, seenEvents.get(index++));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobConfigurationParser() throws Exception {
        String[] list1 = new String[]{"mapred.job.queue.name", "mapreduce.job.name", "mapred.child.java.opts"};
        String[] list2 = new String[]{"mapred.job.queue.name", "mapred.child.java.opts"};
        ArrayList<String> interested1 = new ArrayList<String>();
        for (String interested : list1) {
            interested1.add(interested);
        }
        ArrayList<String> interested2 = new ArrayList<String>();
        for (String interested : list2) {
            interested2.add(interested);
        }
        JobConfigurationParser jcp1 = new JobConfigurationParser(interested1);
        JobConfigurationParser jcp2 = new JobConfigurationParser(interested2);
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootInputPath = new Path(rootInputDir, "rumen/small-trace-test");
        Path inputPath = new Path(rootInputPath, "sample-conf.file.xml");
        PossiblyDecompressedInputStream inputConfStream = new PossiblyDecompressedInputStream(inputPath, conf);
        try {
            Properties props1 = jcp1.parse((InputStream)inputConfStream);
            inputConfStream.close();
            inputConfStream = new PossiblyDecompressedInputStream(inputPath, conf);
            Properties props2 = jcp2.parse((InputStream)inputConfStream);
            Assert.assertEquals((String)"testJobConfigurationParser: wrong number of properties", (long)3L, (long)props1.size());
            Assert.assertEquals((String)"testJobConfigurationParser: wrong number of properties", (long)2L, (long)props2.size());
            Assert.assertEquals((String)"prop test 1", (Object)"TheQueue", (Object)props1.get("mapred.job.queue.name"));
            Assert.assertEquals((String)"prop test 2", (Object)"job_0001", (Object)props1.get("mapreduce.job.name"));
            Assert.assertEquals((String)"prop test 3", (Object)"-server -Xmx640m -Djava.net.preferIPv4Stack=true", (Object)props1.get("mapred.child.java.opts"));
            Assert.assertEquals((String)"prop test 4", (Object)"TheQueue", (Object)props2.get("mapred.job.queue.name"));
            Assert.assertEquals((String)"prop test 5", (Object)"-server -Xmx640m -Djava.net.preferIPv4Stack=true", (Object)props2.get("mapred.child.java.opts"));
        }
        finally {
            inputConfStream.close();
        }
    }

    @Test
    public void testTopologyBuilder() throws Exception {
        TopologyBuilder subject = new TopologyBuilder();
        subject.process(new Properties());
        subject.process((HistoryEvent)new TaskAttemptFinishedEvent(TaskAttemptID.forName((String)"attempt_200904211745_0003_m_000004_0"), TaskType.valueOf((String)"MAP"), "STATUS", 1234567890L, "/194\\.6\\.134\\.64/cluster50261\\.secondleveldomain\\.com", "SUCCESS", null));
        subject.process((HistoryEvent)new TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID.forName((String)"attempt_200904211745_0003_m_000004_1"), TaskType.valueOf((String)"MAP"), "STATUS", 1234567890L, "/194\\.6\\.134\\.80/cluster50262\\.secondleveldomain\\.com", "MACHINE_EXPLODED"));
        subject.process((HistoryEvent)new TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID.forName((String)"attempt_200904211745_0003_m_000004_2"), TaskType.valueOf((String)"MAP"), "STATUS", 1234567890L, "/194\\.6\\.134\\.80/cluster50263\\.secondleveldomain\\.com", "MACHINE_EXPLODED"));
        subject.process((HistoryEvent)new TaskStartedEvent(TaskID.forName((String)"task_200904211745_0003_m_000004"), 1234567890L, TaskType.valueOf((String)"MAP"), "/194\\.6\\.134\\.80/cluster50263\\.secondleveldomain\\.com"));
        LoggedNetworkTopology topology = subject.build();
        List racks = topology.getChildren();
        Assert.assertEquals((String)"Wrong number of racks", (long)2L, (long)racks.size());
        boolean sawSingleton = false;
        boolean sawDoubleton = false;
        for (LoggedNetworkTopology rack : racks) {
            List nodes = rack.getChildren();
            if (rack.getName().endsWith(".64")) {
                Assert.assertEquals((String)"The singleton rack has the wrong number of elements", (long)1L, (long)nodes.size());
                sawSingleton = true;
                continue;
            }
            if (rack.getName().endsWith(".80")) {
                Assert.assertEquals((String)"The doubleton rack has the wrong number of elements", (long)2L, (long)nodes.size());
                sawDoubleton = true;
                continue;
            }
            Assert.assertTrue((String)"Unrecognized rack name", (boolean)false);
        }
        Assert.assertTrue((String)"Did not see singleton rack", (boolean)sawSingleton);
        Assert.assertTrue((String)"Did not see doubleton rack", (boolean)sawDoubleton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static <T extends DeepCompare> void jsonFileMatchesGold(Configuration conf, Path result, Path gold, Class<? extends T> clazz, String fileDescription) throws IOException {
        JsonObjectMapperParser resultParser;
        JsonObjectMapperParser goldParser;
        block7: {
            goldParser = new JsonObjectMapperParser(gold, clazz, conf);
            resultParser = new JsonObjectMapperParser(result, clazz, conf);
            block4: while (true) {
                while (true) {
                    DeepCompare goldJob = (DeepCompare)goldParser.getNext();
                    DeepCompare resultJob = (DeepCompare)resultParser.getNext();
                    if (goldJob == null || resultJob == null) {
                        Assert.assertTrue((goldJob == resultJob ? 1 : 0) != 0);
                        break block4;
                    }
                    try {
                        resultJob.deepCompare(goldJob, new TreePath(null, "<root>"));
                        continue block4;
                    }
                    catch (DeepInequalityException e) {
                        String error = e.path.toString();
                        Assert.assertFalse((String)(fileDescription + " mismatches: " + error), (boolean)true);
                        continue;
                    }
                    break;
                }
            }
            break block7;
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{goldParser, resultParser});
                throw throwable;
            }
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{goldParser, resultParser});
    }
}

