/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.Histogram;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.LoggedDiscreteCDF;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedSingleRelativeRanking;
import org.apache.hadoop.tools.rumen.TaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskInfo;
import org.apache.hadoop.tools.rumen.ZombieCluster;
import org.apache.hadoop.tools.rumen.ZombieJob;
import org.apache.hadoop.tools.rumen.ZombieJobProducer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZombieJob {
    final double epsilon = 0.01;
    private final int[] attemptTimesPercentiles = new int[]{10, 50, 90};
    private long[] succeededCDF = new long[]{5268L, 5268L, 5268L, 5268L, 5268L};
    private long[] failedCDF = new long[]{18592L, 18592L, 18592L, 18592L, 18592L};
    private double[] expectedPs = new double[]{1.0E-6, 0.18707660239708182, 0.0013027618551328818, 2.605523710265763E-4};
    private final long[] mapTaskCounts = new long[]{7838525L, 342277L, 100228L, 1564L, 1234L};
    private final long[] reduceTaskCounts = new long[]{4405338L, 139391L, 1514383L, 139391L, 1234L};
    List<LoggedJob> loggedJobs = new ArrayList<LoggedJob>();
    List<JobStory> jobStories = new ArrayList<JobStory>();

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootInputFile = new Path(rootInputDir, "rumen/zombie");
        ZombieJobProducer parser = new ZombieJobProducer(new Path(rootInputFile, "input-trace.json"), new ZombieCluster(new Path(rootInputFile, "input-topology.json"), null, conf), conf);
        ZombieJob job = null;
        for (int i = 0; i < 4; ++i) {
            ZombieJob zJob = job = parser.getNextJob();
            LoggedJob loggedJob = zJob.getLoggedJob();
            System.out.println(i + ":" + job.getNumberMaps() + "m, " + job.getNumberReduces() + "r");
            System.out.println(loggedJob.getOutcome() + ", " + loggedJob.getJobtype());
            System.out.println("Input Splits -- " + job.getInputSplits().length + ", " + job.getNumberMaps());
            System.out.println("Successful Map CDF -------");
            for (LoggedDiscreteCDF cdf : loggedJob.getSuccessfulMapAttemptCDFs()) {
                System.out.println(cdf.getNumberValues() + ": " + cdf.getMinimum() + "--" + cdf.getMaximum());
                for (LoggedSingleRelativeRanking ranking : cdf.getRankings()) {
                    System.out.println("   " + ranking.getRelativeRanking() + ":" + ranking.getDatum());
                }
            }
            System.out.println("Failed Map CDF -----------");
            for (LoggedDiscreteCDF cdf : loggedJob.getFailedMapAttemptCDFs()) {
                System.out.println(cdf.getNumberValues() + ": " + cdf.getMinimum() + "--" + cdf.getMaximum());
                for (LoggedSingleRelativeRanking ranking : cdf.getRankings()) {
                    System.out.println("   " + ranking.getRelativeRanking() + ":" + ranking.getDatum());
                }
            }
            System.out.println("Successful Reduce CDF ----");
            LoggedDiscreteCDF cdf = loggedJob.getSuccessfulReduceAttemptCDF();
            System.out.println(cdf.getNumberValues() + ": " + cdf.getMinimum() + "--" + cdf.getMaximum());
            for (LoggedSingleRelativeRanking ranking : cdf.getRankings()) {
                System.out.println("   " + ranking.getRelativeRanking() + ":" + ranking.getDatum());
            }
            System.out.println("Failed Reduce CDF --------");
            cdf = loggedJob.getFailedReduceAttemptCDF();
            System.out.println(cdf.getNumberValues() + ": " + cdf.getMinimum() + "--" + cdf.getMaximum());
            for (LoggedSingleRelativeRanking ranking : cdf.getRankings()) {
                System.out.println("   " + ranking.getRelativeRanking() + ":" + ranking.getDatum());
            }
            System.out.print("map attempts to success -- ");
            for (double p : loggedJob.getMapperTriesToSucceed()) {
                System.out.print(p + ", ");
            }
            System.out.println();
            System.out.println("===============");
            this.loggedJobs.add(loggedJob);
            this.jobStories.add((JobStory)job);
        }
    }

    @Test
    public void testFirstJob() {
        JobStory job = this.jobStories.get(0);
        Assert.assertEquals((long)1L, (long)job.getNumberMaps());
        Assert.assertEquals((long)1L, (long)job.getNumberReduces());
        TaskAttemptInfo taInfo = null;
        long expectedRuntime = 2423L;
        taInfo = job.getMapTaskAttemptInfoAdjusted(14, 0, 1);
        Assert.assertEquals((long)expectedRuntime, (long)taInfo.getRuntime());
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
        taInfo = job.getMapTaskAttemptInfoAdjusted(14, 0, 2);
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
        taInfo = job.getMapTaskAttemptInfoAdjusted(14, 0, 0);
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
        expectedRuntime = 97502L;
        taInfo = job.getTaskAttemptInfo(TaskType.REDUCE, 14, 0);
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
        taInfo = job.getTaskAttemptInfo(TaskType.REDUCE, 14, 0);
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
    }

    @Test
    public void testSecondJob() {
        JobStory job = this.jobStories.get(1);
        Assert.assertEquals((long)20L, (long)job.getNumberMaps());
        Assert.assertEquals((long)1L, (long)job.getNumberReduces());
        TaskAttemptInfo taInfo = null;
        taInfo = job.getMapTaskAttemptInfoAdjusted(17, 1, 1);
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
        taInfo = job.getMapTaskAttemptInfoAdjusted(17, 1, 2);
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
        taInfo = job.getMapTaskAttemptInfoAdjusted(17, 1, 0);
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
        taInfo = job.getMapTaskAttemptInfoAdjusted(14, 0, 1);
        Assert.assertEquals((long)1927L, (long)taInfo.getRuntime());
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
    }

    @Test
    public void testFourthJob() {
        JobStory job = this.jobStories.get(3);
        Assert.assertEquals((long)131L, (long)job.getNumberMaps());
        Assert.assertEquals((long)47L, (long)job.getNumberReduces());
        TaskAttemptInfo taInfo = null;
        long runtime = 5268L;
        taInfo = job.getMapTaskAttemptInfoAdjusted(113, 1, 1);
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
        Assert.assertEquals((long)runtime, (long)taInfo.getRuntime());
        taInfo = job.getMapTaskAttemptInfoAdjusted(113, 1, 2);
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
        Assert.assertEquals((long)runtime, (long)(taInfo.getRuntime() / 2L));
        taInfo = job.getMapTaskAttemptInfoAdjusted(113, 1, 0);
        Assert.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)taInfo.getRunState());
        Assert.assertEquals((long)((long)((double)runtime / 1.5)), (long)taInfo.getRuntime());
        taInfo = job.getMapTaskAttemptInfoAdjusted(113, 0, 1);
        Assert.assertEquals((long)18592L, (long)taInfo.getRuntime());
        Assert.assertEquals((Object)TaskStatus.State.FAILED, (Object)taInfo.getRunState());
    }

    @Test
    public void testRecordIOInfo() {
        JobStory job = this.jobStories.get(3);
        TaskInfo mapTask = job.getTaskInfo(TaskType.MAP, 113);
        TaskInfo reduceTask = job.getTaskInfo(TaskType.REDUCE, 0);
        Assert.assertEquals((long)this.mapTaskCounts[0], (long)mapTask.getInputBytes());
        Assert.assertEquals((long)this.mapTaskCounts[1], (long)mapTask.getInputRecords());
        Assert.assertEquals((long)this.mapTaskCounts[2], (long)mapTask.getOutputBytes());
        Assert.assertEquals((long)this.mapTaskCounts[3], (long)mapTask.getOutputRecords());
        Assert.assertEquals((long)this.mapTaskCounts[4], (long)mapTask.getTaskMemory());
        Assert.assertEquals((long)this.reduceTaskCounts[0], (long)reduceTask.getInputBytes());
        Assert.assertEquals((long)this.reduceTaskCounts[1], (long)reduceTask.getInputRecords());
        Assert.assertEquals((long)this.reduceTaskCounts[2], (long)reduceTask.getOutputBytes());
        Assert.assertEquals((long)this.reduceTaskCounts[3], (long)reduceTask.getOutputRecords());
        Assert.assertEquals((long)this.reduceTaskCounts[4], (long)reduceTask.getTaskMemory());
    }

    @Test
    public void testMakeUpInfo() {
        this.checkMakeUpTask(this.jobStories.get(3), 113, 1);
    }

    private void checkMakeUpTask(JobStory job, int taskNumber, int locality) {
        LoggedSingleRelativeRanking ranking2;
        TaskAttemptInfo taInfo = null;
        Histogram sampleSucceeded = new Histogram();
        Histogram sampleFailed = new Histogram();
        ArrayList<Integer> sampleAttempts = new ArrayList<Integer>();
        for (int i = 0; i < 100000; ++i) {
            int attemptId = 0;
            while (true) {
                if ((taInfo = job.getMapTaskAttemptInfoAdjusted(taskNumber, attemptId, 1)).getRunState() == TaskStatus.State.SUCCEEDED) break;
                sampleFailed.enter(taInfo.getRuntime());
                ++attemptId;
            }
            sampleSucceeded.enter(taInfo.getRuntime());
            sampleAttempts.add(attemptId);
        }
        int[] countTries = new int[]{0, 0, 0, 0};
        Iterator i$ = sampleAttempts.iterator();
        while (i$.hasNext()) {
            int attempts = (Integer)i$.next();
            Assert.assertTrue((attempts < 4 ? 1 : 0) != 0);
            int n = attempts;
            countTries[n] = countTries[n] + 1;
        }
        for (int i = 0; i < 4; ++i) {
            int count = countTries[i];
            double p = (double)count / (double)sampleAttempts.size();
            Assert.assertTrue((this.expectedPs[i] - p < 0.01 ? 1 : 0) != 0);
        }
        long[] expectedCDF = this.succeededCDF;
        LoggedDiscreteCDF cdf = new LoggedDiscreteCDF();
        cdf.setCDF(sampleSucceeded, this.attemptTimesPercentiles, 100);
        this.assertRuntimeEqual(cdf.getMinimum(), expectedCDF[0]);
        this.assertRuntimeEqual(cdf.getMaximum(), expectedCDF[4]);
        for (int i = 0; i < 3; ++i) {
            ranking2 = (LoggedSingleRelativeRanking)cdf.getRankings().get(i);
            this.assertRuntimeEqual(expectedCDF[i + 1], ranking2.getDatum());
        }
        expectedCDF = this.failedCDF;
        cdf = new LoggedDiscreteCDF();
        cdf.setCDF(sampleFailed, this.attemptTimesPercentiles, 100);
        System.out.println("generated failed map runtime distribution");
        System.out.println(cdf.getNumberValues() + ": " + cdf.getMinimum() + "--" + cdf.getMaximum());
        for (LoggedSingleRelativeRanking ranking2 : cdf.getRankings()) {
            System.out.println("   " + ranking2.getRelativeRanking() + ":" + ranking2.getDatum());
        }
        this.assertRuntimeEqual(cdf.getMinimum(), expectedCDF[0]);
        this.assertRuntimeEqual(cdf.getMaximum(), expectedCDF[4]);
        for (int i = 0; i < 3; ++i) {
            ranking2 = (LoggedSingleRelativeRanking)cdf.getRankings().get(i);
            this.assertRuntimeEqual(expectedCDF[i + 1], ranking2.getDatum());
        }
    }

    private void assertRuntimeEqual(long expected, long generated) {
        if (expected == 0L) {
            Assert.assertTrue((generated > -1000L && generated < 1000L ? 1 : 0) != 0);
        } else {
            long epsilon = Math.max(expected / 10L, 5000L);
            Assert.assertTrue((expected - generated > -epsilon ? 1 : 0) != 0);
            Assert.assertTrue((expected - generated < epsilon ? 1 : 0) != 0);
        }
    }
}

