/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.helpgui.page;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.helpgui.page.PageEnumeration;
import net.sourceforge.helpgui.page.PageList;
import net.sourceforge.helpgui.page.PageRoot;

public class Page
implements MutableTreeNode {
    private String text = null;
    private String image = null;
    private String target = null;
    protected PageList pages;
    protected PageRoot rootPage = null;
    protected Page parentPage = null;
    protected Object userObject = null;
    protected boolean home = false;

    public Page(String text, String image, String target, boolean home, Page parent) {
        this.text = text;
        this.image = image;
        this.target = target;
        this.parentPage = parent;
        this.pages = new PageList();
        this.home = home;
    }

    public Page(String text, String image, String target, boolean home, PageRoot root) {
        this.text = text;
        this.image = image;
        this.target = target;
        this.rootPage = root;
        this.pages = new PageList();
        this.home = home;
    }

    public boolean equals(Page page) {
        return page.text.equals(this.text) && page.image.equals(this.image) && page.target.equals(this.target);
    }

    public String getText() {
        return this.text;
    }

    public String getImage() {
        return this.image;
    }

    public String getTarget() {
        return this.target;
    }

    public String toString() {
        return this.text;
    }

    public boolean getHome() {
        return this.home;
    }

    public void insert(MutableTreeNode child, int index) {
        if (child.getClass() == Page.class) {
            this.addSubPage((Page)child);
        }
    }

    public void remove(int index) {
        if (0 < index && index < this.pages.size()) {
            this.remove(this.pages.get(index));
        }
    }

    public void remove(MutableTreeNode node) {
    }

    public void removeFromParent() {
        if (null != this.parentPage) {
            this.parentPage.remove(this);
        } else if (null != this.rootPage) {
            this.rootPage.remove(this);
        }
    }

    public void setParent(MutableTreeNode newParent) {
        if (newParent.getClass() == Page.class) {
            this.removeFromParent();
            this.parentPage = (Page)newParent;
            ((Page)newParent).addSubPage(this);
        } else if (newParent.getClass() == PageRoot.class) {
            this.removeFromParent();
            this.rootPage = (PageRoot)newParent;
            ((PageRoot)newParent).add(this);
        }
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public TreeNode getChildAt(int iChildIndex) {
        return this.pages.get(iChildIndex);
    }

    public int getChildCount() {
        return this.pages.size();
    }

    public TreeNode getParent() {
        if (null != this.parentPage) {
            return this.parentPage;
        }
        return this.rootPage;
    }

    public int getIndex(TreeNode node) {
        if (node.getClass() != Page.class) {
            return -1;
        }
        return this.pages.getIndex((Page)node);
    }

    public boolean isLeaf() {
        return this.pages.isEmpty();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public Enumeration children() {
        return new PageEnumeration(this.pages);
    }

    public TreePath getPath() {
        ArrayList<MutableTreeNode> pathList = new ArrayList<MutableTreeNode>();
        pathList.add(this);
        for (MutableTreeNode node = (MutableTreeNode)this.getParent(); node != null; node = (MutableTreeNode)node.getParent()) {
            pathList.add(node);
        }
        Object[] path = new Object[pathList.size()];
        int i = pathList.size() - 1;
        Iterator it = pathList.iterator();
        while (it.hasNext()) {
            path[i] = it.next();
            --i;
        }
        pathList = null;
        return new TreePath(path);
    }

    protected void addSubPage(Page page) {
        if (this.pages.indexOf(page) < 0) {
            this.pages.add(page);
        }
    }
}

