/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class UndoAction
extends AbstractProjectAction {
    public static final String ID = "undo";
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
    private PropertyChangeListener redoActionPropertyListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "Name") {
                UndoAction.this.putValue("Name", evt.getNewValue());
            } else if (name == "enabled") {
                UndoAction.this.updateEnabledState();
            }
        }
    };

    public UndoAction(Application app) {
        super(app);
        this.labels.configureAction(this, ID);
    }

    protected void updateEnabledState() {
        boolean isEnabled = false;
        Action realRedoAction = this.getRealRedoAction();
        if (realRedoAction != null) {
            isEnabled = realRedoAction.isEnabled();
        }
        this.setEnabled(isEnabled);
    }

    protected void updateProject(Project oldValue, Project newValue) {
        super.updateProject(oldValue, newValue);
        if (newValue != null) {
            this.putValue("Name", newValue.getAction(ID).getValue("Name"));
            this.updateEnabledState();
        }
    }

    protected void installProjectListeners(Project p) {
        super.installProjectListeners(p);
        p.getAction(ID).addPropertyChangeListener(this.redoActionPropertyListener);
    }

    protected void uninstallProjectListeners(Project p) {
        super.uninstallProjectListeners(p);
        p.getAction(ID).removePropertyChangeListener(this.redoActionPropertyListener);
    }

    public void actionPerformed(ActionEvent e) {
        Action realRedoAction = this.getRealRedoAction();
        if (realRedoAction != null) {
            realRedoAction.actionPerformed(e);
        }
    }

    private Action getRealRedoAction() {
        return this.getCurrentProject() == null ? null : this.getCurrentProject().getAction(ID);
    }
}

