/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AttributeChangeEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributedCompositeFigure
extends AbstractCompositeFigure {
    private HashMap<AttributeKey, Object> attributes = new HashMap();
    private HashSet<AttributeKey> forbiddenAttributes;

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        if (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(key)) {
            Object oldValue = this.attributes.get(key);
            if (!this.attributes.containsKey(key) || oldValue != newValue || oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                this.willChange();
                this.basicSetAttribute(key, newValue);
                this.fireAttributeChanged(key, oldValue, newValue);
                this.fireUndoableEditHappened(new AttributeChangeEdit(this, key, oldValue, newValue));
                this.changed();
            }
        }
    }

    public void setAttributeEnabled(AttributeKey key, boolean b) {
        if (this.forbiddenAttributes == null) {
            this.forbiddenAttributes = new HashSet();
        }
        if (b) {
            this.forbiddenAttributes.remove(key);
        } else {
            this.forbiddenAttributes.add(key);
        }
    }

    public boolean isAttributeEnabled(AttributeKey key) {
        return this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(key);
    }

    public void setAttributes(HashMap<AttributeKey, Object> map) {
        for (Map.Entry<AttributeKey, Object> entry : map.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>(this.attributes);
    }

    @Override
    public void basicSetAttribute(AttributeKey key, Object newValue) {
        if (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(key)) {
            this.attributes.put(key, newValue);
        }
        this.basicSetAttributeOnChildren(key, newValue);
    }

    protected void basicSetAttributeOnChildren(AttributeKey key, Object newValue) {
        for (Figure child : this.getChildren()) {
            child.basicSetAttribute(key, newValue);
        }
    }

    @Override
    public Object getAttribute(AttributeKey key) {
        return this.hasAttribute(key) ? this.attributes.get(key) : key.getDefaultValue();
    }

    @Override
    public void drawFigure(Graphics2D g) {
        this.drawChildren(g);
        if (AttributeKeys.FILL_COLOR.get(this) != null) {
            g.setColor(AttributeKeys.FILL_COLOR.get(this));
            this.drawFill(g);
        }
        if (AttributeKeys.STROKE_COLOR.get(this) != null && AttributeKeys.STROKE_WIDTH.get(this) > 0.0) {
            g.setStroke(AttributeKeys.getStroke(this));
            g.setColor(AttributeKeys.STROKE_COLOR.get(this));
            this.drawStroke(g);
        }
        if (AttributeKeys.TEXT_COLOR.get(this) != null) {
            if (AttributeKeys.TEXT_SHADOW_COLOR.get(this) != null && AttributeKeys.TEXT_SHADOW_OFFSET.get(this) != null) {
                Dimension2DDouble d = AttributeKeys.TEXT_SHADOW_OFFSET.get(this);
                g.translate(d.width, d.height);
                g.setColor(AttributeKeys.TEXT_SHADOW_COLOR.get(this));
                this.drawText(g);
                g.translate(-d.width, -d.height);
            }
            g.setColor(AttributeKeys.TEXT_COLOR.get(this));
            this.drawText(g);
        }
        if (this.isConnectorsVisible()) {
            this.drawConnectors(g);
        }
    }

    protected void drawChildren(Graphics2D g) {
        for (Figure child : this.getChildren()) {
            child.draw(g);
        }
    }

    @Override
    protected void drawConnectors(Graphics2D g) {
    }

    public Stroke getStroke() {
        return AttributeKeys.getStroke(this);
    }

    public double getStrokeMiterLimitFactor() {
        Number value = (Number)this.getAttribute(AttributeKeys.STROKE_MITER_LIMIT_FACTOR);
        return value != null ? value.doubleValue() : 10.0;
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        double width = AttributeKeys.getStrokeTotalWidth(this) / 2.0;
        if (AttributeKeys.STROKE_JOIN.get(this) == 0) {
            width *= AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this).doubleValue();
        }
        Rectangle2D.Double r = this.getBounds();
        Geom.grow(r, width += 1.0, width);
        return r;
    }

    protected abstract void drawFill(Graphics2D var1);

    protected abstract void drawStroke(Graphics2D var1);

    protected void drawText(Graphics2D g) {
    }

    @Override
    public AbstractAttributedCompositeFigure clone() {
        AbstractAttributedCompositeFigure that = (AbstractAttributedCompositeFigure)super.clone();
        that.attributes = new HashMap<AttributeKey, Object>(this.attributes);
        if (this.forbiddenAttributes != null) {
            that.forbiddenAttributes = new HashSet<AttributeKey>(this.forbiddenAttributes);
        }
        return that;
    }

    protected void writeAttributes(DOMOutput out) throws IOException {
        Figure prototype = (Figure)out.getPrototype();
        boolean isElementOpen = false;
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            Object attributeValue;
            Object prototypeValue;
            AttributeKey key = entry.getKey();
            if (this.forbiddenAttributes != null && this.forbiddenAttributes.contains(key) || (prototypeValue = key.get(prototype)) == (attributeValue = key.get(this)) && (prototypeValue == null || attributeValue == null || prototypeValue.equals(attributeValue))) continue;
            if (!isElementOpen) {
                out.openElement("a");
                isElementOpen = true;
            }
            out.openElement(key.getKey());
            out.writeObject(entry.getValue());
            out.closeElement();
        }
        if (isElementOpen) {
            out.closeElement();
        }
    }

    protected void readAttributes(DOMInput in) throws IOException {
        if (in.getElementCount("a") > 0) {
            in.openElement("a");
            for (int i = in.getElementCount() - 1; i >= 0; --i) {
                in.openElement(i);
                String name = in.getTagName();
                Object value = in.readObject();
                AttributeKey key = this.getAttributeKey(name);
                if (key != null && key.isAssignable(value) && (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(key))) {
                    this.setAttribute(key, value);
                }
                in.closeElement();
            }
            in.closeElement();
        }
    }

    protected AttributeKey getAttributeKey(String name) {
        return AttributeKeys.supportedAttributeMap.get(name);
    }

    protected void applyAttributesTo(Figure that) {
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            that.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        super.write(out);
        this.writeAttributes(out);
    }

    @Override
    public void read(DOMInput in) throws IOException {
        super.read(in);
        this.readAttributes(in);
    }

    @Override
    public void removeAttribute(AttributeKey key) {
        if (this.hasAttribute(key)) {
            Object oldValue = this.getAttribute(key);
            this.attributes.remove(key);
            this.fireAttributeChanged(key, oldValue, key.getDefaultValue());
        }
    }

    @Override
    public boolean hasAttribute(AttributeKey key) {
        return this.attributes.containsKey(key);
    }
}

