/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEvent;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDrawing
extends AbstractBean
implements Drawing {
    private static final Object lock = new JPanel().getTreeLock();
    protected EventListenerList listenerList = new EventListenerList();
    private FontRenderContext fontRenderContext;

    @Override
    public void addDrawingListener(DrawingListener listener) {
        this.listenerList.add(DrawingListener.class, listener);
    }

    @Override
    public void removeDrawingListener(DrawingListener listener) {
        this.listenerList.remove(DrawingListener.class, listener);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener l) {
        this.listenerList.add(UndoableEditListener.class, l);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener l) {
        this.listenerList.remove(UndoableEditListener.class, l);
    }

    @Override
    public void addAll(Collection<Figure> figures) {
        CompositeEdit edit = new CompositeEdit("Figuren hinzuf\u00fcgen");
        this.fireUndoableEditHappened(edit);
        for (Figure f : figures) {
            this.add(f);
        }
        this.fireUndoableEditHappened(edit);
    }

    @Override
    public void clear() {
        this.removeAll(this.getFigures());
    }

    @Override
    public int getFigureCount() {
        return this.getFigures().size();
    }

    @Override
    public void removeAll(Collection<Figure> toBeRemoved) {
        CompositeEdit edit = new CompositeEdit("Figuren entfernen");
        this.fireUndoableEditHappened(edit);
        for (Figure f : new ArrayList<Figure>(toBeRemoved)) {
            this.remove(f);
        }
        this.fireUndoableEditHappened(edit);
    }

    @Override
    public void basicAddAll(Collection<Figure> figures) {
        for (Figure f : figures) {
            this.basicAdd(f);
        }
    }

    @Override
    public void basicRemoveAll(Collection<Figure> toBeOrphaned) {
        for (Figure f : new ArrayList<Figure>(toBeOrphaned)) {
            this.basicRemove(f);
        }
    }

    @Override
    public final void add(final Figure figure) {
        final int index = this.getFigureCount();
        this.basicAdd(index, figure);
        figure.addNotify(this);
        this.fireFigureAdded(figure);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return "Figur einf\u00fcgen";
            }

            public void undo() throws CannotUndoException {
                super.undo();
                AbstractDrawing.this.basicRemove(figure);
                figure.removeNotify(AbstractDrawing.this);
                AbstractDrawing.this.fireFigureRemoved(figure);
            }

            public void redo() throws CannotUndoException {
                super.redo();
                AbstractDrawing.this.basicAdd(index, figure);
                figure.addNotify(AbstractDrawing.this);
                AbstractDrawing.this.fireFigureAdded(figure);
            }
        });
    }

    @Override
    public void basicAdd(Figure figure) {
        this.basicAdd(this.getFigureCount(), figure);
    }

    @Override
    public final void remove(final Figure figure) {
        if (this.contains(figure)) {
            final int index = this.indexOf(figure);
            this.basicRemove(figure);
            figure.removeNotify(this);
            this.fireFigureRemoved(figure);
            this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                public String getPresentationName() {
                    return "Figur entfernen";
                }

                public void redo() throws CannotUndoException {
                    super.redo();
                    AbstractDrawing.this.basicRemove(figure);
                    figure.removeNotify(AbstractDrawing.this);
                    AbstractDrawing.this.fireFigureRemoved(figure);
                }

                public void undo() throws CannotUndoException {
                    super.undo();
                    AbstractDrawing.this.basicAdd(index, figure);
                    figure.addNotify(AbstractDrawing.this);
                    AbstractDrawing.this.fireFigureAdded(figure);
                }
            });
        } else {
            this.fireAreaInvalidated(figure.getDrawBounds());
        }
    }

    protected abstract int indexOf(Figure var1);

    protected void fireAreaInvalidated(Rectangle2D.Double dirtyRegion) {
        DrawingEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DrawingListener.class) continue;
            if (event == null) {
                event = new DrawingEvent(this, null, dirtyRegion);
            }
            ((DrawingListener)listeners[i + 1]).areaInvalidated(event);
        }
    }

    @Override
    public void fireUndoableEditHappened(UndoableEdit edit) {
        UndoableEditEvent event = null;
        if (this.listenerList.getListenerCount() > 0) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (event == null) {
                    event = new UndoableEditEvent(this, edit);
                }
                if (listeners[i] != UndoableEditListener.class) continue;
                ((UndoableEditListener)listeners[i + 1]).undoableEditHappened(event);
            }
        }
    }

    protected void fireFigureAdded(Figure f) {
        DrawingEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DrawingListener.class) continue;
            if (event == null) {
                event = new DrawingEvent(this, f, f.getDrawBounds());
            }
            ((DrawingListener)listeners[i + 1]).figureAdded(event);
        }
    }

    protected void fireFigureRemoved(Figure f) {
        DrawingEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DrawingListener.class) continue;
            if (event == null) {
                event = new DrawingEvent(this, f, f.getDrawBounds());
            }
            ((DrawingListener)listeners[i + 1]).figureRemoved(event);
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public void setFontRenderContext(FontRenderContext frc) {
        this.fontRenderContext = frc;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        in.openElement("figures");
        for (int i = 0; i < in.getElementCount(); ++i) {
            Figure f = (Figure)in.readObject(i);
            this.add(f);
        }
        in.closeElement();
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        out.openElement("figures");
        for (Figure f : this.getFigures()) {
            out.writeObject(f);
        }
        out.closeElement();
    }

    @Override
    public Object getLock() {
        return lock;
    }
}

