/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoxHandleKit;
import org.jhotdraw.draw.ChopBoxConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Options;
import org.jhotdraw.draw.SetBoundsEdit;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Insets2DDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFigure
implements Figure {
    protected EventListenerList listenerList = new EventListenerList();
    private boolean isConnectorsVisible;
    private ConnectionFigure courtingConnection;
    private Drawing drawing;
    private boolean isInteractive;
    private boolean isVisible = true;
    protected Figure decorator;
    private boolean isDrawDecoratorFirst = false;
    protected int changingDepth = 0;

    @Override
    public void addFigureListener(FigureListener l) {
        this.listenerList.add(FigureListener.class, l);
    }

    @Override
    public void removeFigureListener(FigureListener l) {
        this.listenerList.remove(FigureListener.class, l);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener l) {
        this.listenerList.add(UndoableEditListener.class, l);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener l) {
        this.listenerList.remove(UndoableEditListener.class, l);
    }

    @Override
    public void addNotify(Drawing d) {
        this.drawing = d;
        this.fireFigureAdded();
    }

    @Override
    public void removeNotify(Drawing d) {
        this.fireFigureRemoved();
        this.drawing = null;
    }

    protected Drawing getDrawing() {
        return this.drawing;
    }

    protected Object getLock() {
        return this.getDrawing() == null ? this : this.getDrawing().getLock();
    }

    public void setDrawDecoratorFirst(boolean newValue) {
        this.isDrawDecoratorFirst = newValue;
    }

    public boolean isDrawDecoratorFirst() {
        return this.isDrawDecoratorFirst;
    }

    public void fireAreaInvalidated() {
        this.fireAreaInvalidated(this.getDrawBounds());
    }

    protected void fireAreaInvalidated(Rectangle2D.Double invalidatedArea) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, invalidatedArea);
                }
                ((FigureListener)listeners[i + 1]).figureAreaInvalidated(event);
            }
        }
    }

    protected void fireFigureRequestRemove() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)listeners[i + 1]).figureRequestRemove(event);
            }
        }
    }

    protected void fireFigureAdded() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)listeners[i + 1]).figureAdded(event);
            }
        }
    }

    protected void fireFigureRemoved() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)listeners[i + 1]).figureRemoved(event);
            }
        }
    }

    public void fireFigureChanged() {
        this.fireFigureChanged(this.getBounds());
    }

    protected void fireFigureChanged(Rectangle2D.Double changedArea) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, changedArea);
                }
                ((FigureListener)listeners[i + 1]).figureChanged(event);
            }
        }
    }

    protected void fireFigureChanged(FigureEvent event) {
        if (this.listenerList.getListenerCount() > 0) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                ((FigureListener)listeners[i + 1]).figureChanged(event);
            }
        }
    }

    protected void fireAttributeChanged(AttributeKey attribute, Object oldValue, Object newValue) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, attribute, oldValue, newValue);
                }
                ((FigureListener)listeners[i + 1]).figureAttributeChanged(event);
            }
        }
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        UndoableEditEvent event = null;
        if (this.listenerList.getListenerCount() > 0) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (event == null) {
                    event = new UndoableEditEvent(this, edit);
                }
                if (listeners[i] != UndoableEditListener.class) continue;
                ((UndoableEditListener)listeners[i + 1]).undoableEditHappened(event);
            }
        }
    }

    @Override
    public AbstractFigure clone() {
        try {
            AbstractFigure that = (AbstractFigure)super.clone();
            that.listenerList = new EventListenerList();
            that.isConnectorsVisible = false;
            that.courtingConnection = null;
            if (this.decorator != null) {
                that.decorator = (Figure)this.decorator.clone();
            }
            return that;
        }
        catch (CloneNotSupportedException e) {
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public final AbstractFigure basicClone(HashMap<Figure, Figure> oldToNew) {
        return null;
    }

    public void remap(HashMap<Figure, Figure> oldToNew) {
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            BoxHandleKit.addBoxHandles(this, handles);
        }
        return handles;
    }

    @Override
    public Cursor getCursor(Point2D.Double p) {
        if (this.contains(p)) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getDefaultCursor();
    }

    public final void setBounds(Rectangle2D.Double bounds) {
        this.setBounds(new Point2D.Double(bounds.x, bounds.y), new Point2D.Double(bounds.x + bounds.width, bounds.y + bounds.height));
    }

    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        Point2D.Double oldAnchor = this.getStartPoint();
        Point2D.Double oldLead = this.getEndPoint();
        if (!oldAnchor.equals(anchor) || !oldLead.equals(lead)) {
            this.willChange();
            this.basicSetBounds(anchor, lead);
            this.changed();
            this.fireUndoableEditHappened(new SetBoundsEdit(this, oldAnchor, oldLead, anchor, lead));
        }
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public void invalidate() {
        this.fireAreaInvalidated(this.getDrawBounds());
    }

    protected boolean isChanging() {
        return this.changingDepth != 0;
    }

    protected int getChangingDepth() {
        return this.changingDepth;
    }

    @Override
    public void willChange() {
        ++this.changingDepth;
        this.invalidate();
    }

    protected void validate() {
    }

    @Override
    public void changed() {
        if (this.changingDepth <= 1) {
            this.validate();
            this.fireFigureChanged(this.getDrawBounds());
            this.changingDepth = 0;
        } else {
            --this.changingDepth;
        }
    }

    public void transform(AffineTransform tx) {
        this.willChange();
        this.basicTransform(tx);
        this.fireUndoableEditHappened(new TransformEdit(this, tx));
        this.changed();
    }

    @Override
    public abstract void basicTransform(AffineTransform var1);

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return new ChopBoxConnector(this);
    }

    @Override
    public boolean includes(Figure figure) {
        return figure == this;
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        return this.contains(p) ? this : null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStart) {
        return new ChopBoxConnector(this);
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        return Collections.emptyList();
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        return null;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        return false;
    }

    @Override
    public boolean handleDrop(Point2D.Double p, Collection<Figure> droppedFigures, DrawingView view) {
        return false;
    }

    @Override
    public Point2D.Double getEndPoint() {
        Rectangle2D.Double r = this.getBounds();
        return new Point2D.Double(r.x + r.width, r.y + r.height);
    }

    @Override
    public Point2D.Double getStartPoint() {
        Rectangle2D.Double r = this.getBounds();
        return new Point2D.Double(r.x, r.y);
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        Rectangle2D.Double r = this.getBounds();
        return new Dimension2DDouble(r.width, r.height);
    }

    public void remap(Map oldToNew) {
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void setInteractive(boolean b) {
        this.isInteractive = b;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean newValue) {
        if (newValue != this.isVisible) {
            this.willChange();
            this.isVisible = newValue;
            this.changed();
        }
    }

    @Override
    public void setConnectorsVisible(boolean isVisible, ConnectionFigure connection) {
        this.willChange();
        this.isConnectorsVisible = isVisible;
        this.courtingConnection = connection;
        this.changed();
    }

    @Override
    public boolean isConnectorsVisible() {
        return this.isConnectorsVisible;
    }

    protected ConnectionFigure getCourtingConnection() {
        return this.courtingConnection;
    }

    @Override
    public Collection<Figure> getDecomposition() {
        LinkedList<Figure> list = new LinkedList<Figure>();
        list.add(this);
        return list;
    }

    protected FontRenderContext getFontRenderContext() {
        FontRenderContext frc = null;
        if (frc == null) {
            frc = new FontRenderContext(new AffineTransform(), Options.isTextAntialiased(), Options.isFractionalMetrics());
        }
        return frc;
    }

    @Override
    public void requestRemove() {
        this.fireFigureRequestRemove();
    }

    @Override
    public int getLayer() {
        return 0;
    }

    @Override
    public String getTooltip(Point2D.Double p) {
        return null;
    }

    @Override
    public void setDecorator(Figure newValue) {
        this.willChange();
        this.decorator = newValue;
        if (this.decorator != null) {
            this.decorator.basicSetBounds(this.getStartPoint(), this.getEndPoint());
        }
        this.changed();
    }

    @Override
    public Figure getDecorator() {
        return this.decorator;
    }

    @Override
    public final void draw(Graphics2D g) {
        if (this.isDrawDecoratorFirst()) {
            this.drawDecorator(g);
            this.drawFigure(g);
        } else {
            this.drawFigure(g);
            this.drawDecorator(g);
        }
    }

    protected abstract void drawFigure(Graphics2D var1);

    protected void drawDecorator(Graphics2D g) {
        if (this.decorator != null) {
            this.updateDecoratorBounds();
            this.decorator.draw(g);
        }
    }

    protected void updateDecoratorBounds() {
        if (this.decorator != null) {
            Point2D.Double sp = this.getStartPoint();
            Point2D.Double ep = this.getEndPoint();
            Insets2DDouble decoratorInsets = AttributeKeys.DECORATOR_INSETS.get(this);
            sp.x -= decoratorInsets.left;
            sp.y -= decoratorInsets.top;
            ep.x += decoratorInsets.right;
            ep.y += decoratorInsets.bottom;
            this.decorator.basicSetBounds(sp, ep);
        }
    }

    @Override
    public final Rectangle2D.Double getDrawBounds() {
        Rectangle2D.Double figureDrawBounds = this.getFigureDrawBounds();
        if (this.decorator != null) {
            this.updateDecoratorBounds();
            figureDrawBounds.add(this.decorator.getDrawBounds());
        }
        return figureDrawBounds;
    }

    protected abstract Rectangle2D.Double getFigureDrawBounds();

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        buf.append('@');
        buf.append(this.hashCode());
        return buf.toString();
    }
}

