/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.ChopEllipseConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.geom.Geom;

public class EllipseFigure
extends AttributedFigure {
    private Ellipse2D.Double ellipse;

    public EllipseFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public EllipseFigure(double x, double y, double width, double height) {
        this.ellipse = new Ellipse2D.Double(x, y, width, height);
        this.setAttributeEnabled(AttributeKeys.TEXT_COLOR, false);
    }

    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return new ChopEllipseConnector(this);
    }

    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return new ChopEllipseConnector(this);
    }

    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.ellipse.getBounds2D();
    }

    public Rectangle2D.Double getFigureDrawBounds() {
        Rectangle2D.Double r = (Rectangle2D.Double)this.ellipse.getBounds2D();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this);
        Geom.grow(r, grow, grow);
        return r;
    }

    protected void drawFill(Graphics2D g) {
        Ellipse2D.Double r = (Ellipse2D.Double)this.ellipse.clone();
        double grow = AttributeKeys.getPerpendicularFillGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        if (r.width > 0.0 && r.height > 0.0) {
            g.fill(r);
        }
    }

    protected void drawStroke(Graphics2D g) {
        Ellipse2D.Double r = (Ellipse2D.Double)this.ellipse.clone();
        double grow = AttributeKeys.getPerpendicularDrawGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        if (r.width > 0.0 && r.height > 0.0) {
            g.draw(r);
        }
    }

    public boolean contains(Point2D.Double p) {
        Ellipse2D.Double r = (Ellipse2D.Double)this.ellipse.clone();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        return r.contains(p);
    }

    public void basicSetBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.ellipse.x = Math.min(anchor.x, lead.x);
        this.ellipse.y = Math.min(anchor.y, lead.y);
        this.ellipse.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.ellipse.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    public void basicTransform(AffineTransform tx) {
        Point2D.Double anchor = this.getStartPoint();
        Point2D.Double lead = this.getEndPoint();
        this.basicSetBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
    }

    public EllipseFigure clone() {
        EllipseFigure that = (EllipseFigure)super.clone();
        that.ellipse = (Ellipse2D.Double)this.ellipse.clone();
        return that;
    }

    public void restoreTo(Object geometry) {
        Ellipse2D.Double r = (Ellipse2D.Double)geometry;
        this.ellipse.x = r.x;
        this.ellipse.y = r.y;
        this.ellipse.width = r.width;
        this.ellipse.height = r.height;
    }

    public Object getRestoreData() {
        return this.ellipse.clone();
    }
}

