/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.draw.FontSizeLocator;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.TextHolder;
import org.jhotdraw.undo.CompositeEdit;

public class FontSizeHandle
extends LocatorHandle {
    private float oldSize;
    private CompositeEdit edit;

    public FontSizeHandle(TextHolder owner) {
        super(owner, new FontSizeLocator());
    }

    public FontSizeHandle(TextHolder owner, Locator locator) {
        super(owner, locator);
    }

    public void draw(Graphics2D g) {
        this.drawDiamond(g, Color.yellow, Color.black);
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(9);
    }

    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        r.grow(this.getHandlesize() / 2 + 1, this.getHandlesize() / 2 + 1);
        return r;
    }

    public void trackStart(Point anchor, int modifiersEx) {
        this.edit = new CompositeEdit("Schriftgr\u00f6sse");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        TextHolder textOwner = (TextHolder)this.getOwner();
        this.oldSize = textOwner.getFontSize();
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        TextHolder textOwner = (TextHolder)this.getOwner();
        float newSize = (float)Math.max(1.0, (double)this.oldSize + this.view.viewToDrawing((Point)new Point((int)0, (int)(lead.y - anchor.y))).y);
        textOwner.setFontSize(newSize);
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }
}

