/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractLocator;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.geom.Insets2DDouble;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class RelativeLocator
extends AbstractLocator {
    double relativeX;
    double relativeY;

    public RelativeLocator() {
        this.relativeX = 0.0;
        this.relativeY = 0.0;
    }

    public RelativeLocator(double relativeX, double relativeY) {
        this.relativeX = relativeX;
        this.relativeY = relativeY;
    }

    public Point2D.Double locate(Figure owner) {
        Insets2DDouble insets;
        Rectangle2D.Double bounds = owner.getBounds();
        if (owner.getDecorator() != null && (insets = AttributeKeys.DECORATOR_INSETS.get(owner)) != null) {
            bounds.x -= insets.left;
            bounds.y -= insets.top;
            bounds.width += insets.left + insets.right;
            bounds.height += insets.top + insets.bottom;
        }
        return new Point2D.Double(bounds.x + bounds.width * this.relativeX, bounds.y + bounds.height * this.relativeY);
    }

    public static Locator east() {
        return new RelativeLocator(1.0, 0.5);
    }

    public static Locator north() {
        return new RelativeLocator(0.5, 0.0);
    }

    public static Locator west() {
        return new RelativeLocator(0.0, 0.5);
    }

    public static Locator northEast() {
        return new RelativeLocator(1.0, 0.0);
    }

    public static Locator northWest() {
        return new RelativeLocator(0.0, 0.0);
    }

    public static Locator south() {
        return new RelativeLocator(0.5, 1.0);
    }

    public static Locator southEast() {
        return new RelativeLocator(1.0, 1.0);
    }

    public static Locator southWest() {
        return new RelativeLocator(0.0, 1.0);
    }

    public static Locator center() {
        return new RelativeLocator(0.5, 0.5);
    }

    public void write(DOMOutput out) {
        out.addAttribute("relativeX", this.relativeX, 0.5);
        out.addAttribute("relativeY", this.relativeY, 0.5);
    }

    public void read(DOMInput in) {
        this.relativeX = in.getAttribute("relativeX", 0.5);
        this.relativeY = in.getAttribute("relativeY", 0.5);
    }
}

