/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.RestoreDataEdit;
import org.jhotdraw.geom.Geom;

public class RotateHandle
extends AbstractHandle {
    private Point location;
    private Object restoreData;
    private AffineTransform transform;
    private Point2D.Double center;
    private double startTheta;
    private double startLength;

    public RotateHandle(Figure owner) {
        super(owner);
    }

    public boolean isCombinableWith(Handle h) {
        return false;
    }

    public void draw(Graphics2D g) {
        this.drawDiamond(g, Color.green, Color.black);
    }

    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        r.grow(this.getHandlesize() / 2, this.getHandlesize() / 2);
        return r;
    }

    public Point getLocation() {
        if (this.location == null) {
            return this.view.drawingToView(this.getOrigin());
        }
        return this.location;
    }

    private Point2D.Double getOrigin() {
        Rectangle2D.Double bounds = this.getOwner().getBounds();
        return new Point2D.Double(bounds.getCenterX(), bounds.y - (double)this.getHandlesize());
    }

    public void trackStart(Point anchor, int modifiersEx) {
        this.location = new Point(anchor.x, anchor.y);
        this.restoreData = this.getOwner().getRestoreData();
        Rectangle2D.Double bounds = this.getOwner().getBounds();
        this.transform = new AffineTransform();
        this.center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        Point2D.Double anchorPoint = this.view.viewToDrawing(anchor);
        this.startTheta = Geom.angle(this.center.x, this.center.y, anchorPoint.x, anchorPoint.y);
        this.startLength = Geom.length(this.center.x, this.center.y, anchorPoint.x, anchorPoint.y);
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        this.location = new Point(lead.x, lead.y);
        Point2D.Double leadPoint = this.view.viewToDrawing(lead);
        double stepTheta = Geom.angle(this.center.x, this.center.y, leadPoint.x, leadPoint.y);
        double stepLength = Geom.length(this.center.x, this.center.y, leadPoint.x, leadPoint.y);
        this.transform.setToIdentity();
        this.transform.translate(this.center.x, this.center.y);
        this.transform.rotate(stepTheta - this.startTheta);
        this.transform.translate(-this.center.x, -this.center.y);
        this.getOwner().willChange();
        this.getOwner().restoreTo(this.restoreData);
        this.getOwner().basicTransform(this.transform);
        this.getOwner().changed();
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        this.view.getDrawing().fireUndoableEditHappened(new RestoreDataEdit(this.getOwner(), this.restoreData));
        this.location = null;
    }
}

