/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeAction
extends AbstractSelectedAction {
    protected Map<AttributeKey, Object> attributes;

    public AttributeAction(DrawingEditor editor, AttributeKey key, Object value) {
        this(editor, key, value, null, null);
    }

    public AttributeAction(DrawingEditor editor, AttributeKey key, Object value, Icon icon) {
        this(editor, key, value, null, icon);
    }

    public AttributeAction(DrawingEditor editor, AttributeKey key, Object value, String name) {
        this(editor, key, value, name, null);
    }

    public AttributeAction(DrawingEditor editor, AttributeKey key, Object value, String name, Icon icon) {
        this(editor, key, value, name, icon, null);
    }

    public AttributeAction(DrawingEditor editor, AttributeKey key, Object value, String name, Icon icon, Action compatibleTextAction) {
        super(editor);
        this.attributes = new HashMap<AttributeKey, Object>();
        this.attributes.put(key, value);
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    public AttributeAction(DrawingEditor editor, Map<AttributeKey, Object> attributes, String name, Icon icon) {
        super(editor);
        this.attributes = attributes;
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.getView() != null && this.getView().getSelectionCount() > 0) {
            CompositeEdit edit = new CompositeEdit(this.labels.getString("drawAttributeChange"));
            this.fireUndoableEditHappened(edit);
            this.changeAttributes();
            this.fireUndoableEditHappened(edit);
        }
    }

    public void changeAttributes() {
        Drawing drawing = this.getDrawing();
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            AttributeKey key = entry.getKey();
            Object value = entry.getValue();
            for (Figure figure : this.getView().getSelectedFigures()) {
                figure.setAttribute(key, value);
            }
            this.getEditor().setDefaultAttribute(key, value);
        }
    }
}

