/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;

public class AttributeToggler
implements ActionListener {
    private DrawingEditor editor;
    private AttributeKey key;
    private Object value1;
    private Object value2;
    private Action compatibleTextAction;

    public AttributeToggler(DrawingEditor editor, AttributeKey key, Object value1, Object value2) {
        this(editor, key, value1, value2, null);
    }

    public AttributeToggler(DrawingEditor editor, AttributeKey key, Object value1, Object value2, Action compatibleTextAction) {
        this.editor = editor;
        this.key = key;
        this.value1 = value1;
        this.value2 = value2;
        this.compatibleTextAction = compatibleTextAction;
    }

    public DrawingView getView() {
        return this.editor.getView();
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void actionPerformed(ActionEvent evt) {
        Figure f;
        Component focusOwner;
        if (this.compatibleTextAction != null && (focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) != null && focusOwner instanceof JTextComponent) {
            this.compatibleTextAction.actionPerformed(evt);
            return;
        }
        Iterator<Figure> i = this.getView().getSelectedFigures().iterator();
        Object newValue = null;
        if (i.hasNext()) {
            f = i.next();
            Object attr = f.getAttribute(this.key);
            newValue = this.value1 == null && attr == null || this.value1 != null && attr != null && attr.equals(this.value1) ? this.value2 : this.value1;
            this.getEditor().setDefaultAttribute(this.key, newValue);
            f.setAttribute(this.key, newValue);
        }
        while (i.hasNext()) {
            f = i.next();
            f.setAttribute(this.key, newValue);
        }
    }
}

