/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jhotdraw.geom.Geom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierPath
extends ArrayList<Node>
implements Shape {
    public static final int C1_MASK = 1;
    public static final int C2_MASK = 2;
    public static final int C1C2_MASK = 3;
    private transient GeneralPath generalPath;
    private int outer = -1;
    private boolean isClosed;

    public void add(Point2D.Double c0) {
        this.add(new Node(0, c0, c0, c0));
    }

    public void addPoint(double x, double y) {
        this.add(new Node(0, x, y, x, y, x, y));
    }

    public void add(int mask, Point2D.Double c0, Point2D.Double c1, Point2D.Double c2) {
        this.add(new Node(mask, c0, c1, c2));
    }

    public void set(int index, int coord, Point2D.Double p) {
        Node c = (Node)this.get(index);
        c.x[coord] = p.x;
        c.y[coord] = p.y;
    }

    public Point2D.Double get(int index, int coord) {
        Node c = (Node)this.get(index);
        return new Point2D.Double(c.x[coord], c.y[coord]);
    }

    public void invalidatePath() {
        this.generalPath = null;
        this.outer = -1;
    }

    public void validatePath() {
        if (this.generalPath == null) {
            this.generalPath = this.toGeneralPath();
        }
    }

    public GeneralPath toGeneralPath() {
        GeneralPath gp = new GeneralPath();
        gp.setWindingRule(0);
        if (this.size() == 0) {
            gp.moveTo(0.0f, 0.0f);
            gp.lineTo(0.0f, 1.0f);
        } else if (this.size() == 1) {
            Node current = (Node)this.get(0);
            gp.moveTo((float)current.x[0], (float)current.y[0]);
            gp.lineTo((float)current.x[0], (float)current.y[0] + 1.0f);
        } else {
            Node current;
            Node previous = current = (Node)this.get(0);
            gp.moveTo((float)current.x[0], (float)current.y[0]);
            int n = this.size();
            for (int i = 1; i < n; ++i) {
                previous = current;
                current = (Node)this.get(i);
                if ((previous.mask & 2) == 0) {
                    if ((current.mask & 1) == 0) {
                        gp.lineTo((float)current.x[0], (float)current.y[0]);
                        continue;
                    }
                    gp.quadTo((float)current.x[1], (float)current.y[1], (float)current.x[0], (float)current.y[0]);
                    continue;
                }
                if ((current.mask & 1) == 0) {
                    gp.quadTo((float)previous.x[2], (float)previous.y[2], (float)current.x[0], (float)current.y[0]);
                    continue;
                }
                gp.curveTo((float)previous.x[2], (float)previous.y[2], (float)current.x[1], (float)current.y[1], (float)current.x[0], (float)current.y[0]);
            }
            if (this.isClosed) {
                if (this.size() > 1) {
                    previous = (Node)this.get(this.size() - 1);
                    current = (Node)this.get(0);
                    if ((previous.mask & 2) == 0) {
                        if ((current.mask & 1) == 0) {
                            gp.lineTo((float)current.x[0], (float)current.y[0]);
                        } else {
                            gp.quadTo((float)current.x[1], (float)current.y[1], (float)current.x[0], (float)current.y[0]);
                        }
                    } else if ((current.mask & 1) == 0) {
                        gp.quadTo((float)previous.x[2], (float)previous.y[2], (float)current.x[0], (float)current.y[0]);
                    } else {
                        gp.curveTo((float)previous.x[2], (float)previous.y[2], (float)current.x[1], (float)current.y[1], (float)current.x[0], (float)current.y[0]);
                    }
                }
                gp.closePath();
            }
        }
        return gp;
    }

    @Override
    public boolean contains(Point2D p) {
        this.validatePath();
        return this.generalPath.contains(p);
    }

    public boolean outlineContains(Point2D.Double p, double tolerance) {
        this.validatePath();
        PathIterator i = this.generalPath.getPathIterator(new AffineTransform(), tolerance);
        double[] coords = new double[6];
        int type = i.currentSegment(coords);
        double prevX = coords[0];
        double prevY = coords[1];
        i.next();
        while (!i.isDone()) {
            i.currentSegment(coords);
            if (Geom.lineContainsPoint(prevX, prevY, coords[0], coords[1], p.x, p.y, tolerance)) {
                return true;
            }
            prevX = coords[0];
            prevY = coords[1];
            i.next();
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        this.validatePath();
        return this.generalPath.intersects(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        this.validatePath();
        return this.generalPath.getPathIterator(at);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        this.validatePath();
        return this.generalPath.contains(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        this.validatePath();
        return this.generalPath.getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        this.validatePath();
        return this.generalPath.intersects(x, y, w, h);
    }

    @Override
    public Rectangle2D getBounds2D() {
        this.validatePath();
        return this.generalPath.getBounds2D();
    }

    public Rectangle2D.Double getBounds2DDouble() {
        this.validatePath();
        Rectangle2D r = this.generalPath.getBounds2D();
        if (r instanceof Rectangle2D.Double) {
            return (Rectangle2D.Double)r;
        }
        return new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        this.validatePath();
        return this.generalPath.getBounds();
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        this.validatePath();
        return this.generalPath.contains(x, y, w, h);
    }

    @Override
    public boolean contains(double x, double y) {
        this.validatePath();
        return this.generalPath.contains(x, y);
    }

    public void setClosed(boolean newValue) {
        if (this.isClosed != newValue) {
            this.isClosed = newValue;
            this.invalidatePath();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Object clone() {
        BezierPath that = (BezierPath)super.clone();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            that.set(i, (Node)((Node)this.get(i)).clone());
        }
        return that;
    }

    public void transform(AffineTransform tx) {
        Point2D.Double p = new Point2D.Double();
        for (Node cp : this) {
            for (int i = 0; i < 3; ++i) {
                p.x = cp.x[i];
                p.y = cp.y[i];
                tx.transform(p, p);
                cp.x[i] = p.x;
                cp.y[i] = p.y;
            }
        }
        this.invalidatePath();
    }

    public void setTo(BezierPath that) {
        while (that.size() < this.size()) {
            this.remove(this.size() - 1);
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((Node)this.get(i)).setTo((Node)that.get(i));
        }
        while (this.size() < that.size()) {
            this.add((Node)((Node)that.get(this.size())).clone());
        }
    }

    public Point2D.Double getCenter() {
        double sx = 0.0;
        double sy = 0.0;
        for (Node p : this) {
            sx += p.x[0];
            sy += p.y[0];
        }
        int n = this.size();
        return new Point2D.Double(sx / (double)n, sy / (double)n);
    }

    public Point2D.Double chop(Point2D.Double p) {
        this.validatePath();
        return Geom.chop(this.generalPath, p);
    }

    public int indexOfOutermostNode() {
        if (this.outer == -1) {
            Point2D.Double ctr = this.getCenter();
            this.outer = 0;
            double dist = 0.0;
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                Node cp = (Node)this.get(i);
                double d = Geom.length2(ctr.x, ctr.y, cp.x[0], cp.y[0]);
                if (!(d > dist)) continue;
                dist = d;
                this.outer = i;
            }
        }
        return this.outer;
    }

    public Point2D.Double getPointOnPath(double relative, double flatness) {
        if (this.size() == 0) {
            return null;
        }
        if (this.size() == 1) {
            return ((Node)this.get(0)).getControlPoint(0);
        }
        if (relative <= 0.0) {
            return ((Node)this.get(0)).getControlPoint(0);
        }
        if (relative >= 1.0) {
            return ((Node)this.get(this.size() - 1)).getControlPoint(0);
        }
        this.validatePath();
        double len = 0.0;
        PathIterator i = this.generalPath.getPathIterator(new AffineTransform(), flatness);
        double[] coords = new double[6];
        int type = i.currentSegment(coords);
        double prevX = coords[0];
        double prevY = coords[1];
        i.next();
        while (!i.isDone()) {
            i.currentSegment(coords);
            len += Geom.length(prevX, prevY, coords[0], coords[1]);
            prevX = coords[0];
            prevY = coords[1];
            i.next();
        }
        double relativeLen = len * relative;
        double pos = 0.0;
        i = this.generalPath.getPathIterator(new AffineTransform(), flatness);
        type = i.currentSegment(coords);
        prevX = coords[0];
        prevY = coords[1];
        i.next();
        while (!i.isDone()) {
            i.currentSegment(coords);
            double segLen = Geom.length(prevX, prevY, coords[0], coords[1]);
            if (pos + segLen >= relativeLen) {
                double factor = (relativeLen - pos) / segLen;
                return new Point2D.Double(prevX * (1.0 - factor) + coords[0] * factor, prevY * (1.0 - factor) + coords[1] * factor);
            }
            pos += segLen;
            prevX = coords[0];
            prevY = coords[1];
            i.next();
        }
        throw new InternalError("We should never get here");
    }

    public int findSegment(Point2D.Double find, float tolerance) {
        Node v2;
        Node v1;
        BezierPath tempPath = new BezierPath();
        Node t1 = new Node();
        tempPath.add(t1);
        Node t2 = new Node();
        tempPath.add(t2);
        int n = this.size() - 1;
        for (int i = 0; i < n; ++i) {
            v1 = (Node)this.get(i);
            v2 = (Node)this.get(i + 1);
            if (v1.mask == 0 && v2.mask == 0) {
                if (!Geom.lineContainsPoint(v1.x[0], v1.y[0], v2.x[0], v2.y[0], find.x, find.y, (double)tolerance)) continue;
                return i;
            }
            t1.setTo(v1);
            t2.setTo(v2);
            tempPath.invalidatePath();
            if (!tempPath.outlineContains(find, tolerance)) continue;
            return i;
        }
        if (this.isClosed && this.size() > 1) {
            v1 = (Node)this.get(this.size() - 1);
            v2 = (Node)this.get(0);
            if (v1.mask == 0 && v2.mask == 0) {
                if (Geom.lineContainsPoint(v1.x[0], v1.y[0], v2.x[0], v2.y[0], find.x, find.y, (double)tolerance)) {
                    return this.size() - 1;
                }
            } else {
                t1.setTo(v1);
                t2.setTo(v2);
                tempPath.invalidatePath();
                if (tempPath.outlineContains(find, tolerance)) {
                    return this.size() - 1;
                }
            }
        }
        return -1;
    }

    public int joinSegments(Point2D.Double join, float tolerance) {
        for (int i = 0; i < this.size(); ++i) {
            Node p = (Node)this.get(i);
            if (!(Geom.length(p.x[0], p.y[0], join.x, join.y) < (double)tolerance)) continue;
            this.remove(i);
            return i;
        }
        return -1;
    }

    public int splitSegment(Point2D.Double split, float tolerance) {
        int i = this.findSegment(split, tolerance);
        int nextI = (i + 1) % this.size();
        if (i != -1) {
            if ((((Node)this.get((int)i)).mask & 2) == 2 && (((Node)this.get((int)nextI)).mask & 1) == 0) {
                this.add(i + 1, new Node(2, split, split, split));
            } else if ((((Node)this.get((int)i)).mask & 2) == 0 && (((Node)this.get((int)nextI)).mask & 1) == 1) {
                this.add(i + 1, new Node(2, split, split, split));
            } else if ((((Node)this.get((int)i)).mask & 2) == 2 && (((Node)this.get((int)nextI)).mask & 1) == 2) {
                this.add(i + 1, new Node(3, split, split, split));
            } else {
                this.add(i + 1, new Node(split));
            }
        }
        return i + 1;
    }

    public void moveTo(double x1, double y1) {
        if (this.size() != 0) {
            throw new IllegalPathStateException("moveTo only allowed when empty");
        }
        this.add(new Node(x1, y1));
    }

    public void lineTo(double x1, double y1) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("lineTo only allowed when not empty");
        }
        this.add(new Node(x1, y1));
    }

    public void quadTo(double x1, double y1, double x2, double y2) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("quadTo only allowed when not empty");
        }
        this.add(new Node(1, x2, y2, x1, y1, x2, y2));
    }

    public void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("curveTo only allowed when not empty");
        }
        Node lastPoint = (Node)this.get(this.size() - 1);
        lastPoint.mask |= 2;
        lastPoint.x[2] = x1;
        lastPoint.y[2] = y1;
        this.add(new Node(1, x3, y3, x2, y2, x3, y3));
    }

    public Point2D.Double[] toPolygonArray() {
        Point2D.Double[] points = new Point2D.Double[this.size()];
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            points[i] = new Point2D.Double(((Node)this.get((int)i)).x[0], ((Node)this.get((int)i)).y[0]);
        }
        return points;
    }

    public static class Node
    implements Cloneable {
        public int mask = 0;
        public double[] x = new double[3];
        public double[] y = new double[3];
        public boolean keepColinear = true;

        public Node() {
            this.mask = 1;
        }

        public Node(Node that) {
            this.setTo(that);
        }

        public void setTo(Node that) {
            this.mask = that.mask;
            this.keepColinear = that.keepColinear;
            System.arraycopy(that.x, 0, this.x, 0, 3);
            System.arraycopy(that.y, 0, this.y, 0, 3);
        }

        public Node(Point2D.Double c0) {
            this.mask = 0;
            this.x[0] = c0.x;
            this.y[0] = c0.y;
            this.x[1] = c0.x;
            this.y[1] = c0.y;
            this.x[2] = c0.x;
            this.y[2] = c0.y;
        }

        public Node(int mask, Point2D.Double c0, Point2D.Double c1, Point2D.Double c2) {
            this.mask = mask;
            this.x[0] = c0.x;
            this.y[0] = c0.y;
            this.x[1] = c1.x;
            this.y[1] = c1.y;
            this.x[2] = c2.x;
            this.y[2] = c2.y;
        }

        public Node(double x0, double y0) {
            this.mask = 0;
            this.x[0] = x0;
            this.y[0] = y0;
            this.x[1] = x0;
            this.y[1] = y0;
            this.x[2] = x0;
            this.y[2] = y0;
        }

        public Node(int mask, double x0, double y0, double x1, double y1, double x2, double y2) {
            this.mask = mask;
            this.x[0] = x0;
            this.y[0] = y0;
            this.x[1] = x1;
            this.y[1] = y1;
            this.x[2] = x2;
            this.y[2] = y2;
        }

        public int getMask() {
            return this.mask;
        }

        public void setMask(int newValue) {
            this.mask = newValue;
        }

        public void setControlPoint(int index, Point2D.Double p) {
            this.x[index] = p.x;
            this.y[index] = p.y;
        }

        public Point2D.Double getControlPoint(int index) {
            return new Point2D.Double(this.x[index], this.y[index]);
        }

        public void moveTo(Point2D.Double p) {
            this.moveBy(p.x - this.x[0], p.y - this.y[0]);
        }

        public void moveTo(double x, double y) {
            this.moveBy(x - this.x[0], y - this.y[0]);
        }

        public void moveBy(double dx, double dy) {
            int i = 0;
            while (i < 3) {
                int n = i;
                this.x[n] = this.x[n] + dx;
                int n2 = i++;
                this.y[n2] = this.y[n2] + dy;
            }
        }

        public Object clone() {
            try {
                Node that = (Node)super.clone();
                that.x = (double[])this.x.clone();
                that.y = (double[])this.y.clone();
                return that;
            }
            catch (CloneNotSupportedException e) {
                InternalError error = new InternalError();
                error.initCause(e);
                throw error;
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append('[');
            for (int i = 0; i < 3; ++i) {
                if (i != 0) {
                    if ((this.mask & i) != i) continue;
                    buf.append(',');
                }
                buf.append('x');
                buf.append(i);
                buf.append('=');
                buf.append(this.x[i]);
                buf.append(",y");
                buf.append(i);
                buf.append('=');
                buf.append(this.y[i]);
            }
            buf.append(']');
            return buf.toString();
        }
    }
}

