/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.io.Serializable;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class Insets2DDouble
implements Cloneable,
Serializable,
DOMStorable {
    public double top;
    public double left;
    public double bottom;
    public double right;

    public Insets2DDouble() {
    }

    public Insets2DDouble(double top, double left, double bottom, double right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Insets2DDouble) {
            Insets2DDouble insets = (Insets2DDouble)obj;
            return this.top == insets.top && this.left == insets.left && this.bottom == insets.bottom && this.right == insets.right;
        }
        return false;
    }

    public int hashCode() {
        double sum1 = this.left + this.bottom;
        double sum2 = this.right + this.top;
        double val1 = sum1 * (sum1 + 1.0) / 2.0 + this.left;
        double val2 = sum2 * (sum2 + 1.0) / 2.0 + this.top;
        double sum3 = val1 + val2;
        return Float.floatToIntBits((float)(sum3 * (sum3 + 1.0) / 2.0 + val2));
    }

    public String toString() {
        return this.getClass().getName() + "[top=" + this.top + ",left=" + this.left + ",bottom=" + this.bottom + ",right=" + this.right + "]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private static native void initIDs();

    public void write(DOMOutput out) {
        out.addAttribute("top", this.top, 0.0);
        out.addAttribute("left", this.left, 0.0);
        out.addAttribute("bottom", this.bottom, 0.0);
        out.addAttribute("right", this.right, 0.0);
    }

    public void read(DOMInput in) {
        this.top = in.getAttribute("top", 0.0);
        this.left = in.getAttribute("left", 0.0);
        this.bottom = in.getAttribute("bottom", 0.0);
        this.right = in.getAttribute("right", 0.0);
    }
}

