/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierTool;
import org.jhotdraw.samples.svg.figures.SVGPath;

public class PathTool
extends BezierTool {
    private SVGPath pathPrototype;

    public PathTool(SVGPath pathPrototype, BezierFigure bezierPrototype) {
        this(pathPrototype, bezierPrototype, null);
    }

    public PathTool(SVGPath pathPrototype, BezierFigure bezierPrototype, Map attributes) {
        super(bezierPrototype, attributes);
        this.pathPrototype = pathPrototype;
    }

    protected SVGPath createPath() {
        SVGPath f = (SVGPath)this.pathPrototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                f.setAttribute((AttributeKey)entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    protected void finishCreation(BezierFigure createdFigure) {
        this.getDrawing().remove(createdFigure);
        SVGPath createdPath = this.createPath();
        createdPath.removeAllChildren();
        createdPath.add(createdFigure);
        this.getDrawing().add(createdPath);
        this.getView().addToSelection(createdPath);
    }
}

