/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.io.IOException;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.figures.SVGGroup;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGDrawing
extends DefaultDrawing {
    private String title;
    private String description;

    public void setTitle(String newValue) {
        String oldValue = this.title;
        this.title = newValue;
        this.firePropertyChange("title", oldValue, newValue);
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String newValue) {
        String oldValue = this.description;
        this.description = newValue;
        this.firePropertyChange("description", oldValue, newValue);
    }

    public String getDescription() {
        return this.description;
    }

    public void read(DOMInput in) throws IOException {
        int n = in.getElementCount();
        for (int i = 0; i < n; ++i) {
            in.openElement(i);
            String name = in.getTagName();
            if (name.equals("title")) {
                this.title = in.getText();
                in.closeElement();
                continue;
            }
            if (name.equals("desc")) {
                this.description = in.getText();
                in.closeElement();
                continue;
            }
            if (name.equals("defs")) {
                in.closeElement();
                continue;
            }
            if (name.equals("use")) {
                in.closeElement();
                continue;
            }
            if (name.equals("script")) {
                in.closeElement();
                continue;
            }
            if (name.equals("style")) {
                in.closeElement();
                continue;
            }
            if (name.equals("radialGradient")) {
                in.closeElement();
                continue;
            }
            in.closeElement();
            Object f = in.readObject(i);
            if (f instanceof SVGDrawing) {
                SVGGroup g = new SVGGroup();
                g.willChange();
                for (Figure child : ((SVGDrawing)f).getFigures()) {
                    g.basicAdd(child);
                }
                g.changed();
                if (g.isEmpty()) continue;
                this.add(g);
                continue;
            }
            if (f instanceof SVGFigure) {
                if (((SVGFigure)f).isEmpty()) continue;
                this.add((Figure)f);
                continue;
            }
            throw new IOException("Unexpected child " + f);
        }
        this.readAttributes(in);
    }

    protected void readAttributes(DOMInput in) throws IOException {
    }

    public void write(DOMOutput out) throws IOException {
        out.addAttribute("xmlns", "http://www.w3.org/2000/svg");
        out.addAttribute("version", "1.2");
        out.addAttribute("baseProfile", "tiny");
        for (Figure f : this.getFigures()) {
            out.writeObject(f);
        }
    }
}

