/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.samples.svg.figures.SVGText;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGUtil {
    private static final Color INHERIT_COLOR = new Color(0xFFFF00);
    private static final Color CURRENT_COLOR = new Color(0xFFFF00);
    public static final Map<String, Color> SVG_COLORS;
    private static final HashSet pathCommands;

    private SVGUtil() {
    }

    public static AffineTransform getTransform(DOMInput in, String attributeName) throws IOException {
        return SVGUtil.getTransform(in.getAttribute(attributeName, ""));
    }

    public static AffineTransform getTransform(String str) throws IOException {
        AffineTransform t = new AffineTransform();
        if (str != null) {
            StreamTokenizer tt = new StreamTokenizer(new StringReader(str));
            tt.resetSyntax();
            tt.wordChars(97, 122);
            tt.wordChars(65, 90);
            tt.wordChars(160, 255);
            tt.whitespaceChars(0, 32);
            tt.whitespaceChars(44, 44);
            tt.parseNumbers();
            while (tt.nextToken() != -1) {
                if (tt.ttype != -3) {
                    throw new IOException("Illegal transform " + str);
                }
                String type = tt.sval;
                if (tt.nextToken() != 40) {
                    throw new IOException("'(' not found in transform " + str);
                }
                if (type.equals("matrix")) {
                    double[] m = new double[6];
                    for (int i = 0; i < 6; ++i) {
                        if (tt.nextToken() != -2) {
                            throw new IOException("Matrix value " + i + " not found in transform " + str + " token:" + tt.ttype + " " + tt.sval);
                        }
                        if (tt.nextToken() == -3 && tt.sval.startsWith("E")) {
                            double mantissa = tt.nval;
                            tt.nval = Double.valueOf(tt.nval + tt.sval);
                        } else {
                            tt.pushBack();
                        }
                        m[i] = tt.nval;
                    }
                    t.concatenate(new AffineTransform(m));
                } else if (type.equals("translate")) {
                    double ty;
                    if (tt.nextToken() != -2) {
                        throw new IOException("X-translation value not found in transform " + str);
                    }
                    double tx = tt.nval;
                    if (tt.nextToken() == -2) {
                        ty = tt.nval;
                    } else {
                        tt.pushBack();
                        ty = 0.0;
                    }
                    t.translate(tx, ty);
                } else if (type.equals("scale")) {
                    double sy;
                    if (tt.nextToken() != -2) {
                        throw new IOException("X-scale value not found in transform " + str);
                    }
                    double sx = tt.nval;
                    if (tt.nextToken() == -2) {
                        sy = tt.nval;
                    } else {
                        tt.pushBack();
                        sy = sx;
                    }
                    t.scale(sx, sy);
                } else if (type.equals("rotate")) {
                    double cy;
                    double cx;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Angle value not found in transform " + str);
                    }
                    double angle = tt.nval;
                    if (tt.nextToken() == -2) {
                        cx = tt.nval;
                        if (tt.nextToken() != -2) {
                            throw new IOException("Y-center value not found in transform " + str);
                        }
                        cy = tt.nval;
                    } else {
                        tt.pushBack();
                        cy = 0.0;
                        cx = 0.0;
                    }
                    t.rotate(angle * Math.PI / 180.0, cx * Math.PI / 180.0, cy * Math.PI / 180.0);
                } else if (type.equals("skewX")) {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + str);
                    }
                    double angle = tt.nval;
                    t.concatenate(new AffineTransform(1.0, 0.0, Math.tan(angle * Math.PI / 180.0), 1.0, 0.0, 0.0));
                } else if (type.equals("skewY")) {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + str);
                    }
                    double angle = tt.nval;
                    t.concatenate(new AffineTransform(1.0, Math.tan(angle * Math.PI / 180.0), 0.0, 1.0, 0.0, 0.0));
                } else {
                    throw new IOException("Unknown transform " + type + " in " + str);
                }
                if (tt.nextToken() == 41) continue;
                throw new IOException("')' not found in transform " + str);
            }
        }
        return t;
    }

    public static double getDimension(DOMInput in, String attributeName) throws IOException {
        return SVGUtil.getDimensionValue(in, in.getAttribute(attributeName, "0"));
    }

    public static double getDimensionValue(DOMInput in, String str) throws IOException {
        double scaleFactor = 1.0;
        if (str == null || str.length() == 0) {
            return 0.0;
        }
        if (str.endsWith("%")) {
            str = str.substring(0, str.length() - 1);
        } else if (str.endsWith("px")) {
            str = str.substring(0, str.length() - 2);
        } else if (str.endsWith("pt")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 1.25;
        } else if (str.endsWith("pc")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 15.0;
        } else if (str.endsWith("mm")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 3.543307;
        } else if (str.endsWith("cm")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 35.43307;
        } else if (str.endsWith("in")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 90.0;
        } else if (str.endsWith("em")) {
            str = str.substring(0, str.length() - 2);
            ArrayList<Map<String, String>> styles = new ArrayList<Map<String, String>>();
            List<String> values = in.getInheritedAttribute("style");
            for (String v : values) {
                styles.add(SVGUtil.getStyles(v));
            }
            String value = SVGUtil.getInheritedAttribute("font-size", in, styles);
            if (value != null && !value.endsWith("em")) {
                scaleFactor = SVGUtil.getDimensionValue(in, value);
            }
        }
        return Double.parseDouble(str) * scaleFactor;
    }

    public static List<BezierPath> getPath(DOMInput in, String attributeName) throws IOException {
        return SVGUtil.fromPathData(in.getAttribute(attributeName, ""));
    }

    public static void setPath(DOMOutput out, String attributeName, BezierPath path) {
        out.addAttribute(attributeName, SVGUtil.toPathData(path));
    }

    public static String toPathData(BezierPath path) {
        StringBuilder buf = new StringBuilder();
        if (path.size() != 0) {
            if (path.size() == 1) {
                BezierPath.Node current = (BezierPath.Node)path.get(0);
                buf.append("M ");
                buf.append(current.x[0]);
                buf.append(' ');
                buf.append(current.y[0]);
                buf.append(" L ");
                buf.append(current.x[0]);
                buf.append(' ');
                buf.append(current.y[0] + 1.0);
            } else {
                BezierPath.Node current;
                BezierPath.Node previous = current = (BezierPath.Node)path.get(0);
                buf.append("M ");
                buf.append(current.x[0]);
                buf.append(' ');
                buf.append(current.y[0]);
                int n = path.size();
                for (int i = 1; i < n; ++i) {
                    previous = current;
                    current = (BezierPath.Node)path.get(i);
                    if ((previous.mask & 2) == 0) {
                        if ((current.mask & 1) == 0) {
                            buf.append(" L ");
                            buf.append(current.x[0]);
                            buf.append(' ');
                            buf.append(current.y[0]);
                            continue;
                        }
                        buf.append(" Q ");
                        buf.append(current.x[1]);
                        buf.append(' ');
                        buf.append(current.y[1]);
                        buf.append(' ');
                        buf.append(current.x[0]);
                        buf.append(' ');
                        buf.append(current.y[0]);
                        continue;
                    }
                    if ((current.mask & 1) == 0) {
                        buf.append(" Q ");
                        buf.append(current.x[2]);
                        buf.append(' ');
                        buf.append(current.y[2]);
                        buf.append(' ');
                        buf.append(current.x[0]);
                        buf.append(' ');
                        buf.append(current.y[0]);
                        continue;
                    }
                    buf.append(" C ");
                    buf.append(previous.x[2]);
                    buf.append(' ');
                    buf.append(previous.y[2]);
                    buf.append(' ');
                    buf.append(current.x[1]);
                    buf.append(' ');
                    buf.append(current.y[1]);
                    buf.append(' ');
                    buf.append(current.x[0]);
                    buf.append(' ');
                    buf.append(current.y[0]);
                }
                if (path.isClosed()) {
                    if (path.size() > 1) {
                        previous = (BezierPath.Node)path.get(path.size() - 1);
                        current = (BezierPath.Node)path.get(0);
                        if ((previous.mask & 2) == 0) {
                            if ((current.mask & 1) == 0) {
                                buf.append(" L ");
                                buf.append(current.x[0]);
                                buf.append(' ');
                                buf.append(current.y[0]);
                            } else {
                                buf.append(" Q ");
                                buf.append(current.x[1]);
                                buf.append(' ');
                                buf.append(current.y[1]);
                                buf.append(' ');
                                buf.append(current.x[0]);
                                buf.append(' ');
                                buf.append(current.y[0]);
                            }
                        } else if ((current.mask & 1) == 0) {
                            buf.append(" Q ");
                            buf.append(previous.x[2]);
                            buf.append(' ');
                            buf.append(previous.y[2]);
                            buf.append(' ');
                            buf.append(current.x[0]);
                            buf.append(' ');
                            buf.append(current.y[0]);
                        } else {
                            buf.append(" C ");
                            buf.append(previous.x[2]);
                            buf.append(' ');
                            buf.append(previous.y[2]);
                            buf.append(' ');
                            buf.append(current.x[1]);
                            buf.append(' ');
                            buf.append(current.y[1]);
                            buf.append(' ');
                            buf.append(current.x[0]);
                            buf.append(' ');
                            buf.append(current.y[0]);
                        }
                    }
                    buf.append(" Z");
                }
            }
        }
        return buf.toString();
    }

    public static List<BezierPath> fromPathData(String str) throws IOException {
        LinkedList<BezierPath> paths = new LinkedList<BezierPath>();
        ArrayList path = null;
        Point2D.Double p = new Point2D.Double();
        Point2D.Double c1 = new Point2D.Double();
        Point2D.Double c2 = new Point2D.Double();
        StreamTokenizer tt = new StreamTokenizer(new StringReader(str));
        tt.resetSyntax();
        tt.parseNumbers();
        tt.whitespaceChars(0, 32);
        tt.whitespaceChars(44, 44);
        int nextCommand = 77;
        int command = 77;
        block19: while (tt.nextToken() != -1) {
            if (tt.ttype > 0) {
                command = (char)tt.ttype;
            } else {
                command = nextCommand;
                tt.pushBack();
            }
            switch (command) {
                case 77: {
                    if (path != null) {
                        paths.add((BezierPath)path);
                    }
                    path = new BezierPath();
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).moveTo(p.x, p.y);
                    nextCommand = 76;
                    continue block19;
                }
                case 109: {
                    if (path != null) {
                        paths.add((BezierPath)path);
                    }
                    path = new BezierPath();
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).moveTo(p.x, p.y);
                    nextCommand = 108;
                    continue block19;
                }
                case 90: 
                case 122: {
                    p.x = ((BezierPath.Node)path.get((int)0)).x[0];
                    p.y = ((BezierPath.Node)path.get((int)0)).y[0];
                    ((BezierPath)path).setClosed(true);
                    continue block19;
                }
                case 76: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 76;
                    continue block19;
                }
                case 108: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 108;
                    continue block19;
                }
                case 72: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x = tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 72;
                    continue block19;
                }
                case 104: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x += tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 104;
                    continue block19;
                }
                case 86: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 86;
                    continue block19;
                }
                case 118: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 118;
                    continue block19;
                }
                case 67: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c1.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c1.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c2.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c2.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 67;
                    continue block19;
                }
                case 99: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c1.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c1.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c2.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c2.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 99;
                    continue block19;
                }
                case 83: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c2.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c2.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 83;
                    continue block19;
                }
                case 115: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c2.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c2.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 115;
                    continue block19;
                }
                case 81: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c1.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c1.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 81;
                    continue block19;
                }
                case 113: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c1.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    c1.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 113;
                    continue block19;
                }
                case 84: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 84;
                    continue block19;
                }
                case 116: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 115;
                    continue block19;
                }
            }
            throw new IOException("Illegal command: " + (char)command);
        }
        if (path != null) {
            paths.add((BezierPath)path);
        }
        return paths;
    }

    public static String getInheritedAttribute(String name, DOMInput in, List<Map<String, String>> styles) {
        List<String> values = in.getInheritedAttribute(name);
        for (int i = values.size() - 1; i >= 0; --i) {
            if (values.get(i) != null) {
                return values.get(i);
            }
            if (styles.get(i) == null || !styles.get(i).containsKey(name)) continue;
            return styles.get(i).get(name);
        }
        return null;
    }

    public static void readAttributes(Figure f, DOMInput in) throws IOException {
        Color color;
        ArrayList<Map<String, String>> styles = new ArrayList<Map<String, String>>();
        List<String> values = in.getInheritedAttribute("style");
        for (String v : values) {
            styles.add(SVGUtil.getStyles(v));
        }
        String value = SVGUtil.getInheritedAttribute("fill", in, styles);
        if (value != null && (color = SVGUtil.getColor(value)) != INHERIT_COLOR && color != CURRENT_COLOR) {
            AttributeKeys.FILL_COLOR.set(f, color);
        }
        if ((value = SVGUtil.getInheritedAttribute("fill-rule", in, styles)) != null) {
            AttributeKeys.WINDING_RULE.set(f, value.toUpperCase().equals("NONZERO") ? AttributeKeys.WindingRule.NON_ZERO : AttributeKeys.WindingRule.EVEN_ODD);
        } else {
            AttributeKeys.WINDING_RULE.set(f, AttributeKeys.WindingRule.NON_ZERO);
        }
        value = SVGUtil.getInheritedAttribute("stroke", in, styles);
        if (value != null && (color = SVGUtil.getColor(value)) != INHERIT_COLOR && color != CURRENT_COLOR) {
            AttributeKeys.STROKE_COLOR.set(f, color);
        }
        if ((value = SVGUtil.getInheritedAttribute("stroke-width", in, styles)) != null) {
            AttributeKeys.STROKE_WIDTH.set(f, Double.valueOf(value));
        }
        if ((value = SVGUtil.getInheritedAttribute("stroke-miterlimit", in, styles)) != null) {
            AttributeKeys.STROKE_MITER_LIMIT_FACTOR.set(f, Double.valueOf(value));
        }
        if ((value = SVGUtil.getInheritedAttribute("stroke-dasharray", in, styles)) != null) {
            StringTokenizer tt = new StringTokenizer(value, " ,");
            double[] dashes = new double[tt.countTokens()];
            int n = dashes.length;
            for (int i = 0; i < n; ++i) {
                dashes[i] = Double.valueOf(tt.nextToken());
            }
            AttributeKeys.STROKE_DASHES.set(f, dashes);
        }
        if ((value = SVGUtil.getInheritedAttribute("stroke-dashoffset", in, styles)) != null) {
            AttributeKeys.STROKE_DASH_PHASE.set(f, Math.abs(Double.valueOf(value)));
        }
        if ((value = SVGUtil.getInheritedAttribute("font-size", in, styles)) != null) {
            AttributeKeys.FONT_SIZE.set(f, SVGUtil.getDimensionValue(in, value));
        }
        if ((value = SVGUtil.getInheritedAttribute("text-anchor", in, styles)) != null) {
            SVGText.TEXT_ANCHOR.set(f, Enum.valueOf(SVGText.TextAnchor.class, value.toUpperCase()));
        }
    }

    public static Map<String, String> getStyles(String str) throws IOException {
        HashMap<String, String> styles = new HashMap<String, String>();
        if (str == null) {
            return styles;
        }
        StreamTokenizer tt = new StreamTokenizer(new StringReader(str));
        tt.resetSyntax();
        tt.wordChars(33, 57);
        tt.wordChars(60, 126);
        tt.wordChars(160, 255);
        tt.whitespaceChars(0, 32);
        while (tt.nextToken() != -1) {
            if (tt.ttype == 59) continue;
            if (tt.ttype != -3) {
                throw new IOException("Key token expected in " + str + " " + Integer.toHexString(tt.ttype));
            }
            String key = tt.sval;
            if (tt.nextToken() != 58) {
                throw new IOException("Colon expected after " + key + " in " + str);
            }
            if (tt.nextToken() != -3) {
                throw new IOException("Value token expected after " + key + " in " + str + " " + tt.ttype);
            }
            String value = tt.sval;
            while (tt.nextToken() == -3) {
                value = value + ' ' + tt.sval;
            }
            tt.pushBack();
            styles.put(key, value);
        }
        return styles;
    }

    public static Color getColor(String value) {
        if ((value = value.trim().toLowerCase()).equals("none")) {
            return null;
        }
        if (value.equals("currentColor")) {
            return CURRENT_COLOR;
        }
        if (value.equals("inherit")) {
            return INHERIT_COLOR;
        }
        if (SVG_COLORS.containsKey(value)) {
            return SVG_COLORS.get(value);
        }
        if (value.startsWith("#") && value.length() == 7) {
            return new Color(Integer.decode(value));
        }
        if (value.startsWith("#") && value.length() == 4) {
            int th = Integer.decode(value);
            return new Color(th & 0xF | (th & 0xF) << 4 | (th & 0xF0) << 4 | (th & 0xF0) << 8 | (th & 0xF00) << 8 | (th & 0xF00) << 12);
        }
        if (value.startsWith("rgb")) {
            StringTokenizer tt = new StringTokenizer(value, "() ,");
            tt.nextToken();
            Color c = new Color(Integer.decode(tt.nextToken()), Integer.decode(tt.nextToken()), Integer.decode(tt.nextToken()));
            return c;
        }
        return null;
    }

    public static void setDefaults(Figure f) {
        AttributeKeys.FILL_COLOR.set(f, Color.black);
        AttributeKeys.STROKE_COLOR.set(f, null);
        AttributeKeys.STROKE_DASH_FACTOR.set(f, 1.0);
    }

    public static void writeAttributes(Figure f, DOMOutput out) throws IOException {
        Double dbl;
        String value;
        Color color = AttributeKeys.FILL_COLOR.get(f);
        if (color == null) {
            value = "none";
        } else {
            value = "000000" + Integer.toHexString(color.getRGB());
            value = "#" + value.substring(value.length() - 6);
        }
        out.addAttribute("fill", value);
        if (AttributeKeys.WINDING_RULE.get(f) != AttributeKeys.WindingRule.NON_ZERO) {
            out.addAttribute("fill-rule", "evenodd");
        }
        if ((color = AttributeKeys.STROKE_COLOR.get(f)) == null) {
            value = "none";
        } else {
            value = "000000" + Integer.toHexString(color.getRGB());
            value = "#" + value.substring(value.length() - 6);
        }
        out.addAttribute("stroke", value);
        out.addAttribute("stroke-width", AttributeKeys.STROKE_WIDTH.get(f), 1.0);
        out.addAttribute("stroke-miterlimit", AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(f) / AttributeKeys.STROKE_WIDTH.get(f), 4.0);
        double[] dashes = AttributeKeys.STROKE_DASHES.get(f);
        Double d = dbl = AttributeKeys.STROKE_DASH_FACTOR.get(f) == null ? AttributeKeys.STROKE_WIDTH.get(f) : AttributeKeys.STROKE_DASH_FACTOR.get(f);
        if (dashes != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < dashes.length; ++i) {
                if (i != 0) {
                    buf.append(',');
                    buf.append(dashes[i] * dbl);
                }
                out.addAttribute("stroke-dasharray", buf.toString());
            }
        }
        out.addAttribute("stroke-dashoffset", AttributeKeys.STROKE_DASH_PHASE.get(f), 0.0);
        out.addAttribute("font-size", AttributeKeys.FONT_SIZE.get(f));
    }

    static {
        LinkedHashMap<String, Color> map = new LinkedHashMap<String, Color>();
        map.put("black", new Color(0, 0, 0));
        map.put("green", new Color(0, 128, 0));
        map.put("silver", new Color(192, 192, 192));
        map.put("lime", new Color(0, 255, 0));
        map.put("gray", new Color(128, 128, 128));
        map.put("olive", new Color(128, 128, 0));
        map.put("white", new Color(255, 255, 255));
        map.put("yellow", new Color(255, 255, 0));
        map.put("maroon", new Color(128, 0, 0));
        map.put("navy", new Color(0, 0, 128));
        map.put("red", new Color(255, 0, 0));
        map.put("blue", new Color(0, 0, 255));
        map.put("purple", new Color(128, 0, 128));
        map.put("teal", new Color(0, 128, 128));
        map.put("fuchsia", new Color(255, 0, 255));
        map.put("aqua", new Color(0, 255, 255));
        map.put("aliceblue", new Color(240, 248, 255));
        map.put("antiquewhite", new Color(250, 235, 215));
        map.put("aqua", new Color(0, 255, 255));
        map.put("aquamarine", new Color(127, 255, 212));
        map.put("azure", new Color(240, 255, 255));
        map.put("beige", new Color(245, 245, 220));
        map.put("bisque", new Color(255, 228, 196));
        map.put("black", new Color(0, 0, 0));
        map.put("blanchedalmond", new Color(255, 235, 205));
        map.put("blue", new Color(0, 0, 255));
        map.put("blueviolet", new Color(138, 43, 226));
        map.put("brown", new Color(165, 42, 42));
        map.put("burlywood", new Color(222, 184, 135));
        map.put("cadetblue", new Color(95, 158, 160));
        map.put("chartreuse", new Color(127, 255, 0));
        map.put("chocolate", new Color(210, 105, 30));
        map.put("coral", new Color(255, 127, 80));
        map.put("cornflowerblue", new Color(100, 149, 237));
        map.put("cornsilk", new Color(255, 248, 220));
        map.put("crimson", new Color(220, 20, 60));
        map.put("cyan", new Color(0, 255, 255));
        map.put("darkblue", new Color(0, 0, 139));
        map.put("darkcyan", new Color(0, 139, 139));
        map.put("darkgoldenrod", new Color(184, 134, 11));
        map.put("darkgray", new Color(169, 169, 169));
        map.put("darkgreen", new Color(0, 100, 0));
        map.put("darkgrey", new Color(169, 169, 169));
        map.put("darkkhaki", new Color(189, 183, 107));
        map.put("darkmagenta", new Color(139, 0, 139));
        map.put("darkolivegreen", new Color(85, 107, 47));
        map.put("darkorange", new Color(255, 140, 0));
        map.put("darkorchid", new Color(153, 50, 204));
        map.put("darkred", new Color(139, 0, 0));
        map.put("darksalmon", new Color(233, 150, 122));
        map.put("darkseagreen", new Color(143, 188, 143));
        map.put("darkslateblue", new Color(72, 61, 139));
        map.put("darkslategray", new Color(47, 79, 79));
        map.put("darkslategrey", new Color(47, 79, 79));
        map.put("darkturquoise", new Color(0, 206, 209));
        map.put("darkviolet", new Color(148, 0, 211));
        map.put("deeppink", new Color(255, 20, 147));
        map.put("deepskyblue", new Color(0, 191, 255));
        map.put("dimgray", new Color(105, 105, 105));
        map.put("dimgrey", new Color(105, 105, 105));
        map.put("dodgerblue", new Color(30, 144, 255));
        map.put("firebrick", new Color(178, 34, 34));
        map.put("floralwhite", new Color(255, 250, 240));
        map.put("forestgreen", new Color(34, 139, 34));
        map.put("fuchsia", new Color(255, 0, 255));
        map.put("gainsboro", new Color(220, 220, 220));
        map.put("ghostwhite", new Color(248, 248, 255));
        map.put("gold", new Color(255, 215, 0));
        map.put("goldenrod", new Color(218, 165, 32));
        map.put("gray", new Color(128, 128, 128));
        map.put("grey", new Color(128, 128, 128));
        map.put("green", new Color(0, 128, 0));
        map.put("greenyellow", new Color(173, 255, 47));
        map.put("honeydew", new Color(240, 255, 240));
        map.put("hotpink", new Color(255, 105, 180));
        map.put("indianred", new Color(205, 92, 92));
        map.put("indigo", new Color(75, 0, 130));
        map.put("ivory", new Color(255, 255, 240));
        map.put("khaki", new Color(240, 230, 140));
        map.put("lavender", new Color(230, 230, 250));
        map.put("lavenderblush", new Color(255, 240, 245));
        map.put("lawngreen", new Color(124, 252, 0));
        map.put("lemonchiffon", new Color(255, 250, 205));
        map.put("lightblue", new Color(173, 216, 230));
        map.put("lightcoral", new Color(240, 128, 128));
        map.put("lightcyan", new Color(224, 255, 255));
        map.put("lightgoldenrodyellow", new Color(250, 250, 210));
        map.put("lightgray", new Color(211, 211, 211));
        map.put("lightgreen", new Color(144, 238, 144));
        map.put("lightgrey", new Color(211, 211, 211));
        map.put("lightpink", new Color(255, 182, 193));
        map.put("lightsalmon", new Color(255, 160, 122));
        map.put("lightseagreen", new Color(32, 178, 170));
        map.put("lightskyblue", new Color(135, 206, 250));
        map.put("lightslategray", new Color(119, 136, 153));
        map.put("lightslategrey", new Color(119, 136, 153));
        map.put("lightsteelblue", new Color(176, 196, 222));
        map.put("lightyellow", new Color(255, 255, 224));
        map.put("lime", new Color(0, 255, 0));
        map.put("limegreen", new Color(50, 205, 50));
        map.put("linen", new Color(250, 240, 230));
        map.put("magenta", new Color(255, 0, 255));
        map.put("maroon", new Color(128, 0, 0));
        map.put("mediumaquamarine", new Color(102, 205, 170));
        map.put("mediumblue", new Color(0, 0, 205));
        map.put("mediumorchid", new Color(186, 85, 211));
        map.put("mediumpurple", new Color(147, 112, 219));
        map.put("mediumseagreen", new Color(60, 179, 113));
        map.put("mediumslateblue", new Color(123, 104, 238));
        map.put("mediumspringgreen", new Color(0, 250, 154));
        map.put("mediumturquoise", new Color(72, 209, 204));
        map.put("mediumvioletred", new Color(199, 21, 133));
        map.put("midnightblue", new Color(25, 25, 112));
        map.put("mintcream", new Color(245, 255, 250));
        map.put("mistyrose", new Color(255, 228, 225));
        map.put("moccasin", new Color(255, 228, 181));
        map.put("navajowhite", new Color(255, 222, 173));
        map.put("navy", new Color(0, 0, 128));
        map.put("oldlace", new Color(253, 245, 230));
        map.put("olive", new Color(128, 128, 0));
        map.put("olivedrab", new Color(107, 142, 35));
        map.put("orange", new Color(255, 165, 0));
        map.put("orangered", new Color(255, 69, 0));
        map.put("orchid", new Color(218, 112, 214));
        map.put("palegoldenrod", new Color(238, 232, 170));
        map.put("palegreen", new Color(152, 251, 152));
        map.put("paleturquoise", new Color(175, 238, 238));
        map.put("palevioletred", new Color(219, 112, 147));
        map.put("papayawhip", new Color(255, 239, 213));
        map.put("peachpuff", new Color(255, 218, 185));
        map.put("peru", new Color(205, 133, 63));
        map.put("pink", new Color(255, 192, 203));
        map.put("plum", new Color(221, 160, 221));
        map.put("powderblue", new Color(176, 224, 230));
        map.put("purple", new Color(128, 0, 128));
        map.put("red", new Color(255, 0, 0));
        map.put("rosybrown", new Color(188, 143, 143));
        map.put("royalblue", new Color(65, 105, 225));
        map.put("saddlebrown", new Color(139, 69, 19));
        map.put("salmon", new Color(250, 128, 114));
        map.put("sandybrown", new Color(244, 164, 96));
        map.put("seagreen", new Color(46, 139, 87));
        map.put("seashell", new Color(255, 245, 238));
        map.put("sienna", new Color(160, 82, 45));
        map.put("silver", new Color(192, 192, 192));
        map.put("skyblue", new Color(135, 206, 235));
        map.put("slateblue", new Color(106, 90, 205));
        map.put("slategray", new Color(112, 128, 144));
        map.put("slategrey", new Color(112, 128, 144));
        map.put("snow", new Color(255, 250, 250));
        map.put("springgreen", new Color(0, 255, 127));
        map.put("steelblue", new Color(70, 130, 180));
        map.put("tan", new Color(210, 180, 140));
        map.put("teal", new Color(0, 128, 128));
        map.put("thistle", new Color(216, 191, 216));
        map.put("tomato", new Color(255, 99, 71));
        map.put("turquoise", new Color(64, 224, 208));
        map.put("violet", new Color(238, 130, 238));
        map.put("wheat", new Color(245, 222, 179));
        map.put("white", new Color(255, 255, 255));
        map.put("whitesmoke", new Color(245, 245, 245));
        map.put("yellow", new Color(255, 255, 0));
        map.put("yellowgreen", new Color(154, 205, 50));
        map.put("activeborder", UIManager.getColor("activeCaptionBorder"));
        map.put("activecaption", UIManager.getColor("activeCaption"));
        map.put("appworkspace", UIManager.getColor("window"));
        map.put("background", UIManager.getColor("desktop"));
        map.put("buttonface", UIManager.getColor("control"));
        map.put("buttonhighlight", UIManager.getColor("controlHighlight"));
        map.put("buttonshadow", UIManager.getColor("controlShadow"));
        map.put("buttontext", UIManager.getColor("controlText"));
        map.put("captiontext", UIManager.getColor("activeCaptionText"));
        map.put("graytext", UIManager.getColor("textInactiveText"));
        map.put("highlight", UIManager.getColor("textHighlight"));
        map.put("highlighttext", UIManager.getColor("textHighlightText"));
        map.put("inactiveborder", UIManager.getColor("inactiveCaptionBorder"));
        map.put("inactivecaption", UIManager.getColor("inactiveCaption"));
        map.put("inactivecaptiontext", UIManager.getColor("inactiveCaptionText"));
        map.put("infobackground", UIManager.getColor("info"));
        map.put("infotext", UIManager.getColor("infoText"));
        map.put("menu", UIManager.getColor("menu"));
        map.put("menutext", UIManager.getColor("menuText"));
        map.put("scrollbar", UIManager.getColor("scrollbar"));
        map.put("threeddarkshadow", UIManager.getColor("controlDkShadow"));
        map.put("threedface", UIManager.getColor("control"));
        map.put("threedhighlight", UIManager.getColor("controlHighlight"));
        map.put("threedlightshadow", UIManager.getColor("controlLtHighlight"));
        map.put("threedshadow", UIManager.getColor("controlShadow"));
        map.put("window", UIManager.getColor("window"));
        map.put("windowframe", UIManager.getColor("windowBorder"));
        map.put("windowtext", UIManager.getColor("windowText"));
        SVG_COLORS = map;
        pathCommands = new HashSet<String>(Arrays.asList("M", "m", "Z", "z", "L", "l", "H", "h", "V", "v", "C", "c", "S", "s", "Q", "q", "T", "t"));
    }
}

