/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.EllipseFigure;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGEllipse
extends EllipseFigure
implements SVGFigure {
    public SVGEllipse() {
        SVGUtil.setDefaults(this);
    }

    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double r = this.getBounds();
        out.addAttribute("cx", r.x + r.width / 2.0);
        out.addAttribute("cy", r.y + r.height / 2.0);
        out.addAttribute("rx", r.width / 2.0);
        out.addAttribute("ry", r.height / 2.0);
        this.writeAttributes(out);
    }

    protected void writeAttributes(DOMOutput out) throws IOException {
        SVGUtil.writeAttributes(this, out);
    }

    public void read(DOMInput in) throws IOException {
        double rx;
        double ry;
        if (in.getTagName().equals("circle")) {
            rx = ry = SVGUtil.getDimension(in, "r");
        } else {
            rx = SVGUtil.getDimension(in, "rx");
            ry = SVGUtil.getDimension(in, "ry");
        }
        double x = SVGUtil.getDimension(in, "cx") - rx;
        double y = SVGUtil.getDimension(in, "cy") - ry;
        double w = rx * 2.0;
        double h = ry * 2.0;
        this.setBounds(new Point2D.Double(x, y), new Point2D.Double(x + w, y + h));
        this.readAttributes(in);
        AffineTransform tx = SVGUtil.getTransform(in, "transform");
        this.basicTransform(tx);
    }

    protected void readAttributes(DOMInput in) throws IOException {
        SVGUtil.readAttributes(this, in);
    }

    public boolean isEmpty() {
        Rectangle2D.Double b = this.getBounds();
        return b.width <= 0.0 || b.height <= 0.0;
    }
}

