/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.RotateHandle;
import org.jhotdraw.samples.svg.SVGDrawing;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGGroup
extends GroupFigure
implements SVGFigure {
    public SVGGroup() {
        SVGUtil.setDefaults(this);
    }

    public LinkedList<Handle> createHandles(int detailLevel) {
        LinkedList handles;
        if (detailLevel == 0) {
            handles = (LinkedList)super.createHandles(detailLevel);
            handles.add(new RotateHandle(this));
        } else {
            handles = new LinkedList();
        }
        return handles;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        this.readAttributes(in);
        int n = in.getElementCount();
        for (int i = 0; i < n; ++i) {
            in.openElement(i);
            String name = in.getTagName();
            if (name.equals("pattern")) {
                in.closeElement();
                continue;
            }
            if (name.equals("color-profile")) {
                in.closeElement();
                continue;
            }
            if (name.equals("defs")) {
                in.closeElement();
                continue;
            }
            if (name.equals("use")) {
                in.closeElement();
                continue;
            }
            if (name.equals("script")) {
                in.closeElement();
                continue;
            }
            if (name.equals("filter")) {
                in.closeElement();
                continue;
            }
            if (name.equals("title")) {
                in.closeElement();
                continue;
            }
            if (name.equals("desc")) {
                in.closeElement();
                continue;
            }
            if (name.equals("switch")) {
                in.closeElement();
                continue;
            }
            if (name.equals("radialGradient")) {
                in.closeElement();
                continue;
            }
            if (name.equals("linearGradient")) {
                in.closeElement();
                continue;
            }
            in.closeElement();
            Object f = in.readObject(i);
            if (f instanceof SVGDrawing) {
                SVGGroup g = new SVGGroup();
                g.willChange();
                for (Figure child : ((SVGDrawing)f).getFigures()) {
                    g.basicAdd(child);
                }
                g.changed();
                if (g.isEmpty()) continue;
                this.add(g);
                continue;
            }
            if (f instanceof SVGFigure) {
                if (((SVGFigure)f).isEmpty()) continue;
                this.add((SVGFigure)f);
                continue;
            }
            throw new IOException("Unexpected child " + f);
        }
        AffineTransform tx = SVGUtil.getTransform(in, "transform");
        for (Figure child : this.getChildren()) {
            child.basicTransform(tx);
        }
        this.invalidateBounds();
    }

    protected void readAttributes(DOMInput in) throws IOException {
        SVGUtil.readAttributes(this, in);
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        for (Figure child : this.getChildren()) {
            out.writeObject(child);
        }
        this.writeAttributes(out);
    }

    protected void writeAttributes(DOMOutput out) throws IOException {
        SVGUtil.writeAttributes(this, out);
    }

    @Override
    public boolean isEmpty() {
        return this.getChildCount() == 0;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        buf.append('@');
        buf.append(this.hashCode());
        if (this.getChildCount() > 0) {
            buf.append('(');
            Iterator<Figure> i = this.getChildren().iterator();
            while (i.hasNext()) {
                Figure child = i.next();
                buf.append(child);
                if (!i.hasNext()) continue;
                buf.append(',');
            }
            buf.append(')');
        }
        return buf.toString();
    }
}

