/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.LineFigure;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGLine
extends LineFigure
implements SVGFigure {
    public SVGLine() {
        SVGUtil.setDefaults(this);
    }

    public void write(DOMOutput out) throws IOException {
        out.addAttribute("x1", this.getPoint((int)0).x);
        out.addAttribute("y1", this.getPoint((int)0).y);
        out.addAttribute("x2", this.getPoint((int)1).x);
        out.addAttribute("y2", this.getPoint((int)1).y);
        this.writeAttributes(out);
    }

    protected void writeAttributes(DOMOutput out) throws IOException {
        SVGUtil.writeAttributes(this, out);
    }

    public void read(DOMInput in) throws IOException {
        this.setBounds(new Point2D.Double(SVGUtil.getDimension(in, "x1"), SVGUtil.getDimension(in, "y1")), new Point2D.Double(SVGUtil.getDimension(in, "x2"), SVGUtil.getDimension(in, "y2")));
        this.readAttributes(in);
        AffineTransform tx = SVGUtil.getTransform(in, "transform");
        this.basicTransform(tx);
    }

    protected void readAttributes(DOMInput in) throws IOException {
        SVGUtil.readAttributes(this, in);
    }

    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        return true;
    }

    public boolean isEmpty() {
        return false;
    }
}

