/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jhotdraw.draw.AbstractAttributedCompositeFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.RotateHandle;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGPath
extends AbstractAttributedCompositeFigure
implements SVGFigure {
    private GeneralPath path;

    public SVGPath() {
        this.add(new BezierFigure());
        SVGUtil.setDefaults(this);
    }

    @Override
    public void drawFigure(Graphics2D g) {
        this.validatePath();
        if (AttributeKeys.FILL_COLOR.get(this) != null) {
            g.setColor(AttributeKeys.FILL_COLOR.get(this));
            this.drawFill(g);
        }
        if (AttributeKeys.STROKE_COLOR.get(this) != null) {
            g.setStroke(AttributeKeys.getStroke(this));
            g.setColor(AttributeKeys.STROKE_COLOR.get(this));
            this.drawStroke(g);
        }
        if (this.isConnectorsVisible()) {
            this.drawConnectors(g);
        }
    }

    @Override
    public void drawFill(Graphics2D g) {
        if (this.getChildren().size() > 0) {
            g.fill(this.path);
        }
    }

    @Override
    public void drawStroke(Graphics2D g) {
        g.draw(this.path);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidatePath();
    }

    @Override
    protected void validate() {
        this.validatePath();
        super.validate();
    }

    protected void validatePath() {
        if (this.path == null) {
            this.path = new GeneralPath();
            this.path.setWindingRule(AttributeKeys.WINDING_RULE.get(this) == AttributeKeys.WindingRule.EVEN_ODD ? 0 : 1);
            for (Figure child : this.getChildren()) {
                BezierFigure b = (BezierFigure)child;
                this.path.append(b.getBezierPath(), false);
            }
        }
    }

    protected void invalidatePath() {
        this.path = null;
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        this.writePoints(out);
        this.writeAttributes(out);
    }

    protected void writePoints(DOMOutput out) {
        StringBuilder buf = new StringBuilder();
        for (Figure child : this.getChildren()) {
            BezierFigure b = (BezierFigure)child;
            buf.append(SVGUtil.toPathData(b.getBezierPath()));
        }
        out.addAttribute("d", buf.toString());
    }

    @Override
    protected void writeAttributes(DOMOutput out) throws IOException {
        SVGUtil.writeAttributes(this, out);
    }

    @Override
    public void read(DOMInput in) throws IOException {
        this.readPoints(in);
        this.readAttributes(in);
        AffineTransform tx = SVGUtil.getTransform(in, "transform");
        this.basicTransform(tx);
    }

    protected void readPoints(DOMInput in) throws IOException {
        this.removeAllChildren();
        if (in.getTagName().equals("polyline")) {
            BezierPath b = new BezierPath();
            String points = in.getAttribute("points", "");
            StringTokenizer tt = new StringTokenizer(points, " ,");
            while (tt.hasMoreTokens()) {
                b.add(new BezierPath.Node(Double.valueOf(tt.nextToken()), Double.valueOf(tt.nextToken())));
            }
            BezierFigure child = new BezierFigure();
            child.basicSetBezierPath(b);
            this.basicAdd(child);
        } else if (in.getTagName().equals("polygon")) {
            BezierPath b = new BezierPath();
            b.setClosed(true);
            String points = in.getAttribute("points", "");
            StringTokenizer tt = new StringTokenizer(points, " ,");
            while (tt.hasMoreTokens()) {
                b.add(new BezierPath.Node(Double.valueOf(tt.nextToken()), Double.valueOf(tt.nextToken())));
            }
            BezierFigure child = new BezierFigure();
            child.basicSetBezierPath(b);
            this.basicAdd(child);
        } else {
            List<BezierPath> paths = SVGUtil.getPath(in, "d");
            for (BezierPath b : paths) {
                BezierFigure child = new BezierFigure();
                child.basicSetBezierPath(b);
                this.basicAdd(child);
            }
            if (paths.size() == 0) {
                BezierFigure child = new BezierFigure();
                this.basicAdd(child);
            }
        }
    }

    @Override
    protected void readAttributes(DOMInput in) throws IOException {
        SVGUtil.readAttributes(this, in);
    }

    @Override
    public void basicTransform(AffineTransform tx) {
        super.basicTransform(tx);
        this.invalidatePath();
    }

    @Override
    public boolean isEmpty() {
        for (Figure child : this.getChildren()) {
            BezierFigure b = (BezierFigure)child;
            if (b.getPointCount() <= 0) continue;
            return false;
        }
        return true;
    }

    public LinkedList<Handle> createHandles(int detailLevel) {
        LinkedList handles;
        if (detailLevel == 0) {
            handles = (LinkedList)super.createHandles(detailLevel);
            handles.add(new RotateHandle(this));
        } else {
            handles = new LinkedList();
            for (Figure child : this.getChildren()) {
                handles.addAll(child.createHandles(detailLevel));
            }
        }
        return handles;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
        LinkedList<Action> actions = new LinkedList<Action>();
        actions.add(new AbstractAction(labels.getString("closePath")){

            public void actionPerformed(ActionEvent evt) {
                for (Figure child : SVGPath.this.getChildren()) {
                    BezierFigure b = (BezierFigure)child;
                    b.setClosed(true);
                }
            }
        });
        actions.add(new AbstractAction(labels.getString("openPath")){

            public void actionPerformed(ActionEvent evt) {
                for (Figure child : SVGPath.this.getChildren()) {
                    BezierFigure b = (BezierFigure)child;
                    b.setClosed(false);
                }
            }
        });
        actions.add(new AbstractAction(labels.getString("windingEvenOdd")){

            public void actionPerformed(ActionEvent evt) {
                AttributeKeys.WINDING_RULE.set(SVGPath.this, AttributeKeys.WindingRule.EVEN_ODD);
            }
        });
        actions.add(new AbstractAction(labels.getString("windingNonZero")){

            public void actionPerformed(ActionEvent evt) {
                AttributeKeys.WINDING_RULE.set(SVGPath.this, AttributeKeys.WindingRule.NON_ZERO);
            }
        });
        return actions;
    }
}

