/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.RoundRectangleFigure;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGRect
extends RoundRectangleFigure
implements SVGFigure {
    public SVGRect() {
        SVGUtil.setDefaults(this);
    }

    public void read(DOMInput in) throws IOException {
        double x = SVGUtil.getDimension(in, "x");
        double y = SVGUtil.getDimension(in, "y");
        double w = SVGUtil.getDimension(in, "width");
        double h = SVGUtil.getDimension(in, "height");
        this.setBounds(new Point2D.Double(x, y), new Point2D.Double(x + w, y + h));
        this.setArc(SVGUtil.getDimension(in, "rx"), SVGUtil.getDimension(in, "ry"));
        this.readAttributes(in);
        AffineTransform tx = SVGUtil.getTransform(in, "transform");
        this.basicTransform(tx);
    }

    protected void readAttributes(DOMInput in) throws IOException {
        SVGUtil.readAttributes(this, in);
    }

    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double r = this.getBounds();
        out.addAttribute("x", r.x);
        out.addAttribute("y", r.y);
        out.addAttribute("width", r.width);
        out.addAttribute("height", r.height);
        out.addAttribute("rx", this.getArcWidth());
        out.addAttribute("ry", this.getArcHeight());
        this.writeAttributes(out);
    }

    protected void writeAttributes(DOMOutput out) throws IOException {
        SVGUtil.writeAttributes(this, out);
    }

    public boolean isEmpty() {
        Rectangle2D.Double b = this.getBounds();
        return b.width <= 0.0 || b.height <= 0.0;
    }
}

