/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGText
extends TextFigure
implements SVGFigure {
    public static final AttributeKey<TextAnchor> TEXT_ANCHOR = new AttributeKey<TextAnchor>("textAnchor", TextAnchor.START, false);

    public SVGText() {
        SVGUtil.setDefaults(this);
    }

    protected void drawStroke(Graphics2D g) {
        if (this.getText() != null || this.isEditable()) {
            Rectangle2D.Double bounds = this.getBounds();
            TextLayout layout = this.getTextLayout();
            AffineTransform tx = new AffineTransform();
            tx.translate(this.origin.x, this.origin.y + (double)layout.getAscent());
            Shape outline = layout.getOutline(tx);
            g.draw(outline);
        }
    }

    protected void drawFill(Graphics2D g) {
        if (this.getText() != null || this.isEditable()) {
            TextLayout layout = this.getTextLayout();
            layout.draw(g, (float)this.origin.x, (float)(this.origin.y + (double)layout.getAscent()));
        }
    }

    protected void drawText(Graphics2D g) {
    }

    public void write(DOMOutput out) {
        out.addAttribute("x", this.origin.x);
        out.addAttribute("y", this.origin.y);
        out.addText(this.getText());
    }

    protected void writeAttributes(DOMOutput out) throws IOException {
        SVGUtil.writeAttributes(this, out);
    }

    public void read(DOMInput in) throws IOException {
        this.origin.x = SVGUtil.getDimension(in, "x");
        this.origin.y = SVGUtil.getDimension(in, "y");
        this.setText(in.getText());
        this.readAttributes(in);
        AffineTransform tx = SVGUtil.getTransform(in, "transform");
        this.basicTransform(tx);
        Rectangle2D.Double r = this.getBounds();
        switch (TEXT_ANCHOR.get(this)) {
            case START: {
                break;
            }
            case MIDDLE: {
                this.origin.x -= r.width / 2.0;
                break;
            }
            case END: {
                this.origin.x -= r.width;
            }
        }
        this.origin.y -= AttributeKeys.FONT_SIZE.get(this).doubleValue();
    }

    protected void readAttributes(DOMInput in) throws IOException {
        SVGUtil.readAttributes(this, in);
    }

    public Color getTextColor() {
        return AttributeKeys.FILL_COLOR.get(this);
    }

    public Color getFillColor() {
        return Color.white;
    }

    public boolean isEmpty() {
        return this.getText() == null || this.getText().length() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextAnchor {
        START,
        MIDDLE,
        END;

    }
}

