/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import nanoxml.XMLElement;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMStorable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NanoXMLLiteDOMInput
implements DOMInput {
    private HashMap<String, Object> idobjects = new HashMap();
    private XMLElement document;
    private XMLElement current;
    private DOMFactory factory;
    private Stack<XMLElement> stack = new Stack();

    public NanoXMLLiteDOMInput(DOMFactory factory, InputStream in) throws IOException {
        this(factory, new InputStreamReader(in, "UTF8"));
    }

    public NanoXMLLiteDOMInput(DOMFactory factory, Reader in) throws IOException {
        this.factory = factory;
        HashMap entities = new HashMap();
        this.current = new XMLElement(entities, false, false);
        this.current.parseFromReader(in);
        this.document = new XMLElement(entities, false, false);
        this.document.addChild(this.current);
        this.current = this.document;
    }

    @Override
    public String getTagName() {
        return this.current.getName();
    }

    @Override
    public String getAttribute(String name, String defaultValue) {
        String value = (String)this.current.getAttribute(name);
        return value == null || value.length() == 0 ? defaultValue : value;
    }

    @Override
    public String getText() {
        return this.getText(null);
    }

    @Override
    public String getText(String defaultValue) {
        String value = this.current.getContent();
        return value == null ? defaultValue : value;
    }

    @Override
    public List<String> getInheritedAttribute(String name) {
        LinkedList<String> values = new LinkedList<String>();
        for (XMLElement node : this.stack) {
            String value = (String)node.getAttribute(name);
            values.add(value);
        }
        String value = (String)this.current.getAttribute(name);
        values.add(value);
        return values;
    }

    @Override
    public int getAttribute(String name, int defaultValue) {
        String value = (String)this.current.getAttribute(name);
        return value == null || value.length() == 0 ? defaultValue : Long.decode(value).intValue();
    }

    @Override
    public double getAttribute(String name, double defaultValue) {
        String value = (String)this.current.getAttribute(name);
        return value == null || value.length() == 0 ? defaultValue : Double.parseDouble(value);
    }

    @Override
    public boolean getAttribute(String name, boolean defaultValue) {
        String value = (String)this.current.getAttribute(name);
        return value == null || value.length() == 0 ? defaultValue : Boolean.valueOf(value);
    }

    @Override
    public int getElementCount() {
        return this.current.countChildren();
    }

    @Override
    public int getElementCount(String tagName) {
        int count = 0;
        ArrayList list = this.current.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            XMLElement node = (XMLElement)list.get(i);
            if (!node.getName().equals(tagName)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void openElement(int index) {
        this.stack.push(this.current);
        ArrayList list = this.current.getChildren();
        this.current = (XMLElement)list.get(index);
    }

    @Override
    public void openElement(String tagName) {
        ArrayList list = this.current.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            XMLElement node = (XMLElement)list.get(i);
            if (!node.getName().equals(tagName)) continue;
            this.stack.push(this.current);
            this.current = node;
            return;
        }
        throw new IllegalArgumentException("no such element:" + tagName);
    }

    @Override
    public void openElement(String tagName, int index) {
        int count = 0;
        ArrayList list = this.current.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            XMLElement node = (XMLElement)list.get(i);
            if (!node.getName().equals(tagName) || count++ != index) continue;
            this.stack.push(this.current);
            this.current = node;
            return;
        }
        throw new IllegalArgumentException("no such element:" + tagName + " at index:" + index);
    }

    @Override
    public void closeElement() {
        this.current = this.stack.pop();
    }

    @Override
    public Object readObject() throws IOException {
        return this.readObject(0);
    }

    @Override
    public Object readObject(int index) throws IOException {
        Object o;
        this.openElement(index);
        String tagName = this.getTagName();
        if (tagName.equals("null")) {
            o = null;
        } else if (tagName.equals("string")) {
            o = this.getText();
        } else if (tagName.equals("int")) {
            o = Integer.decode(this.getText());
        } else if (tagName.equals("long")) {
            o = Long.decode(this.getText());
        } else if (tagName.equals("float")) {
            o = new Float(Float.parseFloat(this.getText()));
        } else if (tagName.equals("double")) {
            o = new Double(Double.parseDouble(this.getText()));
        } else if (tagName.equals("boolean")) {
            o = Boolean.valueOf(this.getText());
        } else if (tagName.equals("color")) {
            o = new Color(this.getAttribute("rgba", 255));
        } else if (tagName.equals("intArray")) {
            int[] a = new int[this.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = (Integer)this.readObject(i);
            }
            o = a;
        } else if (tagName.equals("floatArray")) {
            float[] a = new float[this.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = ((Float)this.readObject(i)).floatValue();
            }
            o = a;
        } else if (tagName.equals("doubleArray")) {
            double[] a = new double[this.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = (Double)this.readObject(i);
            }
            o = a;
        } else if (tagName.equals("font")) {
            o = new Font(this.getAttribute("name", "Dialog"), this.getAttribute("style", 0), this.getAttribute("size", 0));
        } else if (tagName.equals("enum")) {
            o = this.factory.createEnum(this.getAttribute("type", null), this.getText());
        } else {
            String ref = this.getAttribute("ref", null);
            String id = this.getAttribute("id", ref);
            if (id == null) {
                o = this.factory.create(this.getTagName());
            } else if (this.idobjects.containsKey(id)) {
                o = this.idobjects.get(id);
            } else {
                o = this.factory.create(this.getTagName());
                this.idobjects.put(id, o);
            }
            if (ref == null && o instanceof DOMStorable) {
                ((DOMStorable)o).read(this);
            }
        }
        this.closeElement();
        return o;
    }
}

