/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.rat.annotation.BOMInputStream;

public abstract class AbstractLicenceAppender {
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_JAVA = 1;
    private static final int TYPE_XML = 2;
    private static final int TYPE_HTML = 3;
    private static final int TYPE_CSS = 4;
    private static final int TYPE_JAVASCRIPT = 5;
    private static final int TYPE_APT = 6;
    private static final int TYPE_PROPERTIES = 7;
    private static final int TYPE_PYTHON = 8;
    private static final int TYPE_C = 9;
    private static final int TYPE_H = 10;
    private static final int TYPE_SH = 11;
    private static final int TYPE_BAT = 12;
    private static final int TYPE_VM = 13;
    private static final int TYPE_SCALA = 14;
    private static final int TYPE_RUBY = 15;
    private static final int TYPE_PERL = 16;
    private static final int TYPE_TCL = 17;
    private static final int TYPE_CPP = 18;
    private static final int TYPE_CSHARP = 19;
    private static final int TYPE_PHP = 20;
    private static final int TYPE_GROOVY = 21;
    private static final int TYPE_VISUAL_STUDIO_SOLUTION = 22;
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final int[] FAMILY_C = new int[]{1, 5, 9, 10, 14, 4, 18, 19, 20, 21};
    private static final int[] FAMILY_SGML = new int[]{2, 3};
    private static final int[] FAMILY_SH = new int[]{7, 8, 11, 15, 16, 17, 22};
    private static final int[] FAMILY_BAT = new int[]{12};
    private static final int[] FAMILY_APT = new int[]{6};
    private static final int[] FAMILY_VELOCITY = new int[]{13};
    private static final int[] EXPECTS_HASH_PLING = new int[]{8, 11, 15, 16, 17};
    private static final int[] EXPECTS_AT_ECHO = new int[]{12};
    private static final int[] EXPECTS_PACKAGE = new int[]{1};
    private static final int[] EXPECTS_XML_DECL = new int[]{2};
    private static final int[] EXPECTS_PHP_PI = new int[]{20};
    private static final int[] EXPECTS_MSVSSF_HEADER = new int[]{22};
    private static final Map<String, Integer> EXT2TYPE = new HashMap<String, Integer>();
    private boolean isForced;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(File document) throws IOException {
        int type = this.getType(document);
        if (type == 0) {
            return;
        }
        boolean expectsHashPling = AbstractLicenceAppender.expectsHashPling(type);
        boolean expectsAtEcho = AbstractLicenceAppender.expectsAtEcho(type);
        boolean expectsPackage = AbstractLicenceAppender.expectsPackage(type);
        boolean expectsXMLDecl = AbstractLicenceAppender.expectsXMLDecl(type);
        boolean expectsPhpPI = AbstractLicenceAppender.expectsPhpPI(type);
        boolean expectsMSVSSF = AbstractLicenceAppender.expectsMSVisualStudioSolutionFileHeader(type);
        File newDocument = new File(document.getAbsolutePath() + ".new");
        FileWriter writer = new FileWriter(newDocument);
        try {
            if (!this.attachLicense(writer, document, expectsHashPling, expectsAtEcho, expectsPackage, expectsXMLDecl, expectsPhpPI, expectsMSVSSF) && (expectsPackage || expectsXMLDecl)) {
                writer = new FileWriter(newDocument);
                if (expectsXMLDecl) {
                    writer.write("<?xml version='1.0'?>");
                    writer.write(LINE_SEP);
                }
                this.attachLicense(writer, document, false, false, false, false, false, false);
            }
        }
        finally {
            writer.close();
        }
        if (this.isForced) {
            document.delete();
            boolean renamed = newDocument.renameTo(document.getAbsoluteFile());
            if (!renamed) {
                System.err.println("Failed to rename new file, original file remains unchanged.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attachLicense(Writer writer, File document, boolean expectsHashPling, boolean expectsAtEcho, boolean expectsPackage, boolean expectsXMLDecl, boolean expectsPhpPI, boolean expectsMSVSSF) throws IOException {
        boolean written = false;
        try {
            FileInputStream fis = new FileInputStream(document);
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(new BOMInputStream(fis)));
                if (!(expectsHashPling || expectsAtEcho || expectsPackage || expectsXMLDecl || expectsPhpPI || expectsMSVSSF)) {
                    written = true;
                    writer.write(this.getLicenceHeader(document));
                    writer.write(LINE_SEP);
                }
                boolean first = true;
                while ((line = br.readLine()) != null) {
                    if (first && expectsHashPling) {
                        written = true;
                        this.doFirstLine(document, writer, line, "#!");
                    } else if (first && expectsAtEcho) {
                        written = true;
                        this.doFirstLine(document, writer, line, "@echo");
                    } else if (first && expectsMSVSSF) {
                        written = true;
                        if ("".equals(line)) {
                            line = this.passThroughReadNext(writer, line, br);
                        }
                        if (line.startsWith("Microsoft Visual Studio Solution File")) {
                            line = this.passThroughReadNext(writer, line, br);
                        }
                        this.doFirstLine(document, writer, line, "# Visual ");
                    } else {
                        writer.write(line);
                        writer.write(LINE_SEP);
                    }
                    if (expectsPackage && line.startsWith("package ")) {
                        written = true;
                        writer.write(this.getLicenceHeader(document));
                        writer.write(LINE_SEP);
                    } else if (expectsXMLDecl && line.startsWith("<?xml ")) {
                        written = true;
                        writer.write(this.getLicenceHeader(document));
                        writer.write(LINE_SEP);
                    } else if (expectsPhpPI && line.startsWith("<?php")) {
                        written = true;
                        writer.write(this.getLicenceHeader(document));
                        writer.write(LINE_SEP);
                    }
                    first = false;
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
                fis.close();
            }
        }
        finally {
            writer.close();
        }
        return written;
    }

    private void doFirstLine(File document, Writer writer, String line, String lookfor) throws IOException {
        if (line.startsWith(lookfor)) {
            writer.write(line);
            writer.write(LINE_SEP);
            writer.write(this.getLicenceHeader(document));
        } else {
            writer.write(this.getLicenceHeader(document));
            writer.write(line);
            writer.write(LINE_SEP);
        }
    }

    protected int getType(File document) {
        String ext;
        Integer type;
        String path = document.getPath();
        int lastDot = path.lastIndexOf(".");
        if (lastDot >= 0 && lastDot < path.length() - 1 && (type = EXT2TYPE.get(ext = path.substring(lastDot + 1))) != null) {
            return type;
        }
        return 0;
    }

    public void setForce(boolean b) {
        this.isForced = b;
    }

    public abstract String getLicenceHeader(File var1);

    protected String getFirstLine(int type) {
        if (AbstractLicenceAppender.isFamilyC(type)) {
            return "/*" + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilySGML(type)) {
            return "<!--" + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilyAPT(type)) {
            return "~~" + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilySH(type)) {
            return "#" + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilyBAT(type)) {
            return "rem" + LINE_SEP;
        }
        return "";
    }

    protected String getLastLine(int type) {
        if (AbstractLicenceAppender.isFamilyC(type)) {
            return "*/" + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilySGML(type)) {
            return "-->" + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilyAPT(type)) {
            return "~~" + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilySH(type)) {
            return "#" + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilyBAT(type)) {
            return "rem" + LINE_SEP;
        }
        return "";
    }

    protected String getLine(int type, String content) {
        if (content != null && content.length() > 0) {
            content = " " + content;
        }
        if (AbstractLicenceAppender.isFamilyC(type)) {
            return " *" + content + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilySGML(type)) {
            return content + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilyAPT(type)) {
            return "~~" + content + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilySH(type)) {
            return "#" + content + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilyBAT(type)) {
            return "rem" + content + LINE_SEP;
        }
        if (AbstractLicenceAppender.isFamilyVelocity(type)) {
            return "##" + content + LINE_SEP;
        }
        return "";
    }

    private static boolean isFamilyC(int type) {
        return AbstractLicenceAppender.isIn(FAMILY_C, type);
    }

    private static boolean isFamilySGML(int type) {
        return AbstractLicenceAppender.isIn(FAMILY_SGML, type);
    }

    private static boolean isFamilySH(int type) {
        return AbstractLicenceAppender.isIn(FAMILY_SH, type);
    }

    private static boolean isFamilyAPT(int type) {
        return AbstractLicenceAppender.isIn(FAMILY_APT, type);
    }

    private static boolean isFamilyBAT(int type) {
        return AbstractLicenceAppender.isIn(FAMILY_BAT, type);
    }

    private static boolean isFamilyVelocity(int type) {
        return AbstractLicenceAppender.isIn(FAMILY_VELOCITY, type);
    }

    private static boolean expectsHashPling(int type) {
        return AbstractLicenceAppender.isIn(EXPECTS_HASH_PLING, type);
    }

    private static boolean expectsAtEcho(int type) {
        return AbstractLicenceAppender.isIn(EXPECTS_AT_ECHO, type);
    }

    private static boolean expectsPackage(int type) {
        return AbstractLicenceAppender.isIn(EXPECTS_PACKAGE, type);
    }

    private static boolean expectsXMLDecl(int type) {
        return AbstractLicenceAppender.isIn(EXPECTS_XML_DECL, type);
    }

    private static boolean expectsPhpPI(int type) {
        return AbstractLicenceAppender.isIn(EXPECTS_PHP_PI, type);
    }

    private static boolean expectsMSVisualStudioSolutionFileHeader(int type) {
        return AbstractLicenceAppender.isIn(EXPECTS_MSVSSF_HEADER, type);
    }

    private static boolean isIn(int[] arr, int key) {
        return Arrays.binarySearch(arr, key) >= 0;
    }

    private String passThroughReadNext(Writer writer, String line, BufferedReader br) throws IOException {
        writer.write(line);
        writer.write(LINE_SEP);
        String l = br.readLine();
        return l == null ? "" : l;
    }

    static {
        Arrays.sort(FAMILY_C);
        Arrays.sort(FAMILY_SGML);
        Arrays.sort(FAMILY_SH);
        Arrays.sort(FAMILY_BAT);
        Arrays.sort(FAMILY_APT);
        Arrays.sort(FAMILY_VELOCITY);
        Arrays.sort(EXPECTS_HASH_PLING);
        Arrays.sort(EXPECTS_AT_ECHO);
        Arrays.sort(EXPECTS_PACKAGE);
        Arrays.sort(EXPECTS_XML_DECL);
        Arrays.sort(EXPECTS_MSVSSF_HEADER);
        EXT2TYPE.put("apt", 6);
        EXT2TYPE.put("asax", 3);
        EXT2TYPE.put("ascx", 3);
        EXT2TYPE.put("aspx", 3);
        EXT2TYPE.put("bat", 12);
        EXT2TYPE.put("c", 9);
        EXT2TYPE.put("cc", 18);
        EXT2TYPE.put("cmd", 12);
        EXT2TYPE.put("config", 2);
        EXT2TYPE.put("cpp", 18);
        EXT2TYPE.put("cs", 19);
        EXT2TYPE.put("csdproj", 2);
        EXT2TYPE.put("csproj", 2);
        EXT2TYPE.put("css", 4);
        EXT2TYPE.put("fxcop", 2);
        EXT2TYPE.put("groovy", 21);
        EXT2TYPE.put("h", 10);
        EXT2TYPE.put("hh", 10);
        EXT2TYPE.put("hpp", 10);
        EXT2TYPE.put("htm", 3);
        EXT2TYPE.put("html", 3);
        EXT2TYPE.put("java", 1);
        EXT2TYPE.put("js", 5);
        EXT2TYPE.put("ndoc", 2);
        EXT2TYPE.put("nunit", 2);
        EXT2TYPE.put("php", 20);
        EXT2TYPE.put("pl", 16);
        EXT2TYPE.put("properties", 7);
        EXT2TYPE.put("py", 8);
        EXT2TYPE.put("rb", 15);
        EXT2TYPE.put("rdf", 2);
        EXT2TYPE.put("resx", 2);
        EXT2TYPE.put("scala", 14);
        EXT2TYPE.put("sh", 11);
        EXT2TYPE.put("shfbproj", 2);
        EXT2TYPE.put("sln", 22);
        EXT2TYPE.put("stylecop", 2);
        EXT2TYPE.put("svg", 2);
        EXT2TYPE.put("tcl", 17);
        EXT2TYPE.put("vbdproj", 2);
        EXT2TYPE.put("vbproj", 2);
        EXT2TYPE.put("vcproj", 2);
        EXT2TYPE.put("vm", 13);
        EXT2TYPE.put("vsdisco", 2);
        EXT2TYPE.put("webinfo", 2);
        EXT2TYPE.put("xml", 2);
        EXT2TYPE.put("xsl", 2);
    }
}

